int latchPin = 6;   //ATMega328p-au(10) digital pin 6 for latch pin
int clockPin = 8;   //ATMega328p-au(12) digital pin 8 for clock pin
int dataPin = 5;    //ATMega328p-au(9) digital pin 5 for data pin

#define LED_COUNT 30
#define LED_CHANNELS 3
#define BYTE_COUNT 12

char LEDS[LED_COUNT][LED_CHANNELS]; //only 90 LEDs, but 96 shift register bits
//star 0 is top, increasing anti-clockwise
//second index is red/green/blue element

char dataBits[BYTE_COUNT]={0,0,0,0,0,0,0,0,0,0,0,0};  //12x8 bits=96

const int LED_map[LED_COUNT][LED_CHANNELS] PROGMEM={  //list of bit indices
  {0,1,2},  {5,4,3},  {6,7,8},  {11,10,9},  {12,13,14},  {15,16,17},
  {18,19,20},  {23,22,21},  {26,25,24},  {27,28,29},  {30,31,32},  {33,34,35},
  {36,37,38},  {39,40,41},  {42,43,44},  {47,46,45},  {49,50,51},  {52,53,54},
  {55,57,58},  {59,60,61},  {62,63,65},  {66,67,68},  {69,70,71},  {73,74,75},
  {76,77,78},  {79,72,81},  {82,83,84},  {85,86,87},  {89,90,91},  {92,93,94}
};

char simpleColours[7][3]={
  {1,0,0},  //red
  {1,1,0},  //yellow
  {0,1,0},  //green
  {0,1,1},  //cyan
  {0,0,1},  //blue
  {1,0,1},  //magenta
  {1,1,1}   //white
};

void setup() {
  int i;
  pinMode (latchPin,OUTPUT);    // Latch pin
  pinMode (clockPin,OUTPUT);    // Clock pin
  pinMode (dataPin, OUTPUT);    // Data pin
  sendBits();                   // send off state
  for(i=0;i<LED_COUNT;i++){
    setLEDcolour(i,0);  //red
  }
  sendBits();                   // send state
  delay(2000);  
  for(i=0;i<LED_COUNT;i++){
    setLEDcolour(i,2);  //green
  }
  sendBits();                   // send state
  delay(2000);  
  for(i=0;i<LED_COUNT;i++){
    setLEDcolour(i,4);  //blue
  }
  sendBits();                   // send state
  delay(2000);  
}

void loop() {
  clockSequence();
  pause(1000);          
  twinkleSequence(100,100);
  pause(1000);        
  glowSequence();   //this is quite short so repeat
  glowSequence();
  glowSequence();
  pause(1000);        
  rainbowSequence(120,150);
  pause(1000);      
  snakeSequence();
  pause(1000);    
  flashSequence();
  pause(1000);  
  chaseSequence(3);
  pause(1000);
  randomSequence(40,500);
  pause(1000);
  starBurstSequence(3);
  pause(1000);
  rainbowFade(30000L);  
  pause(1000);
}

void pause(int t){    //some rest for the eyes
  clearAll();
  mapBits();
  sendBits();
  delay(t);      
}

void clockSequence(){
  clockCycle(1,0,0,100);
  clockCycle(1,1,0,100);
  clockCycle(0,1,0,100);
  clockCycle(0,1,1,100);
  clockCycle(0,0,1,100);
  clockCycle(1,0,1,100);
  clockCycle(1,1,1,100);
}

void clockCycle(char r,char g, char b, int t){   //full sweep of circle
  int i;
  for(i=0;i<LED_COUNT;i++){
    clearAll();
    setSnake(r,g,b,0,i);
    mapBits();
    sendBits();
    delay(t);
  }
  for(i=0;i<LED_COUNT;i++){
    clearAll();
    setSnake(r,g,b,i,LED_COUNT-i);
    mapBits();
    sendBits();
    delay(t);
  }
}

void randomSequence(int n, int t){  //n cycles with t delay between
  int i;
  for(i=0;i<n;i++){
    allRandom();
    delay(t);
  }  
}

void allRandom(){   //set all LEDs on to random colours
  int i;
  char c;
  clearAll();
  for(i=0;i<LED_COUNT;i++){
    c=random(7);
    LEDS[i][0]=simpleColours[c][0];
    LEDS[i][1]=simpleColours[c][1];
    LEDS[i][2]=simpleColours[c][2];      
  }
  mapBits();
  sendBits();
}

void twinkle(){   //set a single random LED to a random RGB colour
  char c,s;
  c=random(7);
  s=random(LED_COUNT);
  LEDS[s][0]=simpleColours[c][0];
  LEDS[s][1]=simpleColours[c][1];
  LEDS[s][2]=simpleColours[c][2];  
}

void twinkleSequence(int n, int t){   //n twinkles with delay t
  int i;
  for(i=0;i<n;i++){
    clearAll();
    twinkle();
    mapBits();
    sendBits();
    delay(t);      
    clearAll();
    mapBits();
    sendBits();
    delay(t);      
  }
}

void glowSequence(){
  glow(1,0,0,6);
  glow(1,1,0,6);
  glow(0,1,0,6);
  glow(0,1,1,6);
  glow(0,0,1,6);
  glow(1,0,1,6);
  glow(1,1,1,6);
}

void glow(char r, char g, char b,int n){    //n is speed/time parameter
  int i,j,k;
  for(i=0;i<n;i++){
    for(k=0;k<n;k++){
      for(j=0;j<n;j++){
        if(i<j){
          clearAll();
          mapBits();
          sendBits();        
        }else{
          setAll(r,g,b);
          mapBits();
          sendBits();        
        }
      }
    }
  }
  for(i=i;i>0;i--){
    for(k=0;k<n;k++){
      for(j=0;j<n;j++){
        if(i<j){
          clearAll();
          mapBits();
          sendBits();        
        }else{
          setAll(r,g,b);
          mapBits();
          sendBits();        
        }
      }
    }
  }
}

void rainbowSequence(int n, int t){
  int i;
  for(i=0;i<n;i++){
    rainbowLoop(i%6);
    mapBits();
    sendBits();
    delay(t);      
  }
}

void rainbowLoop(char n){   //set entire star to one of six rainbow colour phases
  int i,j;
  clearAll();
  for(i=0;i<LED_COUNT;i=i+6){
    for(j=0;j<6;j++){
      setLEDcolour((i+n+j)%LED_COUNT,j);
    }
  }
}

void setLEDcolour(char n, char c){  //indexed colour c into n
  LEDS[n][0]=simpleColours[c][0];
  LEDS[n][1]=simpleColours[c][1];
  LEDS[n][2]=simpleColours[c][2];
}

void snakeSequence(){
  snakeCycle(1,0,0,200,2);
  snakeCycle(1,1,0,200,2);
  snakeCycle(0,1,0,200,2);
  snakeCycle(0,1,1,200,2);
  snakeCycle(0,0,1,200,2);
  snakeCycle(1,0,1,200,2);  
}

void snakeCycle(char r, char g, char b, int t, int n){        //move group of LEDs between points, n reps
  int i,j;
  for(j=0;j<n;j++){
    for(i=1;i<7;i++){
      clearAll();
      pointSnake(r,g,b,0,i);
      mapBits();
      sendBits();
      delay(t);
    }
    for(i=0;i<6;i++){
      clearAll();
      pointSnake(r,g,b,i,6-i);
      mapBits();
      sendBits();
      delay(t);
    }    
  }
}

void pointSnake(char r, char g, char b, char s, char n){  //illuminate n leds starting at s from each point
  int i,j;  
  for(i=0;i<n;i++){
    for(j=0;j<LED_COUNT;j=j+6){
      LEDS[(i+s+j)%LED_COUNT][0]=r;
      LEDS[(i+s+j)%LED_COUNT][1]=g;
      LEDS[(i+s+j)%LED_COUNT][2]=b;          
    }
  }    
}

void flashSequence(){
  flash(1,0,0,10);
  flash(1,1,0,10);
  flash(0,1,0,10);
  flash(0,1,1,10);
  flash(0,0,1,10);
  flash(1,0,1,10);  
}

void flash(char r, char g, char b, int n){  //n flash reps
  int i;
  for(i=0;i<n;i++){
    setAll(r,g,b);
    sendBits();
    delay(300);
    setAll(0,0,0);
    sendBits();
    delay(300);    
  }
}

void starBurstSequence(int n){   //n reps
  int i;  
  for(i=0;i<n;i++){
    starBurst(1,0,0,200);
    starBurst(1,1,0,200);
    starBurst(0,1,0,200);
    starBurst(0,1,1,200);
    starBurst(0,0,1,200);
    starBurst(1,0,1,200);    
  }
}

void chaseSequence(int n){ //do n loops of six colours
  int i;
  for(i=0;i<n;i++){
    chaseLoop(1,0,0,5,100);
    chaseLoop(1,1,0,5,100);
    chaseLoop(0,1,0,5,100);
    chaseLoop(0,1,1,5,100);
    chaseLoop(0,0,1,5,100);
    chaseLoop(1,0,1,5,100);
  }
}

void rainbowFade(unsigned long t){   //for t time
  int i;
  i=0;
  unsigned long t0;
  t0=millis();
  while(millis()<(t+t0)){
    clearAll();
    spectrumDither(i);
    mapBits();
    sendBits();
    delay(1);
    i=i+1;
    if(i>=1536){i=0;}   //loop around
  }  
}

void spectrum(char n){ //0-5 => red, yellow, green, cyan, blue, magenta
  switch(n%6){
    case 0: setAll(1,0,0);break;
    case 1: setAll(1,1,0);break;
    case 2: setAll(0,1,0);break;
    case 3: setAll(0,1,1);break;
    case 4: setAll(0,0,1);break;
    case 5: setAll(1,0,1);break;
  }
}

void spectrumDither(int n){   //dithered result from spectrum, space is 6x256=1536 points, will wrap around
  char a,b;
  a=(n&3);
  b=(n&255)>>6;
  if(b>a){
    spectrum((n>>8)+1);
  }else{
    spectrum((n>>8));    
  }
}

void starBurst(char r, char g, char b, int t){
  int i;
  i=1;
  for(i=0;i<5;i++){
    clearAll();
    setRadius(r,g,b,i);
    mapBits();
    sendBits();
    delay(t);    
  }
}

void setRadius(char r, char g, char b, char rad){   //for starburst type effects, r=1 (inner points) to r=4 (outer points)
  int i;
  switch(rad){
    case 1:
      for(i=0;i<LED_COUNT;i=i+6){
        LEDS[i+3][0]=r;
        LEDS[i+3][1]=g;
        LEDS[i+3][2]=b;        
      }
      break;
    case 2:
      for(i=0;i<LED_COUNT;i=i+6){
        LEDS[i+2][0]=r;
        LEDS[i+2][1]=g;
        LEDS[i+2][2]=b;        
        LEDS[i+4][0]=r;
        LEDS[i+4][1]=g;
        LEDS[i+4][2]=b;        
      }
      break;
    case 3:
      for(i=0;i<LED_COUNT;i=i+6){
        LEDS[i+1][0]=r;
        LEDS[i+1][1]=g;
        LEDS[i+1][2]=b;        
        LEDS[i+5][0]=r;
        LEDS[i+5][1]=g;
        LEDS[i+5][2]=b;        
      }
      break;    
    case 4:
      for(i=0;i<LED_COUNT;i=i+6){
        LEDS[i][0]=r;
        LEDS[i][1]=g;
        LEDS[i][2]=b;        
      }
      break;
  }  
}

void chaseLoop(char r, char g, char b, char n, int t){   //chase a stripe of n LEDs around with delay t between steps
  int i,j;
  for(i=0;i<LED_COUNT;i++){     //do one full loop
    clearAll();
    setSnake(r,g,b,i,n);
    mapBits();
    sendBits();
    delay(t);
  }  
}

void setSnake(char r, char g, char b, char s, char n){    //set snake of n LEDs starting from s
  int i;
  for(i=0;i<n;i++){
    LEDS[(i+s)%LED_COUNT][0]=r;
    LEDS[(i+s)%LED_COUNT][1]=g;
    LEDS[(i+s)%LED_COUNT][2]=b;          
  }
}

void clearAll(){    //set all to off
  int i;
  for(i=0;i<LED_COUNT;i++){
    LEDS[i][0]=0;
    LEDS[i][1]=0;
    LEDS[i][2]=0;
  }    
}

void setAll(char r, char g, char b){    //set all to same RGB
  int i;
  for(i=0;i<LED_COUNT;i++){
    LEDS[i][0]=r;
    LEDS[i][1]=g;
    LEDS[i][2]=b;
  }  
  mapBits();
}

void setBit(int i){     //sets a bit in dataBits corresponding i, used by mapBits
  if(((i/8)<BYTE_COUNT)&&(i>=0)){    //valid
    dataBits[i/8]=dataBits[i/8]|(1<<(i&7));
  }
}

void mapBits(){   //translate LEDS[][] array to dataBits[]
  char i,j;
  int k;  
  for(i=0;i<BYTE_COUNT;i++){dataBits[i]=0;}   //clear
  for(i=0;i<LED_COUNT;i++){
    for(j=0;j<LED_CHANNELS;j++){
      if(LEDS[i][j]){
        setBit(pgm_read_word_near(&LED_map[i][j]));
      }
    }
  }    
}

void sendBits(){    //output bits and latch onto LEDs
 char i;
 digitalWrite (latchPin,LOW);      // Sets latch pin of (74HC595,12)  to LOW
 for(i=BYTE_COUNT-1;i>=0;i--){      //reverse order, also ensures that result is correct if wrong numebr sent
  shiftOut (dataPin, clockPin,MSBFIRST,dataBits[i]);   // Sends Data (74HC595,14) and Clock (74HC595,11)
  //slowshift(dataBits[i]);
 }
 digitalWrite (latchPin, HIGH);    // Returns latch pin (74HC595,12) to HIGH to display data  
}

