void displayHistory()
{
  //creates the History graph for the Terminal Window for the Last 35 Days using the daily Log Event Summation
  String fileLine = "";
  String fileNameToRead = "WELFSTAT.TXT";
  char a;
  String str = "";
  unsigned int lineCtr = 0;
  const int vD = 36;//  The number of days to view
  unsigned int graphV[vD][17] = {0}; //colums, rows
  unsigned int daily[vD] = {0};// the daily total events array
  unsigned int dayNum = 0; // One days total event count
  float scaleF = 0 ; // Scale factor converts highest into max 16 for graphing
  float maxVal = 0; // the maximum daily events
  String chartLine = "";//the terminal text line to print
  Serial.println ("Reading HISTORY.  File WELFSTAT.TXT: ");
  myFile = SD.open("WELFSTAT.TXT");
  if (myFile)
  {
    //Serial.println(fileNameToRead + " exists");
    while (myFile.available())// read from the file until there's nothing else in it:
    {
      a = myFile.read();
      //Serial.print(a);
      if (int(a) == 13 or int(a) == 10 )
      {
        if (int(a) == 10)  //Line Feed - end of line - use accumulated string
        {
          fileLine = str;
          //Serial.println (fileLine);
          String lineDate = fileLine.substring(0, 10);
          dayNum = fileLine.substring(11).toInt(); //any thing past index 11
          //Serial.println ("History Day -Events: " + String (lineCtr) + "-" +  String (dayNum));
          if (dayNum > 999) //Limit the values
          {
            dayNum = 999;
          }
          if (lineCtr < vD)
          {
            daily[lineCtr] = dayNum;
            //Serial.println ("Events for Day: " + String(daily[lineCtr]));
            lineCtr++;
          }
          else
          {
            for (int i = 0; i < vD - 1 ; i++) // shuffle down
            {
              daily[i] = daily [i + 1];
              
              daily[vD - 1] = dayNum;
            }
          }
          if ( dayNum > maxVal)// find the daily hourly maximum event value
          {
            maxVal = dayNum;
          }
          str = ""; //reset the string to ""
        }
      }
      else // accumulate the string
      {
        str.concat(a);
        //Serial.println(str);
      }
    }
    myFile.close();    // close the file:
    
    // file has been read, Now process the data
    lineCtr = 0;
    //calc scale factor
    //Serial.println ("Max:" + String (maxVal));
    //Serial.println ("Min:" + String (minVal));
    scaleF = maxVal / 16;
    //Serial.println ("ScaleF:" + String ( scaleF));
    //if (scaleF != int(maxVal / 16))
    //{
    //  scaleF = int(maxVal / 16) + 1;
    //}
    //Average
    //Serial.println ("Average ==" + String (average));
    float averageF = average;
    //Serial.println ("Average Float ==" + String (averageF));
    float averageScaledF = 0;
    if (scaleF > 0)//prevent divn by 0
    {
      averageScaledF = averageF / scaleF;
    }
    float sDF = standardDeviation;
    float sDScaledF = 0;
    if (scaleF > 0)
    {
      sDScaledF = sDF / scaleF;
    }
    //Serial.println ("averageScaledF = " + String (averageF) + "/" + String (scaleF));
    //Serial.println ("averageScaledF = " + String (averageScaledF));

    for (int i = 0; i < vD; i++) //scale daily values to <=16
    {
      if (scaleF > 0)// trap division by zero
      {
        daily[i] = int (daily[i] / scaleF);
      }
      else
      {
        daily[i] = 0;
      }
    }
    

    for (int col = 0; col < vD; col++) //set the pixel
    {
      if (daily[col] >= 0)
      {
        graphV[col][16 - daily[col]] = 1;
      }
    }
    //Set the lower pixels
    for (int row = 0; row < 17; row++) // daily[24], graphV[24][17] = {0}; //colums, rows
    {
      for (int col = 0; col < vD; col++)
      {
        if (graphV[col][row] == 1 and row < 16)
        {
          graphV[col][row + 1] = 1;
        }
      }
    }
    //Compile the strings
    for (int row = 0; row < 17; row++) // daily[30], graphV[30][17] = {0}; //colums, rows
    {
      for (int col = 0; col < vD; col++)
      {
        if (graphV[col][row] == 1)
        {
          chartLine = chartLine + "+";
        }
        else
        {
          chartLine = chartLine + " ";
        }
      }
      //Make Graph text
      lineCtr ++ ;


      //Average
      if (averageScaledF > 0 and averageScaledF < 17)
      {
        if (row == int(16 - averageScaledF))
        {
          chartLine = "";
          for (int i = 0 ; i < vD; i++)
          {
            chartLine = chartLine + "-";
          }
        }
      }
      /*
      //SD ^
      if (sDScaledF > 0 and sDScaledF < 17)
      {
        if (row == int(16 - (averageScaledF + sDScaledF)))
        {
          chartLine = "";
          for (int i = 0 ; i < vD; i++)
          {
            chartLine = chartLine + "^";
          }
        }
      }
      //SD-
      
      if (sDScaledF > 0 and averageScaledF < 17)
      {
        if (row == int(16 - (averageScaledF - sDScaledF)))
        {
          chartLine = "";
          for (int i = 0 ; i < vD; i++)
          {
            chartLine = chartLine + "-";
          }
        }
      }
      */
      terminal.println (makeDataString3 (int ((16 - row) * scaleF)) + "|" + chartLine);
      if (lineCtr >= 5)
      {
        terminal.flush();
        lineCtr = 0;
      }
      chartLine = "";
    }
    //Make X axis text
    terminal.println ("    0||||5||||1||||5||||2||||5||||3||||5");
    terminal.println ("    Daily Event Totals for Last 35 Days");
    if (averageScaledF > 0)
    {
      //terminal.println ("     Avg:'=' Avg + SD:'^' Avg-SD:'-'");
      terminal.println ("    Average(-):" + String( average)  + " Standard Deviation:" + String (standardDeviation));
    }
    terminal.flush();
  }
  else
  {
    Serial.println("Error opening " + fileNameToRead);// if the file didn't open, print an error:
    terminal.println("Error opening " + fileNameToRead);
    terminal.flush();
  }
  average =0;  // reset the values for a clean History next time
  standardDeviation =0;
}

