//********************************************************
void serveWebPage()  // Web Page in Config Mode
{

  // Check if a client has connected
  WiFiClient client = server.available();
  if (!client)
  {
    return;
  }
  // Read the first line of the request
  String req = client.readStringUntil('\r');
  Serial.println("");
  Serial.print("Raw Response is:");
  Serial.println(req);
  if (firstRequest )// blank out first request
  {
    req = "";
    firstRequest = false;
  }
  else
  {
    req = processReq (req);  //Replaces all Hex Characters with ASCII
  }

  //Serial.println("");
  Serial.print("Processed Response is:");
  Serial.println(req);

  if (instr (req, "GET /WiFi Password") > -1)
  {
    //parse out password
    flashLed();
    String rightPartPass = req.substring(27);//was 28
    String passPart = rightPartPass.substring(0, rightPartPass.length() - 9);
    Serial.print("Password is: ");
    Serial.println (passPart);
    wifiPassword = passPart;
    writeEEPROMString(wifiPassword, passwordMem );

  }
 
  
  else if (instr(req, "GET /WiFi Number") > -1)
  {
    //parse out SSID
    flashLed();
    String rightPartSSID = req.substring(26);
    String ssidPart = rightPartSSID.substring(0, rightPartSSID.length() - 9);
    Serial.print("Network is: ");
    Serial.print (ssidPart);

    //
    wifiSSIDIndex = ssidPart.toInt();
    Serial.println (" " + wifiSSIDList[wifiSSIDIndex]);
    writeEEPROMString(wifiSSIDList[wifiSSIDIndex], ssidMem );//wifiSSID is a list number (String) at this point

  }
  else if (instr(req, "GET /Authorisation") > -1)
  {
    flashLed();
    //parse out auth
    String rightPartAuth = req.substring(31); //was 32
    String authPart = rightPartAuth.substring(0, rightPartAuth.length() - 9);
    Serial.print("Authorisation Code is: ");
    Serial.println (authPart);
    authToken = authPart;
    writeEEPROMString(authToken, authTokenMem );
  }
  else if (instr(req, "GET /Page1") > -1)
  {
    flashLed();
    Serial.print("Get: Requesting Page 1: ");
    hPage = "Page1";
  }
  else if (instr(req, "GET /Page2") > -1)
  {
    flashLed();
    Serial.print("Get: Requesting Page 2: ");
    hPage = "Page2";
  }
  else if (instr(req, "GET /Page3") > -1)
  {
    flashLed();
    Serial.print("Get: Requesting Page 3: ");
    hPage = "Page3";
  }
  else if (instr (req, "GET /Message1") > -1)
  {
    //parse out message
    flashLed();
    String rightPartM = req.substring(22);
    String mPart = rightPartM.substring(0, rightPartM.length() - 9);
    Serial.print("Message1 is: ");
    Serial.println (mPart);
    message1 = addSpaces(mPart);
    writeEEPROMString(message1, message1Mem );


  }
  else if (instr (req, "GET /Message2") > -1)
  {
    flashLed();
    //parse out message
    String rightPartM = req.substring(22);
    String mPart = rightPartM.substring(0, rightPartM.length() - 9);
    Serial.print("Message2 is: ");
    Serial.println (mPart);
    message2 = addSpaces(mPart);
    writeEEPROMString(message2, message2Mem );

  }
  else if (instr (req, "Submit_SSID") > -1 and instr (req, "Number=") > -1)
  {
    flashLed();
    //parse out message
    String rightPartS = req.substring(17);
    String sPart = rightPartS.substring(0, rightPartS.length() - 45);

    Serial.print("SSID Index is: ");
    Serial.print (sPart);
    Serial.println  (" - " + wifiSSIDList[sPart.toInt()]);
    wifiSSIDIndex = sPart.toInt();
    //message2 = addSpaces(sPart);
    //writeEEPROM(message2, message2Mem );
    //Serial.println (" " + wifiSSIDList[wifiSSIDIndex]);
    writeEEPROMString(wifiSSIDList[wifiSSIDIndex], ssidMem );//wifiSSID is a list number (String) at this point
  }

  //***************Operating Mode***************
  /*
  else if (instr (req, "opMode1") > -1 )
  {
    opMode = "XXX";
    writeEEPROM(opMode, opModeMem );
  }
  else if (instr (req, "opMode2") > -1 )
  {
    opMode = "YYY";
    writeEEPROM(opMode, opModeMem );
  } 
  */
  //*************Colours************************
  else if (instr (req, "Colour?") > -1 )
  {
    flashLed();
    //parse out message
    String rightPartC = req.substring(19);
    String cPart = rightPartC.substring(0, rightPartC.length() - 37);

    Serial.print("Colour Index is: ");
    Serial.print (cPart);
    Serial.println  (" - " + colorS[cPart.toInt()]);
    if (selectedItem == "Background")
    {
      backColor = colorS[cPart.toInt()];
      writeEEPROMString(backColor, backColorMem);
    }
    if (selectedItem == "Button")
    {
      buttonColor = colorS[cPart.toInt()];
      writeEEPROMString(buttonColor, buttonColorMem);
    }
    //message2 = addSpaces(sPart);

    //Serial.println (" " + wifiSSIDList[wifiSSIDIndex]);
    //writeEEPROM(wifiSSIDList[wifiSSIDIndex], ssidMem );//wifiSSID is a list number (String) at this point
  }
  else if (instr (req, "BackGroundColor") > -1 )
  {
    selectedItem = "Background";
  }
  else if (instr (req, "ButtonColour") > -1 )
  {
    selectedItem = "Button";
  }
  //else if (instr (req, "SelectItem?") > -1 )
  //{
  //  flashLed();
  //parse out message
  // String rightPartI = req.substring(28);
  // String iPart = rightPartI.substring(0, rightPartI.length() - 33);
  // Serial.print("Item is: ");
  // Serial.print (iPart);
  // selectedItem = iPart;
  //}
  //************Signal Strength RSSI********************
  else if (instr (req, "GET /RSSI") > -1)
  {
    flashLed();
    if (instr (req, "All") > -1)
    {
      Serial.print("RSSI is All: ");
      rssiLevel = rssiAll;
    }
    if (instr (req, "Medium") > -1)
    {
      Serial.print("RSSI is Medium: ");
      rssiLevel = rssiMedium;
    }
    if (instr (req, "Strong") > -1)
    {
      Serial.print("RSSI is Strong: ");
      rssiLevel = rssiStrong;
    }
    scanWiFi();
    //writeEEPROM(wifiSSIDList[wifiSSIDIndex], ssidMem );//wifiSSID is a list number (String) at this point
  }


  //******************FINISH*****************************
  else if (instr(req, "POST /Finish") > -1 or instr(req, "GET /Finish") > -1)
  {
    //End the input and switch to Client mode
    if (wifiPassword.length() > 0 and wifiSSID.length() > 0)
    {
      flashLed();
      Serial.println ("Switching to Client Mode");
      writeClientMode(); //writes 99 and 199 to EEPROM for client mode
      hPage = ("Page4");
    }
  }
  else
  {
    Serial.println("No Response;");
  }
  if (hPage == "Page1")
  {
    serveWebPage1(client);
  }
  else if (hPage == "Page2")
  {
    serveWebPage2(client);
  }
  else if (hPage == "Page3")
  {
    serveWebPage3(client);
  }
  else if (hPage == "Page4")
  {
    //serveWebPage3(client);
    Serial.println( "Finished Setup. Re-booting into Client Mode");
    client.print ("Finished Setup. Re-booting....");
    delay (3000);
    ESP.restart();  //was setup();
  }
  else
  {
    hPage = "Page1";
    serveWebPage1(client);
  }
}

