void displayStatistics()
{
  //creates the Statsitics Page Terminal Window for the Last 100 Days using the daily Log Event Summation
  String fileLine = "";
  String fileNameToRead = "WELFSTAT.TXT";
  char a;
  String str = "";
  unsigned int lineCtr = 0;
  const int d = 100;//  The number of days to view
  int daily[d] = {0};// the daily events array
  unsigned int dayNum = 0; // One days total event count
  unsigned int maxVal = 0; // the maximum of daily events
  unsigned int minVal = 9999; // the minumim of daily events
  unsigned int ave = 0; // the average of daily events
  unsigned int sD = 0; // the standard Devistion of daily events
  unsigned long sum = 0;// the total of the daily events
  unsigned int sampleNums = 0 ; // the number of samples may not be == to d
  String chartLine = "";//the terminal text line to print
  Serial.println ("Reading STATISTICS.  File WELFSTAT.TXT: ");
  myFile = SD.open("WELFSTAT.TXT");
  if (myFile)
  {
    //Serial.println(fileNameToRead + " exists");
    while (myFile.available())// read from the file until there's nothing else in it:
    {
      a = myFile.read();
      //Serial.print(a);
      if (int(a) == 13 or int(a) == 10 )
      {
        if (int(a) == 10)  //Line Feed - end of line - use accumulated string
        {
          fileLine = str;
          //Serial.println ("STATS File Line: " + fileLine);
          String lineDate = fileLine.substring(0, 10);
          dayNum = fileLine.substring(11).toInt(); //any thing past index 11
          if (dayNum == 0)
          {
            break;  // don't bother with zero entries
          }
          //Serial.println (dayNum);
          if (dayNum > 999) //Limit the values
          {
            dayNum = 999;
          }
          if (lineCtr >= d)// start at the beginning if more than d array index is 0 to 99, d= 100
          {
            lineCtr = 0; //doesn't matter if earlier data is overwritten because we want the last 100 days.
          }
          daily[lineCtr] = dayNum;  // allocate the daily count to the array
          lineCtr++;  // Increment counter
          str = ""; //reset the string to ""
        }
      }
      else // accumulate the string
      {
        str.concat(a);
        //Serial.println(str);
      }
    }
    myFile.close();    // close the file:
    /*
      // START TEST DATA
      daily[0] = 100;
      daily[1] = 20;
      daily[2] = 380;
      daily[3] = 230;
      daily[4] = 380;
      daily[5] = 230;
      daily[6] = 210;
      daily[7] = 230;
      minVal =999;
      // END TEST DATA
    */
    Serial.println ("WELFSTAT.TXT File has been read OK");
    lineCtr = 0;
    for (int i = 0; i < d; i++)
    {
      if (daily[i] > 0)
      {
        sum = sum + daily[i];
        lineCtr++;
        if ( daily[i] > maxVal)// find the daily hourly maximum event value
        {
          maxVal = daily[i];
        }
        if ( daily[i] < minVal)// find the daily hourly minimum event value. minVal was initialised at 9999.
        {
          minVal = daily[i];
        }
      }
    }
    sampleNums = lineCtr;
    if (sampleNums > 0) //to avoid divn by Zero error
    {
      ave = sum / sampleNums ;
    }
    sum = 0;
    //Serial.println ("Calculating SD");
    //CALCULATE SD
    //First sum of (daily - average)^2
    for (int i = 0; i < d; i++)
    {
      if (daily[i] > 0)
      {
        daily[i] = daily[i] - ave; // get the diference of daily to average
        daily[i] = daily[i] * daily [i];  // square the difference
        sum = sum + daily[i];// Get the sum
      }
    }
      average = ave;
    if (sampleNums - 1 > 0) //to avoid divn by Zero error
    {
      sD = sqrt(sum / (sampleNums - 1));
      standardDeviation = sD;
    }

    Serial.println ("Terminal Printing STATS");
    terminal.println ("Statistics for Daily Events for " + String (sampleNums) + " Days");
    terminal.println ("Average :" + String (ave) + " Events");
    terminal.println ("Maximum :" + String (maxVal) + " Events");
    terminal.println ("Minimum :" + String (minVal) + " Events");
    terminal.println ("Standard Deviation:" + String (sD) + " Events");
    terminal.flush();
    terminal.println (" ");
    terminal.println ("Open History (HI or hi) to Graph History ");
    terminal.println ("with Statistics.");
    terminal.flush();
  }
  else
  {
    Serial.println("Error opening " + fileNameToRead);// if the file didn't open, print an error:
    terminal.println("Error opening " + fileNameToRead);
    terminal.flush();
  }

}

