//  Welfare Monitor
//  With Web Page Configuration
//  ESP8266 Wemos D1 Mini
//  P J Webb Hope Valley South Australia 5090
//  6th April 2020
//  Re-Use of this code must include acknowledgement of Author(s).

//Declarations
#define BLYNK_PRINT Serial
#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>
#include <TimeLib.h>
#include <WidgetRTC.h>
#include <EEPROM.h>
#include <SPI.h>
#include <SD.h>

// Pin Definitions
const int PIR = D1; // PIR Input D1-5 Normal I/O
const int LED = D4; // LED OutputD4-2 Pullup + onboard LED
const int resetConfig = D2; //Config Reset D2-4
const int SDcs = D8; // SD Card Chip Select

//PIR variables
bool pirIn = false;
bool oldPirIn = false;// True if PIR was false and now is true

//Wifi Varibles and Declarations
String espMode = "Client";  //or "AP"
WiFiServer server(80);
char  cAuthToken[] = "";
const char WiFiAPPSK[] = "1234wm5678";//Password for Setup AP

// The Wifi SSID, Password and Auth Token are set by running the configuration Web page setup
// Config mode is automatic on first run after flashing a new Micro Controller
// Set your smart Device WiFi to Welfare_Monitor SSID, Password 1234wm5678
// and then open browser address 192.168.4.1  web config pages are then availalbe to set Parameters
// Run config any time by pressing the Config Button on the Welfare Monitor.  LED will switch on.
// If you want to HARD CODE these Parameters then comment out any items in setup() and loop() that would change the espMode to "AP"
// In other words, make sure that the espMode String variable is always == "Client"
// Normally Blynk uses char variable but I have used String that are converted to Char in connectBlynk();
// char auth[] = "authcode"; // Blynk usual definition
// char ssid[] = "networkName";
// char pass[] = "password";

String wifiSSID = "SSID";  //dummy values.  Setup in config Mode. or hard code here and comment any espMode other than "Client"
String wifiPassword = "Password";
String authToken = "Auth Token";
//
unsigned int wifiSSIDIndex = 0;
String wifiSSIDList[100];//100 should be enough
String wifiRSSIList[100];//100 should be enough
int rssiLevel = -200;
const int rssiAll = -200;
const int rssiMedium = -85;
const int rssiStrong = -50;

//Blynk Variables and Declarations
bool connected2Blynk = false;
WidgetTerminal terminal (V0);
WidgetRTC rtc;

//Memory locations
//Mem locations 0 and 1 used for AP or Client Setting
const int settingsExistMem = 2; //if settings exist, this location returns 199
const int ssidMem = 10;
const int passwordMem = 50;
const int authTokenMem = 100;
const int message1Mem = 150;
const int message2Mem = 200;
const int backColorMem = 250;
const int buttonColorMem = 275;
const int limitedDataPlanOnMem = 300;
const int eventsThresholdMem = 301;
const int monitorStartHourMem = 302;
const int monitorEndHourMem = 303;
const int reportHourMem = 304;
const int notificationOnMem = 305;
const int movementLedOnMem = 306;
const int bootNotificationOnMem = 307;
const int blackoutHoursMem = 310; // 20 locations 310 to334 Hours 1 to 24 index 0 is not used

//HTML variables
String message1 = "Name"; //messages1 and message2 set in Config mode
String message2 = "Not OK Message";
//colours multiple of 4 plus 1 eg 24+1 =25
String colorS[29] = {
  "", "aqua", "black", "blue", "fuschia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow", "lightgray", "lightgreen", "lightskyblue", "lightseagreen", "lightsalmon", "mediumpurple", "orange", "navy", "seagreen", "plum", "slateblue", "tan"
};
String backColor = "silver";
String buttonColor = "blue";
String selectedItem = "Background";
String opMode = "Welfare Monitor";
bool firstRequest = true;//needed to prevent web page request from running if previous web page exists when AP mode started
String hPage = "Page1";

//Event Variable
unsigned long eventCounter = 0; // the hourly events counter
unsigned int eventsThreshold = 0; // Alarm if less or equal to this events per hour
unsigned int limitedDataPlanOn = 0;// 1 == Limited, 0 = UnLimited
unsigned int notificationOn = 1;
unsigned int bootNotificationOn = 1;
unsigned int movementLedOn = 1;
unsigned int reportHour = 20;
unsigned int monitorStartHour = 8;
unsigned int monitorEndHour = 20;
unsigned int suspendNotification = 0;
unsigned int blackout[25];// 0 to 24. Zero Index not used. Values: 0 == Off 1 == Blackout.  The daily blackout hours where Notifications are not sent operates in conjunction with Notification Hours
unsigned int totalDailyEvents = 0;// The sum of daily events
unsigned int standardDeviation = 0;
unsigned int average = 0;


//Time Variables
const int startNightHour = 19;//7pm for night time start
const int endNightHour = 7;//7am for night time end
bool nightTime = false;
unsigned int currentHour;  // 0 to 23  0 is midnight
unsigned int currentMinute = 0;
unsigned int tempDay = 1;// Test Variable
unsigned long shutDownStart = 0; // Start variable for Blynk and wifi shutdown in millis if limited Data plan
unsigned long shutDownDelay = 90000; // 90 seconds
bool endOfHour = false; // Is true whenever minutes changes to Zero
unsigned int oldMinute = 0;
unsigned int oldSecond = 0;//Testing Only
String oldDate = "";
String currentTime = "";
String currentDate = "";


//SD card
Sd2Card card;
SdVolume volume;
SdFile root;
File myFile;

//*********************************
void setup()
{
  opMode = "Welfare Monitor";
  Serial.begin(9600);
  Serial.println(" ");
  Serial.println("Booting Welfare Monitor...... ");

  EEPROM.begin (1024);
  //writeAPMode();  //for test purposes
  byte settingsExist = EEPROM.read(settingsExistMem);
  if ( settingsExist != 199 ) // write settings for the first time if this mem location is not ==199
  {
    Serial.println ("Writing inital Settings to EEPROM");
    writeSettings();
  }
  readSettings();

  //Pin Modes
  pinMode(SDcs, OUTPUT);//SDcs
  pinMode(D5, OUTPUT);//Clock
  pinMode(D6, INPUT);//MISO
  pinMode(D7, OUTPUT);//MOSI
  pinMode(resetConfig, INPUT);//D2-4
  pinMode(PIR, INPUT);//D1-5
  pinMode(LED, OUTPUT);//D4-2

  if (digitalRead(resetConfig) == 0)
  {
    Serial.println ("*************Resetting Configuration with RESET CONFIG Pin");
    if (espMode == "Client") //resets to AP
    {
      Serial.println ("Resetting Configuration to AP Mode in setup()");
      digitalWrite(LED, HIGH);
      writeAPMode();
    }
  }

  //*********** SD Card *****************
  if (card.init(SPI_QUARTER_SPEED, D8)) // suits most SD cards.  Can try Higher speeds but some cards just do not work at HS
  {
    Serial.println ("In Setup.  SD card Initialised OK.");
  }
  else
  {
    Serial.println("In Setup. SD card initialisation failed!");
  }
  SD.begin (SDcs);
  //SDCardReadDetails(); //see what files are on the card if you want

  Serial.println("Checking for Mode: AP/Client");
  int loByte = EEPROM.read(0);
  int hiByte = EEPROM.read(1);
  if ( loByte == 99 and hiByte == 199)
  {
    Serial.println("Mode is: Client");
    espMode = "Client";
    digitalWrite(LED, HIGH);
    setupClientMode();
  }
  else
  {
    Serial.println("Mode is: Access Point");
    espMode = "AP";
    digitalWrite(LED, LOW);
    setupAPMode();
  }
}
//********************************************************
void loop()
{
  if (digitalRead(resetConfig) == 0)//RESET CONFIG
  {
    Serial.println ("*************Resetting Configuration with RESET CONFIG Pin");
    if (espMode == "Client") //resets to AP
    {
      Serial.println ("Resetting Configuration to AP Mode in loop()");
      digitalWrite(LED, LOW);
      writeAPMode();
    }
    else //if espMode== "AP" resets to Client
    {
      Serial.println ("Resetting Configuration to Client Mode in loop()");
      digitalWrite(LED, HIGH);
      writeClientMode();
    }
    Serial.println ("Re-Starting ESP in loop()");
    delay (250);
    ESP.restart();
  }
  if (espMode == "AP") // Access Point - Setup Mode
  {
    digitalWrite(LED, LOW);
    serveWebPage();
    delay (2);
    return;
  }
  else  //Client - Run Mode
  {
    digitalWrite(LED, HIGH);//Turn Off LED
    Blynk.run();
    getTime();
    goMonitor();
    checkConnection();
  }
}
//*****BLYNK FUNCTIONS******************************
BLYNK_WRITE (V0)
{
  String inStr = param.asStr();
  String inStrRaw = inStr;  // keep lower case
  inStr.toUpperCase();
  //Serial.println (inStr);
  if (limitedDataPlanOn == 1)
  {
    shutDownStart = millis(); //reset shutdown if limted data
  }
  //*** HELP ***
  if (inStr == "HELP" or inStr == "H" or inStr == "?")
  {
    Blynk.virtualWrite(V0, "clr");
    terminal.println("******** Help Index ********");
    terminal.println("BlackOut Hours - B or b");
    terminal.println("Clear Terminal - Clear, Cls or C");
    terminal.println("Configuration - CO or co");
    terminal.println("Delete Log File - DelLog");
    terminal.flush();
    terminal.println("Delete Statistics File - DelStat");
    terminal.println("Events Counter - E or e");
    terminal.println("Graph for Today - G or g");
    terminal.println("Graph for Specific Day - GD/M/YYYY");
    terminal.println("Help - Help, H or ?");
    terminal.flush();
    terminal.println("History - HI or hi");
    terminal.println("Log for Specific Day - LD/M/YYYY");
    terminal.println("Log for Today - L or l");
    terminal.println("Settings (Display) - S or s");
    terminal.println("Settings (Edit) - S##u, S##tu or S##htu");
    terminal.println("Statistics- ST or st");
    terminal.flush();
    return;
  }
  //*** BLACKOUT HOURS
  else if (inStr == "B")
  {
    Blynk.virtualWrite(V0, "clr");
    displayBlackoutHours();
    terminal.flush();
    return;
  }
  //*** Set BLACKOUT HOURS
  else if (inStr.substring(0, 1) == "B" and (inStr.length()) == 4)
  {
    Blynk.virtualWrite(V0, "clr");
    editBlackoutHours(inStr);
    terminal.flush();
    displayBlackoutHours();
    return;
  }
  //***CLEAR***
  else if (inStr == "CLEAR" or inStr == "CLS" or inStr == "CLR" or inStr == "C")
  {
    Blynk.virtualWrite(V0, "clr");
    terminal.println("Terminal Cleared.");
    terminal.flush();
    return;
  }
  //Delete Log File
  else if (inStr == "DELLOG")
  {
    Blynk.virtualWrite(V0, "clr");
    terminal.println("Deleting Log File....");
    terminal.flush();
    killFile("WELFLOG.TXT");
    terminal.println("Log File Deleted.");
    terminal.flush();
    return;
  }
  //Delete Statistics File
  else if (inStr == "DELSTAT")
  {
    Blynk.virtualWrite(V0, "clr");
    terminal.println("Deleting Statistics File....");
    terminal.flush();
    killFile("WELFSTAT.TXT");
    terminal.println("Statistics File Deleted.");
    terminal.flush();
    return;
  }
  else if (inStr == "E")
  {
    Blynk.virtualWrite(V0, "clr");
    terminal.println("Requesting Event Counters...");
    terminal.println(currentDate + " " + currentTime);
    terminal.println("Current Hour Events: " + String (eventCounter));
    terminal.println("Days Total Events:   " + String (totalDailyEvents));
    terminal.println("End of Events.");
    terminal.flush();
    return;
  }
  //*** GRAPH
  else if (inStr == "G")
  {
    Blynk.virtualWrite(V0, "clr");
    basicGraph(currentDate);
    terminal.flush();
    return;
  }
  //*** GRAPH for DATE****
  else if (inStr.substring(0, 1) == "G" and (inStr.substring(2, 3) == "/" or inStr.substring(3, 4) == "/" ))
  {
    Blynk.virtualWrite(V0, "clr");
    String dateSend = inStr.substring(1, 12);
    dateSend.trim();
    basicGraph(dateSend);
    terminal.flush();
    return;
  }
  //*** HISTORY
  else if (inStr == "HI")
  {
    Blynk.virtualWrite(V0, "clr");
    displayHistory();
    return;
  }
  //****LOG****
  else if (inStr == "L")
  {
    Blynk.virtualWrite(V0, "clr");
    terminal.println("Finding Log for Today: " + currentDate);
    terminal.flush();
    displayLogFile(currentDate, "L");
    terminal.println("End of Today's Log.");
    terminal.flush();
    return;
  }
  //***LOG for DATE****
  else if (inStr.substring(0, 1) == "L" and (inStr.substring(2, 3) == "/" or inStr.substring(3, 4) == "/" ))
  {
    //requestLog = true;
    Serial.println (inStr);//request log
    Blynk.virtualWrite(V0, "clr");
    terminal.println("Requesting Log for:" +  inStr.substring(1, 12) );
    terminal.flush();
    String dateSend = inStr.substring(1, 12);
    dateSend.trim();
    displayLogFile(dateSend, "L");
    terminal.println("End of Date Log.");
    terminal.flush();
    return;
  }
  //***Edit Setting***
  else if (inStr.substring (0, 1) == "S" and inStr.length() >= 4  and inStr.length() <= 6)
  {
    editSettings(inStr);
    if (limitedDataPlanOn == 1)
    {
      shutDownStart = millis();  // the time used for delaying shutdown after blynk connected if limited data plan
      Serial.println ("Starting Shutdown Timer at: " + currentTime);
    }
    else
    {
      Serial.println ("Shutdown Timer is Reset.");
    }
    displaySettings();
    return;
  }
  //***Display Settings***
  else if (inStr == "S")// or inStr =="M"
  {
    displaySettings();
    return;
  }
  else if (inStr == "CO")
  {
    Blynk.virtualWrite(V0, "clr");
    displayConfiguration();
    terminal.println(" ");
    terminal.println("End of Configuration.");
    terminal.flush();
    return;
  }
  
  //*** STATISTICS
  else if (inStr == "ST")
  {
    Blynk.virtualWrite(V0, "clr");
    displayStatistics();
    return;
  }
  //*** TEST Notifications
  else if (inStr.substring (0,1) == "T" and inStr.length() == 2)
  {
    Blynk.virtualWrite(V0, "clr");
    testNotifications(inStr);
    return;
  }
  else  //Wrong Format
  {
    Blynk.virtualWrite(V0, "clr");//clear terminal
    terminal.println("Incorrect Instruction Format: " + inStr);
    terminal.flush();
  }
}
BLYNK_WRITE (V1)
{
  String inStr = param.asStr();
  int inInt = param.asInt();
  String inStrRaw = inStr;  // keep lower case
  inStr.toUpperCase();
  switch (inInt)
  {
      suspendNotification = 2;
    case 1:
      suspendNotification = 2;
      break;
    case 2:
      suspendNotification = 4;
      break;
    case 3:
      suspendNotification = 8;
      break;
    case 4:
      suspendNotification = 16;
      break;
    case 5:
      suspendNotification = 0; //reset
      break;
  }
  if (inInt > 0 and inInt < 5)
  {
    Blynk.virtualWrite(V0, "clr");//clear terminal
    terminal.println(message1);
    terminal.println("Suspending Notifications for " + String (suspendNotification) +  " Hrs");
    terminal.flush();
    return;
  }
  if (inInt == 5)
  {
    Blynk.virtualWrite(V0, "clr");//clear terminal
    terminal.println(message1);
    terminal.println("Resetting Notifications to Normal.");
    terminal.flush();
  }
}
