void basicGraph(String dateToSend)
{
  //creates a basic graph for the Terminal Window using the daily Log Data
  String fileLine = "";
  String fileNameToRead = "WELFLOG.TXT";
  char a;
  String str = "";
  unsigned int lineCtr = 0;
  unsigned int graphV[25][17] = {0}; //colums, rows
  unsigned int dailyH[25] = {0};// the daily hour events
  unsigned int hourNum = 0; // the daily hour integer
  unsigned int hourVal = 0; // the daily hour
  unsigned int hourFound = 0; // Index for "Hr "
  float scaleF = 0 ; // the highest hourly event count/16
  float maxVal = 0; // the maximum hourly events
  String chartLine = "";//the terminal text line to print
  myFile = SD.open("WELFLOG.TXT");
  if (myFile)
  {
    //Serial.println(fileNameToRead + " exists");
    while (myFile.available())// read from the file until there's nothing else in it:
    {
      a = myFile.read();
      //Serial.print(a);
      if (int(a) == 13 or int(a) == 10 )
      {
        if (int(a) == 10)  //Line Feed - end of line - use accumulated string
        {
          fileLine = str;
          String lineDate = fileLine.substring(0, 10);
          if ( fileLine.startsWith(dateToSend) and instr(fileLine, "Hr ") > 0 )
          {
            //fileLine = "23/3/2020  Hr 22 - 55";// fileLine test
            hourFound = instr(fileLine, "Hr "); //Finds the start of Hr
            hourNum = fileLine.substring(hourFound + 3, hourFound + 5 ).toInt();
            hourVal = 0;
            hourVal = fileLine.substring(hourFound + 7).toInt();
            if (hourNum > 0 and hourNum <= 24 and hourVal  >= 0 and hourVal <= 9999)// put some limits on the values
            {
              dailyH[hourNum] = hourVal;  // eg Hr 12 = 54
              if ( hourVal > maxVal)// find the daily hourly maximum event value
              {
                maxVal = hourVal;
              }
            }
          }
          str = ""; //reset the string to ""
        }
      }
      else // accumulate the string
      {
        str.concat(a);
        //Serial.println(str);
      }
    }
    myFile.close();    // close the file:
    // test values
    //for (int i = 1 ; i < 25; i++)
    //{
    //  dailyH[i] = 10;
    //  maxVal = 15;
    //}
    //dailyH[10] = 0;

    // file has been read, Now process the data
    //calc scale factor
    scaleF = maxVal / 16;
    if (scaleF != int(maxVal / 16))
    {
      scaleF = int(maxVal / 16) + 1;
    }
    for (int i = 1; i < 25; i++) //scale daily values to <=16
    {
      if (scaleF > 0)// trap division by zero
      {
        dailyH[i] = int (dailyH [i] / scaleF);
      }
      else
      {
        dailyH[i] = 0;
      }
    }

    for (int col = 1; col < 25; col++) //set the pixel
    {
      if (dailyH[col] >= 0)
      {
        graphV[col][16 - dailyH[col]] = 1;
      }
    }
    //Set the lower pixels
    for (int row = 0; row < 17; row++) // dailyH[24], graphV[24][17] = {0}; //colums, rows
    {
      for (int col = 1; col < 25; col++)
      {
        if (graphV[col+1][row] == 1 and row < 16)
        {
          graphV[col+1][row + 1] = 1;
        }
      }
    }
    //Compile the strings
    for (int row = 0; row < 17; row++) // dailyH[24], graphV[24][17] = {0}; //colums, rows
    {
      
      for (int col = 1; col < 25; col++)
      {
        if (graphV[col][row] == 1)
        {
          chartLine = chartLine + "+";
        }
        else
        {
          chartLine = chartLine + " ";
        }
      }
      //Make Graph text
      lineCtr ++ ;
      terminal.println (makeDataString3 (int ((16 - row) * scaleF)) + "|" + chartLine);
      if (lineCtr >=5)
      {
        terminal.flush();
        lineCtr = 0;
      }
      chartLine = "";
    }
    //Make X axis text
    terminal.println ("    1||||6|||||N|||||6|||||M");
    terminal.println ("    Graph for " + dateToSend);
    terminal.flush();
  }
  else
  {
    Serial.println("Error opening " + fileNameToRead);// if the file didn't open, print an error:
    terminal.println("Error opening " + fileNameToRead);
    terminal.flush();
  }
}

