 





/*
 Author: dennis.stanley@uwa.edu.au
 solar paneltester code.
 measures solar panel Isc and Voc
 a reference cell is measured to assess illumination level.
 the performance of the panel is estimated from these parameters
 coorections for illumination level based on  
 "Effect of Illumination Intensity on Solar Cells Parameters" M.Chegaar et al 2013
 * 
 */

//these libraries need to be installed in your arduino IDE see https://www.arduino.cc/en/guide/libraries
 
#include <LiquidCrystal.h>  // library for the 16*2 display
#include <math.h>           // maths library needed for the Log funtion 

// initialize the library by associating any needed LCD interface pin
// with the arduino pin number it is connected to
const int rs = 2, en = 4, d4 = 5, d5 = 6, d6 = 7, d7 = 8;
LiquidCrystal lcd(rs, en, d4, d5, d6, d7);

const int lcd_backlight = 9;    //define the pin used to drive the LCD backlight
const int lcd_contrast = 3;     // define the pin used to supply lcd contrast voltage (PWM) 
const int CurrentSensorPin = A3;    // input pin for the current sensor
const int VoltageSensorPin = A2;    // input pin for the voltage divider
const int ReferenceSensorPin = A1;    // input pin for the current sensor
const float ReferenceCal=0.1102 ;    // cal for reference 100% illumination = 966mv
const int ShortPanelPin = 12;      // select the pin for the LED
const float VoltageCal=0.0066615 ;    // cal for voltage based on 16 integrated samples of a 1/101 voltage divider
const float CurrentCal=-0.00257235 ;    // cal for current based on 16 integrated samples
const float TesterCurrent=0.05 ;    // current draw of tester 


int CurrentRawValue = 0;  // variable to store the value coming from the current sensor
int OffsetRawValue = 0;  // variable to store the value coming from the current sensor
int VoltageRawValue = 0;  // variable to store the value coming from the current sensor
int ReferenceRawValue = 0;  // variable to store the value coming from the reference sensor
float Reference =0 ; 
float Current =0 ; 
float Voltage =0 ; 
float Isc =0 ;
float Voc =0 ;
float ratio =0 ;
float Power =0 ;

// these are timing tools not used in production. 
unsigned long starttime;
unsigned long endtime;
const int TempRef = 15000;

 
  
 
 
 void setup() {
  pinMode(ShortPanelPin, OUTPUT); // setup mosfet gate drive pin to enable pannel short circuit
  digitalWrite(ShortPanelPin, LOW); // turn the make sure panel stays open ciruit.
  pinMode(lcd_backlight, OUTPUT); // setup lcd backlight frive pin
  digitalWrite(lcd_backlight, HIGH); // turn the lcd backlight on
  pinMode(lcd_contrast, OUTPUT); // setup lcd contrast drive pin
 analogWrite(lcd_contrast, 100); // apply pwm voltage to contrast pin 
  // set up the LCD's number of columns and rows:
  lcd.begin(16, 2);
  // Print a welcome message to the LCD.
  lcd.print("Freshwater ");
  lcd.setCursor(0, 1);
  lcd.print("Buyback Shop ");
  delay(3000);
  lcd.setCursor(0, 0);
  lcd.print("SolarPanelTester ");
  lcd.setCursor(0, 1);
  lcd.print("Brought to you    ");
  delay(2000);
  lcd.setCursor(0, 0);
  lcd.print("       by       ");
  lcd.setCursor(0, 1);
  lcd.print("Dennis The Messy   ");
  delay(2000); // wait 2sec
  
  Serial.begin(9600); //activate the srduino serial port to display diagnostic debugging information
  //to the serial monitor in the arduino IDE. serial.print messages do not go to the lcd only the serial port. 
  Serial.println("startup");
  analogReference(INTERNAL); // select the atmel 328 internal 1.1 v ADC reference
  delay(2000);
}



void loop() {
  // put your main code here, to run repeatedly:
ReferenceRawValue = analogRead(ReferenceSensorPin); //  read shunt voltage from the refence solar cell 
Reference= ReferenceRawValue * ReferenceCal; // convert this adc value illumation value 0 to 100 1 being 100% nb >100% is ok on a very bright day. 
Serial.print("ReferenceRawValue = ");
  Serial.print(ReferenceRawValue);
  Serial.print("  equates to ");
  Serial.print(Reference);
  Serial.println(" percent illumination. ");

//get voltage get an initial reading then add to that 15 more giving a total of 16 readings to average
VoltageRawValue = analogRead(VoltageSensorPin);
for (int i=0; i<15 ; i++){
  VoltageRawValue += analogRead(VoltageSensorPin);
}
Voltage = VoltageCal*VoltageRawValue;  //apply the cal value to to the raw value to get actual volts
Serial.print("accumulated Voltage RawValue = ");
  Serial.print(VoltageRawValue);
  Serial.print("Measured Voltage = ");
  Serial.println(Voltage);  


// get current.
// but before we shorth the panel we measure the 
// current sensor value with no current flowing 
// to determine the offset value

  
OffsetRawValue = analogRead(CurrentSensorPin); //get an initial reading then add to that 15 more giving a total of 16 readings to average
for (int i=0; i<15 ; i++){
  OffsetRawValue += analogRead(CurrentSensorPin);
}

Serial.print("accumulated offset RawValue = ");
  Serial.println(OffsetRawValue);
//now for current
starttime = micros();  // this is a development timer to work out how long the solar panel is shorted for 

digitalWrite(lcd_backlight, LOW); // turn the lcd backlight off to save current during panel short cct
digitalWrite(ShortPanelPin, HIGH); // short out the panel. 
CurrentRawValue = analogRead(CurrentSensorPin);  // these first two are time wasters giving time for the sensor to settle 
CurrentRawValue = analogRead(CurrentSensorPin);  
CurrentRawValue = analogRead(CurrentSensorPin);  //get an initial reading then add to that 15 more giving a total of 16 readings to average
for (int i=0; i<15 ; i++){
  CurrentRawValue += analogRead(CurrentSensorPin);
}

digitalWrite(ShortPanelPin, LOW); // open cct the panel again.
digitalWrite(lcd_backlight, HIGH); // turn the lcd backlight on
endtime = micros(); // stop the timer 
Current = CurrentCal*(CurrentRawValue-OffsetRawValue); // apply calibration to raw current value - raw offfset value 

Serial.print("accumulated current RawValue = "); 
  Serial.print(CurrentRawValue);
  Serial.print("Measured Current = ");
  Serial.print(Current);
  Serial.print("   in  conversion time for 16 samples = ");
  Serial.println(endtime-starttime);
// lcd output of measured values
lcd.clear();
 lcd.setCursor(0, 0);  
 lcd.print("Voc=    ");
 lcd.setCursor(3, 0);
 lcd.print(Voltage, 1 );
 lcd.setCursor(8, 0);   
 lcd.print("Isc=    ");
 lcd.setCursor(12, 0);
 lcd.print(Current, 2 );
 lcd.setCursor(0, 1);
 lcd.print("Meas@   ");
 lcd.setCursor(6, 1);
 lcd.print(Reference, 0 );
 lcd.setCursor(9, 1);
 lcd.print("% illum   ");
 
Reference = Reference /100; // change illumination from % to a ratio 
Reference += 0.001; //make sure non zero 
Isc=Current/Reference; //normalise Isc for illumination; linear correction
//logrythimic correction of Voc for illumination level
ratio=log(Reference);
ratio=-0.049256*ratio;
ratio=ratio+1.0;
//ratio=1+(0.049256*log(Reference));
Voc=Voltage*ratio;  
Power= Isc * Voc * 0.77;  // calulation of power based on typical Ics Voc ratio 
delay(5000);
//screen to introduce estimated spec
lcd.clear();
 lcd.setCursor(0, 0);  
 lcd.print("Estimated" );
lcd.setCursor(0, 1);  
 lcd.print("Specifation"); 
delay(1000);
// display estimatred panel paramaters 
lcd.clear();
 lcd.setCursor(0, 0);  
 lcd.print("Voc=    ");
 lcd.setCursor(3, 0);
 lcd.print(Voc, 1 );
 lcd.setCursor(8, 0);   
 lcd.print("Isc=    ");
 lcd.setCursor(12, 0);
 lcd.print(Isc, 2 );
 lcd.setCursor(0, 1);
 lcd.print("Power    ");
 lcd.setCursor(7, 1);
 lcd.print(Power, 0 );
 lcd.setCursor(10, 1);
 lcd.print("Watts   ");
delay(5000);
}
