/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

public class MultiChannelBuffer {
    private float[][] channels;
    private int bufferSize;

    public MultiChannelBuffer(int bufferSize, int numChannels) {
        this.channels = new float[numChannels][bufferSize];
        this.bufferSize = bufferSize;
    }

    public void set(MultiChannelBuffer otherBuffer) {
        this.bufferSize = otherBuffer.bufferSize;
        this.channels = (float[][])otherBuffer.channels.clone();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getChannelCount() {
        return this.channels.length;
    }

    public float getSample(int channelNumber, int sampleIndex) {
        return this.channels[channelNumber][sampleIndex];
    }

    public float getSample(int channelNumber, float sampleIndex) {
        int lowSamp = (int)sampleIndex;
        int hiSamp = lowSamp + 1;
        if (hiSamp == this.bufferSize) {
            return this.channels[channelNumber][lowSamp];
        }
        float lerp = sampleIndex - (float)lowSamp;
        return this.channels[channelNumber][lowSamp] + lerp * (this.channels[channelNumber][hiSamp] - this.channels[channelNumber][lowSamp]);
    }

    public void setSample(int channelNumber, int sampleIndex, float value) {
        this.channels[channelNumber][sampleIndex] = value;
    }

    public float[] getChannel(int channelNumber) {
        return this.channels[channelNumber];
    }

    public void setChannel(int channelNumber, float[] samples) {
        System.arraycopy(samples, 0, this.channels[channelNumber], 0, this.bufferSize);
    }

    public void setChannelCount(int numChannels) {
        if (this.channels.length != numChannels) {
            float[][] newChannels = new float[numChannels][this.bufferSize];
            for (int c = 0; c < this.channels.length && c < numChannels; ++c) {
                newChannels[c] = this.channels[c];
            }
            this.channels = newChannels;
        }
    }

    public void setBufferSize(int bufferSize) {
        if (this.bufferSize != bufferSize) {
            this.bufferSize = bufferSize;
            for (int i = 0; i < this.channels.length; ++i) {
                float[] newChannel = new float[bufferSize];
                System.arraycopy(this.channels[i], 0, newChannel, 0, bufferSize < this.channels[i].length ? bufferSize : this.channels[i].length);
                this.channels[i] = newChannel;
            }
        }
    }
}

