/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSource;
import ddf.minim.Minim;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioStream;

public class AudioInput
extends AudioSource {
    boolean m_isMonitoring;
    AudioStream m_stream;

    public AudioInput(AudioStream stream, AudioOut out) {
        super(out);
        out.setAudioStream(stream);
        stream.open();
        this.disableMonitoring();
        this.m_stream = stream;
    }

    @Override
    public void close() {
        super.close();
        this.m_stream.close();
    }

    public boolean isMonitoring() {
        return this.m_isMonitoring;
    }

    public void enableMonitoring() {
        if (this.hasControl(VOLUME)) {
            this.setVolume(1.0f);
            this.m_isMonitoring = true;
        } else if (this.hasControl(GAIN)) {
            this.setGain(0.0f);
            this.m_isMonitoring = true;
        } else {
            Minim.error("Monitoring is not available on this AudioInput.");
        }
    }

    public void disableMonitoring() {
        if (this.hasControl(VOLUME)) {
            this.setVolume(0.0f);
        } else if (this.hasControl(GAIN)) {
            this.setGain(-64.0f);
        }
        this.m_isMonitoring = false;
    }
}

