/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.io.File;
import processing.core.PApplet;
import processing.serial.Serial;

public class Digital_Lighting_Controller
extends PApplet {
    Minim minim = new Minim((Object)this);
    final int LAMPS = 32;
    final int TIMEOUT = 20;
    final int PACKET_TIMEOUT = 20;
    File seqFile;
    byte[] seqData;
    File wavFile;
    AudioPlayer aFile;
    long seqt = 0L;
    long seql = 0L;
    long playt = 0L;
    int seqPtr = 0;
    boolean playState = false;
    boolean pauseState = false;
    long seqt0 = 0L;
    String stateString = "STOPPED";
    long pLast;
    int[] lamps = new int[32];
    int[] rampSteps = new int[32];
    int[] rampTime = new int[32];
    long mLast;
    int foreColour = this.color(192, 192, 192);
    int backColour = this.color(64, 64, 64);
    int textColour = this.color(0, 0, 0);
    Button openButton = new Button();
    Button playButton = new Button();
    Button pauseButton = new Button();
    Button stopButton = new Button();
    Serial DLC;
    int serialIndex = 0;
    String portName = "-no ports-";
    String currentPort = "";
    boolean portConnect = false;
    Button upButton = new Button();
    Button downButton = new Button();
    Button conButton = new Button();
    Button discButton = new Button();

    public void setup() {
        this.surface.setTitle("Silicon Chip Digital Lighting Controller " + this.stateString);
        this.surface.setResizable(false);
        this.background(this.color(128, 128, 128));
        this.noStroke();
        this.textSize(32.0f);
        this.openButton.x = 10.0f;
        this.openButton.y = 10.0f;
        this.openButton.w = 80.0f;
        this.openButton.h = 40.0f;
        this.openButton.text = "Open";
        this.openButton.pressed = false;
        this.openButton.lastpressed = false;
        this.playButton.x = 10.0f;
        this.playButton.y = 60.0f;
        this.playButton.w = 80.0f;
        this.playButton.h = 40.0f;
        this.playButton.text = "Play";
        this.playButton.pressed = false;
        this.playButton.lastpressed = false;
        this.pauseButton.x = 100.0f;
        this.pauseButton.y = 60.0f;
        this.pauseButton.w = 80.0f;
        this.pauseButton.h = 40.0f;
        this.pauseButton.text = "Pause";
        this.pauseButton.pressed = false;
        this.pauseButton.lastpressed = false;
        this.stopButton.x = 190.0f;
        this.stopButton.y = 60.0f;
        this.stopButton.w = 80.0f;
        this.stopButton.h = 40.0f;
        this.stopButton.text = "Stop";
        this.stopButton.pressed = false;
        this.stopButton.lastpressed = false;
        int i = 0;
        while (i < 32) {
            this.lamps[i] = 0;
            this.rampSteps[i] = 0;
            this.rampTime[i] = 0;
            ++i;
        }
        if (Serial.list().length > 0) {
            this.portName = Serial.list()[0];
        }
        this.upButton.x = 290.0f;
        this.upButton.y = 10.0f;
        this.upButton.w = 80.0f;
        this.upButton.h = 40.0f;
        this.upButton.text = "Up";
        this.upButton.pressed = false;
        this.upButton.lastpressed = false;
        this.downButton.x = 290.0f;
        this.downButton.y = 60.0f;
        this.downButton.w = 80.0f;
        this.downButton.h = 40.0f;
        this.downButton.text = "Down";
        this.downButton.pressed = false;
        this.downButton.lastpressed = false;
        this.conButton.x = 380.0f;
        this.conButton.y = 10.0f;
        this.conButton.w = 90.0f;
        this.conButton.h = 40.0f;
        this.conButton.text = this.portName;
        this.conButton.pressed = false;
        this.conButton.lastpressed = false;
        this.discButton.x = 380.0f;
        this.discButton.y = 60.0f;
        this.discButton.w = 90.0f;
        this.discButton.h = 40.0f;
        this.discButton.text = "=//=";
        this.discButton.pressed = false;
        this.discButton.lastpressed = false;
        this.mLast = this.millis();
    }

    public void draw() {
        String ll;
        String pp;
        int l;
        int p;
        int i;
        if (this.playState) {
            if (this.pauseState) {
                this.stateString = "PAUSED";
                this.pLast = this.millis();
            } else {
                this.stateString = "PLAYING";
            }
        } else {
            this.stateString = "STOPPED";
            this.pLast = this.millis();
        }
        this.surface.setTitle("Silicon Chip Digital Lighting Controller " + this.stateString);
        this.background(this.color(128, 128, 128));
        this.textSize(32.0f);
        this.textAlign(3, 3);
        if (this.checkClick(this.openButton)) {
            this.playState = false;
            this.pauseState = false;
            if (this.aFile != null) {
                this.aFile.pause();
                this.aFile.rewind();
                this.seqt = 0L;
                this.seqPtr = 0;
                i = 0;
                while (i < 32) {
                    this.lamps[i] = 0;
                    ++i;
                }
            } else {
                this.seqPtr = 0;
                this.seqt = 0L;
                this.playt = 0L;
                i = 0;
                while (i < 32) {
                    this.lamps[i] = 0;
                    ++i;
                }
            }
            this.selectInput("Select a file to process:", "fileSelected");
        }
        if (this.checkClick(this.playButton)) {
            this.playState = true;
            this.pauseState = false;
            if (this.aFile != null) {
                this.aFile.play();
            }
        }
        if (this.checkClick(this.pauseButton)) {
            if (this.playState) {
                this.pauseState = true;
            }
            if (this.aFile != null) {
                this.aFile.pause();
            }
        }
        if (this.checkClick(this.stopButton)) {
            this.playState = false;
            this.pauseState = false;
            if (this.aFile != null) {
                this.aFile.pause();
                this.aFile.rewind();
                this.seqt = 0L;
                this.seqPtr = 0;
                i = 0;
                while (i < 32) {
                    this.lamps[i] = 0;
                    ++i;
                }
            } else {
                this.seqPtr = 0;
                this.seqt = 0L;
                this.playt = 0L;
                i = 0;
                while (i < 32) {
                    this.lamps[i] = 0;
                    ++i;
                }
            }
        }
        if (this.checkClick(this.upButton) && !this.portConnect) {
            ++this.serialIndex;
        }
        if (this.checkClick(this.downButton) && !this.portConnect) {
            --this.serialIndex;
            if (this.serialIndex < 0) {
                this.serialIndex = 0;
            }
        }
        if (this.serialIndex > Serial.list().length - 1) {
            this.serialIndex = Serial.list().length - 1;
        }
        if (Serial.list().length > 0) {
            this.conButton.text = this.portName = Serial.list()[this.serialIndex];
        }
        if (this.checkClick(this.conButton)) {
            if (!this.portConnect) {
                try {
                    this.currentPort = this.portName;
                    this.DLC = new Serial((PApplet)this, this.currentPort, 38400);
                    this.portConnect = true;
                }
                catch (Exception exception) {
                    this.portConnect = false;
                }
            } else {
                this.DLC.stop();
                this.portConnect = false;
            }
        }
        if (this.checkClick(this.discButton) && this.portConnect) {
            this.DLC.stop();
            this.portConnect = false;
        }
        this.discButton.text = this.portConnect ? "=<>=" : "=//=";
        if (this.aFile != null) {
            p = this.aFile.position() / 1000;
            l = this.aFile.length() / 1000;
            pp = Digital_Lighting_Controller.str((int)(p % 60));
            if (pp.length() < 2) {
                pp = "0" + pp;
            }
            if ((ll = Digital_Lighting_Controller.str((int)(l % 60))).length() < 2) {
                ll = "0" + ll;
            }
            this.text(String.valueOf(PApplet.parseInt((float)(p / 60))) + ":" + pp + "/" + PApplet.parseInt((float)(l / 60)) + ":" + ll, 190.0f, 30.0f);
            if (this.aFile.position() == this.aFile.length() && !this.aFile.isPlaying()) {
                this.aFile.rewind();
            }
            while ((long)this.aFile.position() > this.seqt && this.seqPtr < this.seqData.length && this.aFile.isPlaying()) {
                this.seqt += this.parsePair(this.seqPtr);
                this.seqPtr += 2;
            }
        } else {
            p = PApplet.parseInt((float)(this.playt / 1000L));
            l = PApplet.parseInt((float)(this.seql / 1000L));
            pp = Digital_Lighting_Controller.str((int)(p % 60));
            if (pp.length() < 2) {
                pp = "0" + pp;
            }
            if ((ll = Digital_Lighting_Controller.str((int)(l % 60))).length() < 2) {
                ll = "0" + ll;
            }
            this.text(String.valueOf(PApplet.parseInt((float)(p / 60))) + ":" + pp + "/" + PApplet.parseInt((float)(l / 60)) + ":" + ll, 190.0f, 30.0f);
            if (this.playt > this.seql) {
                this.playState = false;
                this.pauseState = false;
                this.seqPtr = 0;
                this.seqt = 0L;
                this.playt = 0L;
            }
            if (this.seqData != null) {
                while (this.playt > this.seqt && this.seqPtr < this.seqData.length && this.playState && !this.pauseState) {
                    this.seqt += this.parsePair(this.seqPtr);
                    this.seqPtr += 2;
                }
            }
        }
        this.drawButton(this.openButton);
        this.drawButton(this.playButton);
        this.drawButton(this.pauseButton);
        this.drawButton(this.stopButton);
        this.drawButton(this.upButton);
        this.drawButton(this.downButton);
        this.drawButton(this.conButton);
        this.drawButton(this.discButton);
        this.textSize(16.0f);
        this.noStroke();
        this.fill(this.textColour);
        this.textAlign(3, 3);
        if (this.seqFile != null) {
            this.text(this.seqFile.getName(), 240.0f, 280.0f);
        } else {
            this.text("---", 240.0f, 300.0f);
        }
        if (this.wavFile != null) {
            this.text(this.wavFile.getName(), 240.0f, 300.0f);
        } else {
            this.text("---", 240.0f, 300.0f);
        }
        i = 0;
        while (i < 32) {
            this.stroke(this.color(192, 192, 0));
            this.fill(this.color(this.lamps[i], this.lamps[i], this.lamps[i]));
            this.circle((i & 7) * 40 + 100, i / 8 * 40 + 130, 30.0f);
            ++i;
        }
        if ((long)this.millis() - this.mLast > 20L) {
            this.checkRamps();
            this.mLast += 20L;
            this.sendPacket();
        }
        while ((long)this.millis() - this.mLast > 20L) {
            this.checkRamps();
            this.mLast += 20L;
        }
        while ((long)this.millis() - this.pLast > 20L) {
            this.pLast += 20L;
            if (!this.playState || this.pauseState) continue;
            this.playt += 20L;
        }
    }

    public boolean checkClick(Button b) {
        boolean t = false;
        b.pressed = this.checkPress(b);
        if (b.pressed && !b.lastpressed) {
            t = true;
        }
        b.lastpressed = b.pressed;
        return t;
    }

    public void drawButton(Button b) {
        this.noStroke();
        if (b.pressed) {
            this.fill(this.foreColour);
        } else {
            this.fill(this.backColour);
        }
        this.rect(b.x, b.y, b.w, b.h);
        if (b.pressed) {
            this.stroke(this.backColour);
        } else {
            this.stroke(this.foreColour);
        }
        this.strokeWeight(2.0f);
        this.line(b.x, b.y, b.x + b.w - 1.0f, b.y);
        this.line(b.x, b.y + b.h - 1.0f, b.x + b.w - 1.0f, b.y + b.h - 1.0f);
        this.line(b.x, b.y, b.x, b.y + b.h - 1.0f);
        this.line(b.x + b.w - 1.0f, b.y, b.x + b.w - 1.0f, b.y + b.h - 1.0f);
        this.noStroke();
        this.fill(this.textColour);
        this.textAlign(3, 3);
        this.textSize(24.0f);
        this.text(b.text, b.x + b.w / 2.0f, b.y + b.h / 2.0f - 4.0f);
    }

    public boolean checkPress(Button b) {
        return (float)this.mouseX > b.x && (float)this.mouseX < b.x + b.w - 1.0f && (float)this.mouseY > b.y && (float)this.mouseY < b.y + b.h - 1.0f && this.mouseButton == 37 && this.mousePressed;
    }

    public void fileSelected(File selection) {
        if (selection == null) {
            this.wavFile = null;
            this.aFile = null;
            this.seqFile = null;
        } else {
            this.seqFile = selection;
            String t = this.seqFile.getAbsolutePath().substring(this.seqFile.getAbsolutePath().length() - 3).toUpperCase();
            this.seqData = this.loadBytes(this.seqFile.getAbsolutePath());
            this.seqt = 0L;
            this.seqPtr = 0;
            long tt = 0L;
            int i = 0;
            while (i < this.seqData.length) {
                tt += this.parsePair(i);
                i += 2;
            }
            this.seql = tt;
            if (t.equals("LSQ")) {
                String wName = String.valueOf(this.seqFile.getAbsolutePath().substring(0, this.seqFile.getAbsolutePath().length() - 3)) + "wav";
                this.aFile = this.minim.loadFile(wName);
                this.wavFile = new File(wName);
            } else {
                this.wavFile = null;
            }
        }
    }

    public long parsePair(int p) {
        if (p > this.seqData.length - 2) {
            return 0L;
        }
        int first = PApplet.parseInt((float)(this.seqData[p] & 0xFF));
        int second = PApplet.parseInt((float)(this.seqData[p + 1] & 0xFF));
        switch (second) {
            case 0: {
                int i = 0;
                while (i < 32) {
                    this.lamps[i] = 0;
                    ++i;
                }
                return 0L;
            }
            case 1: {
                return first + 1;
            }
            case 2: {
                return (first + 1) * 4;
            }
            case 3: {
                return (first + 1) * 16;
            }
        }
        switch (second >> 2) {
            case 1: {
                int i = 0;
                while (i < 8) {
                    this.lamps[i + (second & 3) * 8] = PApplet.parseBoolean((int)(first & 1 << i)) ? 255 : 0;
                    ++i;
                }
                return 0L;
            }
            case 2: {
                int i = 0;
                while (i < 8) {
                    if (PApplet.parseBoolean((int)(first & 1 << i))) {
                        this.lamps[i + (second & 3) * 8] = 0;
                    }
                    ++i;
                }
                return 0L;
            }
            case 3: {
                int i = 0;
                while (i < 8) {
                    if (PApplet.parseBoolean((int)(first & 1 << i))) {
                        this.lamps[i + (second & 3) * 8] = 255;
                    }
                    ++i;
                }
                return 0L;
            }
            case 4: {
                this.lamps[first & 0x1F] = 255;
                this.lamps[second * 8 + first / 32 & 0x1F] = 255;
                return 0L;
            }
            case 5: {
                this.lamps[first & 0x1F] = 0;
                this.lamps[second * 8 + first / 32 & 0x1F] = 0;
                return 0L;
            }
            case 6: {
                this.lamps[first & 0x1F] = 255;
                this.lamps[second * 8 + first / 32 & 0x1F] = 0;
                return 0L;
            }
            case 7: {
                this.lamps[first & 0x1F] = 255 - this.lamps[first & 0x1F];
                this.lamps[second * 8 + first / 32 & 0x1F] = 255 - this.lamps[second * 8 + first / 32 & 0x1F];
                return 0L;
            }
        }
        switch (second >> 5) {
            case 1: {
                this.lamps[second & 0x1F] = first;
                return 0L;
            }
            case 2: {
                this.rampSteps[second & 0x1F] = 255 - this.lamps[second & 0x1F];
                this.rampTime[second & 0x1F] = first + 1;
                return 0L;
            }
            case 3: {
                this.rampSteps[second & 0x1F] = 0 - this.lamps[second & 0x1F];
                this.rampTime[second & 0x1F] = first + 1;
                return 0L;
            }
            case 4: {
                this.rampSteps[second & 0x1F] = 255 - this.lamps[second & 0x1F];
                this.rampTime[second & 0x1F] = (first + 1) * 4;
                return 0L;
            }
            case 5: {
                this.rampSteps[second & 0x1F] = 0 - this.lamps[second & 0x1F];
                this.rampTime[second & 0x1F] = (first + 1) * 4;
                return 0L;
            }
            case 6: {
                this.rampSteps[second & 0x1F] = 255 - this.lamps[second & 0x1F];
                this.rampTime[second & 0x1F] = (first + 1) * 16;
                return 0L;
            }
            case 7: {
                this.rampSteps[second & 0x1F] = 0 - this.lamps[second & 0x1F];
                this.rampTime[second & 0x1F] = (first + 1) * 16;
                return 0L;
            }
        }
        return 0L;
    }

    public void sendPacket() {
        if (this.portConnect) {
            try {
                this.DLC.stop();
                this.DLC = new Serial((PApplet)this, this.currentPort, 9600);
                this.DLC.write(192);
                this.DLC.stop();
                this.DLC = new Serial((PApplet)this, this.currentPort, 38400);
                this.DLC.write(0);
                int i = 0;
                while (i < 32) {
                    this.DLC.write(this.lamps[i]);
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void checkRamps() {
        int i = 0;
        while (i < 32) {
            if (this.rampSteps[i] != 0) {
                if (this.rampTime[i] <= 20) {
                    this.lamps[i] = this.lamps[i] + this.rampSteps[i];
                    this.rampSteps[i] = 0;
                    this.rampTime[i] = 0;
                } else {
                    int s = PApplet.parseInt((float)(20L * (long)this.rampSteps[i] / (long)this.rampTime[i]));
                    this.lamps[i] = this.lamps[i] + s;
                    this.rampSteps[i] = this.rampSteps[i] - s;
                    this.rampTime[i] = this.rampTime[i] - 20;
                }
            }
            if (this.lamps[i] < 0) {
                this.lamps[i] = 0;
            }
            if (this.lamps[i] > 255) {
                this.lamps[i] = 255;
            }
            ++i;
        }
    }

    public void settings() {
        this.size(480, 320, "processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Digital_Lighting_Controller"};
        if (passedArgs != null) {
            PApplet.main((String[])Digital_Lighting_Controller.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class Button {
        public float x;
        public float y;
        public float w;
        public float h;
        public String text;
        public boolean pressed;
        public boolean lastpressed;
    }
}

