/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.Controller;
import ddf.minim.Playable;
import ddf.minim.spi.AudioRecording;

public class AudioSnippet
extends Controller
implements Playable {
    private AudioRecording recording;

    public AudioSnippet(AudioRecording rec) {
        super(rec.getControls());
        rec.open();
        this.recording = rec;
    }

    @Override
    public void play() {
        this.recording.play();
    }

    @Override
    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    @Override
    public void pause() {
        this.recording.pause();
    }

    @Override
    public void rewind() {
        this.cue(0);
    }

    @Override
    public void loop() {
        this.recording.loop(-1);
    }

    @Override
    public void loop(int n) {
        this.recording.loop(n);
    }

    @Override
    public int loopCount() {
        return this.recording.getLoopCount();
    }

    @Override
    public int length() {
        return this.recording.getMillisecondLength();
    }

    @Override
    public int position() {
        return this.recording.getMillisecondPosition();
    }

    @Override
    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        }
        if (millis > this.length()) {
            millis = this.length();
        }
        this.recording.setMillisecondPosition(millis);
    }

    @Override
    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        this.recording.setMillisecondPosition(pos);
    }

    @Override
    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    @Override
    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    public void close() {
        this.recording.close();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    @Override
    public void setLoopPoints(int start, int stop) {
        this.recording.setLoopPoints(start, stop);
    }
}

