/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class Pan
extends UGen {
    public UGen.UGenInput pan;
    private UGen audio;
    private float[] tickBuffer = new float[1];
    private static float PIOVER2 = 1.5707964f;

    public Pan(float panValue) {
        this.pan = this.addControl(panValue);
    }

    public void setPan(float panValue) {
        this.pan.setLastValue(panValue);
    }

    @Override
    protected void addInput(UGen in) {
        this.audio = in;
        this.audio.setChannelCount(1);
    }

    @Override
    protected void removeInput(UGen input) {
        if (this.audio == input) {
            this.audio = null;
        }
    }

    @Override
    protected void sampleRateChanged() {
        if (this.audio != null) {
            this.audio.setSampleRate(this.sampleRate());
        }
    }

    @Override
    public void setChannelCount(int numberOfChannels) {
        if (numberOfChannels != 2) {
            throw new IllegalArgumentException("Pan MUST be ticked with STEREO output! It doesn't make sense in any other context!");
        }
        super.setChannelCount(numberOfChannels);
    }

    @Override
    protected void uGenerate(float[] channels) {
        if (channels.length != 2) {
            throw new IllegalArgumentException("Pan MUST be ticked with STEREO output! It doesn't make sense in any other context!");
        }
        float panValue = this.pan.getLastValue();
        if (this.audio != null) {
            this.audio.tick(this.tickBuffer);
        }
        float normBalance = (panValue + 1.0f) * 0.5f;
        float leftAmp = (float)Math.cos(PIOVER2 * normBalance);
        float rightAmp = (float)Math.sin(PIOVER2 * normBalance);
        channels[0] = this.tickBuffer[0] * leftAmp;
        channels[1] = this.tickBuffer[0] * rightAmp;
    }
}

