/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.serial.Serial;

public class Simple_DLC_Master
extends PApplet {
    final int BACK_COLOUR = this.color(192, 192, 192);
    final int CONNECT_COLOUR = this.color(0, 192, 0);
    final int TEXT_COLOUR = this.color(0, 0, 0);
    final int BAR_COLOUR = this.color(128, 128, 128);
    final int SLIDER_COLOUR = this.color(0, 0, 0);
    Serial DLC;
    int printcode = -1;
    int printkey = -1;
    int serialIndex = 0;
    String portName = "-no ports-";
    String currentPort = "";
    boolean portConnect = false;
    boolean lastkey;
    boolean thismouse;
    boolean lastmouse;
    long mLast;
    int v = 0;
    int[] lamps;

    public void setup() {
        this.surface.setTitle("Silicon Chip Digital Lighting Controller");
        this.surface.setResizable(false);
        this.background(this.BACK_COLOUR);
        this.noStroke();
        this.textSize(32.0f);
        this.lastkey = this.keyPressed;
        this.lastmouse = this.mousePressed;
        if (Serial.list().length > 0) {
            this.portName = Serial.list()[0];
        }
        this.mLast = this.millis();
        this.lamps = new int[64];
        int i = 0;
        while (i < 64) {
            this.lamps[i] = 0;
            ++i;
        }
    }

    public void draw() {
        this.background(this.BACK_COLOUR);
        if (this.portConnect) {
            this.fill(this.CONNECT_COLOUR);
        } else {
            this.fill(this.TEXT_COLOUR);
        }
        this.textSize(32.0f);
        this.text(this.portName, 200.0f, 315.0f);
        this.fill(this.TEXT_COLOUR);
        this.textSize(16.0f);
        this.text("+/- to change port", 320.0f, 300.0f);
        this.text("s to start/stop", 320.0f, 315.0f);
        this.textSize(32.0f);
        boolean thiskey = this.keyPressed;
        if (thiskey && !this.lastkey) {
            this.printcode = this.keyCode;
            this.printkey = this.key;
            if (!(this.printkey != 61 && this.printkey != 43 || this.portConnect)) {
                ++this.serialIndex;
            }
            if (!(this.printkey != 45 && this.printkey != 95 || this.portConnect)) {
                --this.serialIndex;
                if (this.serialIndex < 0) {
                    this.serialIndex = 0;
                }
            }
            if (this.serialIndex > Serial.list().length - 1) {
                this.serialIndex = Serial.list().length - 1;
            }
            if (Serial.list().length > 0) {
                this.portName = Serial.list()[this.serialIndex];
            }
            if (this.printkey == 115 || this.printkey == 83) {
                if (!this.portConnect) {
                    try {
                        this.currentPort = this.portName;
                        this.DLC = new Serial((PApplet)this, this.currentPort, 38400);
                        this.portConnect = true;
                    }
                    catch (Exception exception) {
                        this.portConnect = false;
                    }
                } else {
                    this.DLC.stop();
                    this.portConnect = false;
                }
            }
        }
        this.lastkey = thiskey;
        this.thismouse = this.mousePressed;
        this.fill(this.TEXT_COLOUR);
        this.textSize(12.0f);
        this.fill(this.TEXT_COLOUR);
        int i = 0;
        while (i < 16) {
            if (this.thismouse && this.mouseX > i * 30 + 2 && this.mouseX < i * 30 + 28 && this.mouseY < 266) {
                this.lamps[i] = 260 - this.mouseY;
                if (this.lamps[i] < 0) {
                    this.lamps[i] = 0;
                }
                if (this.lamps[i] > 255) {
                    this.lamps[i] = 255;
                }
            }
            this.fill(this.BAR_COLOUR);
            this.rect(i * 30 + 5, 5.0f, 20.0f, 256.0f);
            this.fill(this.SLIDER_COLOUR);
            this.rect(i * 30 + 2, 258 - this.lamps[i], 26.0f, 6.0f);
            this.fill(this.TEXT_COLOUR);
            this.text(("   " + Simple_DLC_Master.str((int)this.lamps[i])).substring(Simple_DLC_Master.str((int)this.lamps[i]).length()), i * 30 + 4, 278.0f);
            ++i;
        }
        this.fill(this.TEXT_COLOUR);
        if (this.thismouse && this.mouseX > 100 && this.mouseX < 150 && this.mouseY > 290) {
            this.fill(this.CONNECT_COLOUR);
            i = 0;
            while (i < 64) {
                this.lamps[i] = 0;
                ++i;
            }
        }
        this.textSize(32.0f);
        this.text("OFF", 100.0f, 315.0f);
        this.textSize(32.0f);
        if ((long)this.millis() - this.mLast > 100L) {
            this.mLast += 100L;
            this.sendPacket();
            if (this.portConnect) {
                this.fill(this.CONNECT_COLOUR);
            } else {
                this.fill(this.TEXT_COLOUR);
            }
            this.text("TX", 10.0f, 315.0f);
        } else {
            this.fill(this.TEXT_COLOUR);
            this.text("TX", 10.0f, 315.0f);
        }
    }

    public void sendPacket() {
        if (this.portConnect) {
            try {
                this.DLC.stop();
                this.DLC = new Serial((PApplet)this, this.currentPort, 9600);
                this.DLC.write(192);
                this.DLC.stop();
                this.DLC = new Serial((PApplet)this, this.currentPort, 38400);
                this.DLC.write(0);
                int i = 0;
                while (i < 64) {
                    this.DLC.write(this.lamps[i]);
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void settings() {
        this.size(480, 320, "processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Simple_DLC_Master"};
        if (passedArgs != null) {
            PApplet.main((String[])Simple_DLC_Master.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

