/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SerialNativeInterface {
    private static final String libVersion = "2.8";
    private static final String libMinorSuffix = "0";
    public static final int OS_LINUX = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_MAC_OS_X = 3;
    private static int osType;
    public static final long ERR_PORT_BUSY = -1L;
    public static final long ERR_PORT_NOT_FOUND = -2L;
    public static final long ERR_PERMISSION_DENIED = -3L;
    public static final long ERR_INCORRECT_SERIAL_PORT = -4L;
    public static final String PROPERTY_JSSC_NO_TIOCEXCL = "JSSC_NO_TIOCEXCL";
    public static final String PROPERTY_JSSC_IGNPAR = "JSSC_IGNPAR";
    public static final String PROPERTY_JSSC_PARMRK = "JSSC_PARMRK";

    private static boolean isLibFolderExist(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            bl = true;
        }
        return bl;
    }

    private static boolean isLibFileExist(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            bl = true;
        }
        return bl;
    }

    private static boolean extractLib(String string, String string2, String string3) {
        boolean bl = false;
        File file = new File(string);
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        inputStream = SerialNativeInterface.class.getResourceAsStream("/libs/" + string2 + "/" + string3);
        if (inputStream != null) {
            byte[] byArray = new byte[4096];
            try {
                int n;
                fileOutputStream = new FileOutputStream(string);
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
                bl = true;
            }
            catch (Exception exception) {
                try {
                    fileOutputStream.close();
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public static int getOsType() {
        return osType;
    }

    public static String getLibraryVersion() {
        return "2.8.0";
    }

    public static String getLibraryBaseVersion() {
        return libVersion;
    }

    public static String getLibraryMinorSuffix() {
        return libMinorSuffix;
    }

    public static native String getNativeLibraryVersion();

    public static boolean loadLibFromPath(String string) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public native long openPort(String var1, boolean var2);

    public native boolean setParams(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, int var9);

    public native boolean purgePort(long var1, int var3);

    public native boolean closePort(long var1);

    public native boolean setEventsMask(long var1, int var3);

    public native int getEventsMask(long var1);

    public native int[][] waitEvents(long var1);

    public native boolean setRTS(long var1, boolean var3);

    public native boolean setDTR(long var1, boolean var3);

    public native byte[] readBytes(long var1, int var3);

    public native boolean writeBytes(long var1, byte[] var3);

    public native int[] getBuffersBytesCount(long var1);

    public native boolean setFlowControlMode(long var1, int var3);

    public native int getFlowControlMode(long var1);

    public native String[] getSerialPortNames();

    public native int[] getLinesStatus(long var1);

    public native boolean sendBreak(long var1, int var3);

    public static native String[] getPortProperties(String var0);

    static {
        Object object;
        Object object2;
        osType = -1;
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        String string3 = System.getProperty("user.home");
        String string4 = System.getProperty("file.separator");
        String string5 = System.getProperty("java.io.tmpdir");
        String string6 = new File(string3).canWrite() ? string3 : string5;
        String string7 = System.getProperty("java.library.path");
        if (string.equals("Linux")) {
            string = "linux";
            osType = 0;
        } else if (string.startsWith("Win")) {
            string = "windows";
            osType = 1;
        } else if (string.equals("SunOS")) {
            string = "solaris";
            osType = 2;
        } else if (string.equals("Mac OS X") || string.equals("Darwin")) {
            string = "mac_os_x";
            osType = 3;
        }
        if (string2.equals("i386") || string2.equals("i686")) {
            string2 = "x86";
        } else if (string2.equals("amd64") || string2.equals("universal")) {
            string2 = "x86_64";
        } else if (string2.equals("arm")) {
            String string8 = "sf";
            if (string7.toLowerCase().contains("gnueabihf") || string7.toLowerCase().contains("armhf")) {
                string8 = "hf";
            } else {
                try {
                    object2 = Runtime.getRuntime().exec("readelf -A /proc/self/exe");
                    object = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                    String string9 = "";
                    while ((string9 = ((BufferedReader)object).readLine()) != null && !string9.isEmpty()) {
                        if (!string9.toLowerCase().contains("Tag_ABI_VFP_args".toLowerCase())) continue;
                        string8 = "hf";
                        break;
                    }
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string2 = "arm" + string8;
        }
        String string10 = string6 + string4 + ".jssc" + string4 + string;
        String string11 = "jSSC-2.8_" + string2;
        string11 = System.mapLibraryName(string11);
        if (string11.endsWith(".dylib")) {
            string11 = string11.replace(".dylib", ".jnilib");
        }
        boolean bl = false;
        if (!SerialNativeInterface.loadLibFromPath("jSSC-2.8")) {
            if (SerialNativeInterface.isLibFolderExist(string10)) {
                if (SerialNativeInterface.isLibFileExist(string10 + string4 + string11)) {
                    bl = true;
                } else if (SerialNativeInterface.extractLib(string10 + string4 + string11, string, string11)) {
                    bl = true;
                }
            } else if (new File(string10).mkdirs() && SerialNativeInterface.extractLib(string10 + string4 + string11, string, string11)) {
                bl = true;
            }
        }
        if (bl) {
            System.load(string10 + string4 + string11);
            object2 = SerialNativeInterface.getLibraryBaseVersion();
            object = SerialNativeInterface.getNativeLibraryVersion();
            if (!((String)object2).equals(object)) {
                System.err.println("Warning! jSSC Java and Native versions mismatch (Java: " + (String)object2 + ", Native: " + (String)object + ")");
            }
        }
    }
}

