'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'                  Servo Dual Position - For Silicon Chip

'This program drives a RC servo to one of two positions. The two positions are
'set using two potentiometers and a switch selects the desired position.

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'                   NOTE THIS PROGRAM REQUIRES PBP3

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'The microcontroller is a PIC12F675 with an internal oscillator of 4MHz.

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'PORT DEFINITIONS
'================

'GPIO.0     Output      Servo drive signal.
'GPIO.1     Analogue    VR1 potentiometer.
'GPIO.2     Analogue    VR2 potentiometer.
'GPIO.3     Input       Position switch.
'GPIO.4     Output      Heartbeat LED.
'GPIO.5     Unassigned

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'CONFIGURATION SETTINGS
'======================

'This configuration method is NOT supported by PBP versions before PBP3.
#CONFIG
    __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _MCLRE_OFF & _BODEN_OFF & _CP_OFF & _CPD_OFF
#ENDCONFIG

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'DEFINITIONS
'===========

DEFINE OSC 4                'Expressly state the oscillator frequency.
DEFINE OSCCAL_1K  1         'Calibrate internal oscillator
'Define ADCIN parameters
DEFINE ADC_BITS 8           'Set number of bits in result.
DEFINE ADC_CLOCK 3          'Set clock source (3=RC).
DEFINE ADC_SAMPLEUS 50      'Set sampling time in uS.

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

'Constants
'---------
RATE_CNTL1      CON     1           'Rate 1 control ADC channel.
RATE_CNTL2      CON     2           'Rate 2 control ADC channel.

'Word Variables
'--------------
CURR_PULSE      VAR     WORD        'The current width of the servo pulse.
NEW_PULSE       VAR     WORD        'New servo pulse width.
TEMPWORD1       VAR     WORD        'Temporary variable.
TEMPWORD2       VAR     WORD        'Temporary variable.

'Byte Variables
'--------------
BEAT_CNT        VAR     BYTE        'Used to time the heartbeat.
LOOP_DELAY      VAR     BYTE        'Calculated loop delay to give approx.
                                    '50 servo pulses per second.
TEMPBYTE1       VAR     BYTE        'Temporary variable.

'Bit Variables
'-------------
POSN_SEL        VAR     BYTE        'Used to choose the rate control input.

'Port Aliases.
'-------------
HLED            VAR     GPIO.4      'Heartbeat LED.
POSN_SW         VAR     GPIO.3      'Position selection switch input pin.
SRV_PIN         VAR     GPIO.0      'Servo output pin.

'Initialisation.
'---------------

ANSEL = %00110110   'Clock source is internal RC oscillator.
                    'Set GP1 and GP2 to analog and the others to digital.
CMCON = 7           'Turn the analog comparators off.
TRISIO = 00101110   'Set the pins directions.

SRV_PIN = 0         'Set the servo pulse to the resting state.
CURR_PULSE = 1500   'Set the current pulse width to the mid-point.
LOOP_DELAY = 19
BEAT_CNT = 0
HLED = 0

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

DO
    POSN_SEL = POSN_SW
    IF POSN_SEL = 0 THEN
        'Get the value of position No1.
        ADCIN RATE_CNTL1, TEMPBYTE1
    ELSE
        'Get the value of position No2.
        ADCIN RATE_CNTL2, TEMPBYTE1
    ENDIF
    'Scale the analogue input value so that the 180 degree range of the servo
    'corresponds to full scale of the analogue input. NB. Need to allow for the
    'limitations of integer maths.
    TEMPWORD1 = (TEMPBYTE1 * 150) / 255
    NEW_PULSE = (TEMPWORD1 * 10) + 750
    'Test for a change in the servo setting. Allow for a jitter of 20.
    IF NEW_PULSE <> CURR_PULSE THEN
        IF NEW_PULSE > CURR_PULSE THEN
            TEMPWORD2 = NEW_PULSE - CURR_PULSE
        ELSE
            TEMPWORD2 = CURR_PULSE - NEW_PULSE
        ENDIF
    ENDIF
    IF TEMPWORD2 > 20 THEN
        'Change the servo position.
        CURR_PULSE = NEW_PULSE
        'Adjust the loop delay.
        TEMPWORD1 = 20000 - CURR_PULSE
        LOOP_DELAY = TEMPWORD1 / 1000
    ENDIF
    'Generate the servo pulse.
    SRV_PIN = 1
    PAUSEUS CURR_PULSE
    SRV_PIN = 0
    'Loop delay.
    PAUSE LOOP_DELAY
    'Service the heartbeat LED.
    BEAT_CNT = BEAT_CNT + 1
    IF BEAT_CNT = 50 THEN
        TOGGLE HLED
        BEAT_CNT = 0
    ENDIF
LOOP

'=============================================================================
'/////////////////////////////////////////////////////////////////////////////
'=============================================================================

