#include "mcc_generated_files/system.h"
#include "mcc_generated_files/pin_manager.h"
#include "RS232.h"


#include <stdio.h>
#include <stdlib.h>
#include <xc.h>
#include <string.h>
#include <libpic30.h>           // For __delay_ms(1000); see the 16-Bit Language Tools Libraries PDF
#include <math.h>
#include <stdint.h>         // Has the uint16_t and uint8_t definintions
#include <stdbool.h>


int put_CH_to_U1_port(int c)
{
	while ( U1STAbits.UTXBF);   // wait while Tx buffer full
	U1TXREG = c;
	return c;
} // putU1

// send a null terminated string to the UART1 serial port
void put_string_to_U1_port( char *s)
{
	while( *s)			// loop until *s == '\0' the  end of the string
		put_CH_to_U1_port( *s++);	// send the character and point to the next one
 //       put_CH_to_U1_port( '\r');       // terminate with a cr / line feed
} // putsU1

int put_CH_to_U2_port(int c)
{
	while ( U2STAbits.UTXBF);   // wait while Tx buffer full
	U2TXREG = c;
	return c;
} // putU2

// send a null terminated string to the UART1 serial port
void put_string_to_U2_port( char *s)
{
	while( *s)			// loop until *s == '\0' the  end of the string
		put_CH_to_U2_port( *s++);	// send the character and point to the next one
 //       put_CH_to_U2_port( '\r');       // terminate with a cr / line feed
} // putsU2

        void VT100_set_std_char_set()
        {
            put_str_to_console(SCS);    // select standard character set for the label text.
        }
        
        void VT100_set_special_graphics()
        {
            put_str_to_console(SGCS);    //Set special graphic character set
        }

        void VT100_clear()
        {
            put_str_to_console(clrscr);       // Clear the screen
        }
        void VT100_home()
        {
            put_str_to_console(home);       // Cusror home
        }

        void VT100_cursor_off()
        {
            put_str_to_console(cursor_off);  //Cursor off
        }

        void VT100_attrib_off()
        {
            put_str_to_console(CH_attrib_off);    // background bold on. Don't think it does much to graphics
        }

        void VT100_bold()
        {
            put_str_to_console(CH_BOLD);    // background bold on. Don't think it does much to graphics
        }

        void VT100_back_default()
        {
            put_str_to_console(CH_back_default);      // Back default
        }

        void VT100_fore_default()
        {
           put_str_to_console(CH_fore_default);      // Fore default
        }
        
        void VT100_underline()        
        {
           put_str_to_console(CH_underline);      // CH_underline
        }

        void VT100_back_blink ()         // blinking
        {
            put_str_to_console(CH_back_blink);
        }
        
        void VT100_clr_line_to_right()   // clear the line to the right
        {
            put_str_to_console(clr_line_to_right);
        }

        void VT100_clr_line_to_left()   // clear the line to the left
        {
            put_str_to_console(clr_line_to_left);
        }

        void VT100_clr_line()   // clear line completely
        {
            put_str_to_console  (clr_line);
        }

        void VT100_set_80_collumn()
        {
            put_str_to_console(set80collumn);    // 80 collumns  Lower case L  NOTE: Doing this clears the screen
        }

        void VT100_cursor_up(int count)
        {
        //comport.Write("\x1b[" + count + "A");       // Original from Visual Studio
        char buffer[10];
        snprintf(buffer, 10, "\x1b[%dA", count);
        put_str_to_console(buffer);    // Cursor up [count] lines
        }

        void VT100_cursor_down(int count)
        {
        //comport.Write("\x1b[" + count + "B");       // Original from Visual Studio
        char buffer[10];
        snprintf(buffer, 10, "\x1b[%dB", count);
        put_str_to_console(buffer);    // Cursor up [count] lines
        }

        void VT100_cursor_right(int count)   // move cursor n steps to the right 
        {
        //comport.Write("\x1b[" + count + "C");       // Original from Visual Studio
        char buffer[10];
        snprintf(buffer, 10, "\x1b[%dC", count);
        put_str_to_console(buffer);    // Cursor up [count] lines
        }

        void VT100_cursor_left(int count)   // move cursor n steps to the left 
        {
        //comport.Write("\x1b[" + count + "D");       // Original from Visual Studio
        char buffer[10];
        snprintf(buffer, 10, "\x1b[%dD", count);
        put_str_to_console(buffer);    // Cursor up [count] lines
        }

        void VT100_goto_xy(int line, int col)
        {
        //comport.Write("\x1b[" + line + ";" + col + "H");   // Line, Column       // Original from Visual Studio
        char buffer[10];
        snprintf(buffer, 10, "\x1b[%d;%dH", line,col);
        put_str_to_console(buffer);    // Cursor up [count] lines
        }

        void VT100_text_at_xy(int line, int col, char* the_text)
        {
//            comport.Write("\x1b[" + line + ";" + col + "H");   // Line, Column
//            comport.Write(the_text);
        char buffer[10];
        snprintf(buffer, 10, "\x1b[%d;%dH", line,col);
        put_str_to_console(buffer);    // Cursor up [count] lines
        put_str_to_console(the_text);
        }
        
        void VT100_show_float(double val)
        {
            char buffer[10];
            put_str_to_console(SCS);    // Standard character set
            snprintf(buffer, 10, "%4.1f", val);    // NOTE! for the float format. 4 is the MINIMUM # chars. 4 = 2 + 1dot + 1 decimal.
            put_str_to_console(buffer);    // Cursor up [count] lines
        }
        
