/*
 * File:   SSD1306_LCD.c
 * Author: Tom
 *
 * Created on November 2, 2016, 8:19 PM
 */

// <editor-fold defaultstate="collapsed" desc="Includes">
#include "xc.h"
#include "SSD1306_OLED.h"
#include <stdio.h>
#include <stdlib.h>
#include <xc.h>
#include <string.h>
#include <math.h>
#include <libpic30.h>       // http://microchip.wikidot.com/faq:74
#include <stdint.h>
#include <stdbool.h>
#include "./mcc_generated_files/spi1.h"
#include "./mcc_generated_files/pin_manager.h"


// </editor-fold>

#ifndef min
#define min(a,b) ( (a) < (b) ? (a) : (b) )
#endif
 

LCD_text_structure LCD_text_buffer;          // 

// These following from http://www.microchip.com/forums/tm.aspx?tree=true&m=722524&mpage=1

// <editor-fold defaultstate="collapsed" desc="Write_byte_to_SPI">

void iWrite_SSD1306(uint8_t data)
    { 
        SSD1306_CS_SetLow();
        SPI1_Exchange8bit(data);
        SSD1306_CS_SetHigh();
    }
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Write Command to SSD1306">
void  ssd1306_command(uint8_t cmd)
{
    SSD1306_DC_SetLow();
    iWrite_SSD1306(cmd);
    SSD1306_DC_SetHigh();
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Write Data to SSD1306">
void  ssd1306_data(uint8_t cmd)
{
    SSD1306_DC_SetHigh();
    iWrite_SSD1306(cmd);
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Initialise Display">
void  InitializeDisplay()
{
//    SSD1306_RESET = 1;  // This just lowers the reset line 
//    delay_5msec();      // Have determined that this not necessary. 
//    SSD1306_RESET = 0;  // Just tied the line to the CPU reset line. That works.
//    delay_5msec();
//    delay_5msec();
//    SSD1306_RESET = 1;
   
       // Init sequence for 128x64 OLED module
    ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE

    ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5
    ssd1306_command(0x80);                 // the suggested ratio 0x80
   
    ssd1306_command(SSD1306_SETMULTIPLEX);                  // 0xA8
    ssd1306_command(0x3F);
   
    ssd1306_command(SSD1306_SETDISPLAYOFFSET);              // 0xD3
    ssd1306_command(0x0);                                   // no offset
   
    ssd1306_command(SSD1306_SETSTARTLINE);// | 0x0);        // line #0
   
    ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D
    ssd1306_command(0x14);  // using internal VCC
   
    ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20
    ssd1306_command(0x00);          // 0x00 horizontal addressing
   
    ssd1306_command(SSD1306_SEGREMAP | 0x1); // rotate screen 180
   
    ssd1306_command(SSD1306_COMSCANDEC); // rotate screen 180
   
    ssd1306_command(SSD1306_SETCOMPINS);                    // 0xDA
    ssd1306_command(0x12);
   
    ssd1306_command(SSD1306_SETCONTRAST);                   // 0x81
    ssd1306_command(0xCF);
   
    ssd1306_command(SSD1306_SETPRECHARGE);                  // 0xd9
    ssd1306_command(0xF1);
   
    ssd1306_command(SSD1306_SETVCOMDETECT);                 // 0xDB
    ssd1306_command(0x40);
   
    ssd1306_command(SSD1306_DISPLAYALLON_RESUME);           // 0xA4
   
    ssd1306_command(SSD1306_NORMALDISPLAY);                 // 0xA6
 
    ssd1306_command(SSD1306_DISPLAYON);                     //switch on OLED
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Basics "MID()" equivalent">
// From   -   https://developer.mbed.org/forum/helloworld/topic/3846/?page=1#comment-19179

void mid(const char *src, size_t start, size_t length, char *dst, size_t dstlen)
{       size_t len = min( dstlen - 1, length);
 
        strncpy(dst, src + start, len);
        // zero terminate because strncpy() didn't ? 
        if(len < length)
                dst[dstlen-1] = 0;
}
 
int test_MID()
{
        const char *stringSrc = ("   Merry Xmas   ");   // 16 characters
        char stringDst[16] =  ("");
 
        // copy the third character only to the destination 
        mid( stringSrc, 3, 1, stringDst, sizeof(stringDst));
 
        // show what we 
        
        printf( "Source = %s\tDestination = %s\n", stringSrc, stringDst);
        printf( "The character count of the destination string is %d \n\n", strlen(stringDst));

        // copy four characters from the ninth character to the destination 
        mid( stringSrc, 9, 4, stringDst, sizeof(stringDst));
 
        // show what we did
        printf( "Source = %s\tDestination = %s\n", stringSrc, stringDst);
        printf( "The character count of the destination string is %d \n", strlen(stringDst));
 
        return 0;
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Asciitab - Used by OLED">
// From   -   https://developer.mbed.org/forum/helloworld/topic/3846/?page=1#comment-19179

static uint8_t Asciitab[768] = {
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0, 0, 0 , 6 , 95 , 6 , 0 , 0 , 0,
0 , 7 , 3 , 0 , 7 , 3 , 0 , 0, 0 , 36 , 126 , 36 , 126 , 36 , 0 , 0,
0 , 36 , 43 , 106 , 18 , 0 , 0 , 0,  0 , 99 , 19 , 8 , 100 , 99 , 0 , 0,
0 , 54 , 73 , 86 , 32 , 80 , 0 , 0,  0 , 0 , 7 , 3 , 0 , 0 , 0 , 0,
0 , 0 , 62 , 65 , 0 , 0 , 0 , 0,  0, 0 , 65 , 62 , 0 , 0 , 0 , 0,
0 , 8 , 62 , 28 , 62 , 8 , 0 , 0, 0 , 8 , 8 , 62 , 8 , 8 , 0 , 0,
0 , 0 , 224 , 96 , 0 , 0 , 0 , 0, 0 , 8 , 8 , 8 , 8 , 8 , 0 , 0, 
0 , 0 , 96 , 96 , 0 , 0 , 0 , 0,  0 , 32 , 16 , 8 , 4 , 2 , 0 , 0, 
0 , 62 , 81 , 73 , 69 , 62 , 0 , 0, 0 , 0 , 66 , 127 , 64 , 0 , 0 , 0, 
0 , 98 , 81 , 73 , 73 , 70 , 0 , 0, 0 , 34 , 73 , 73 , 73 , 54 , 0 , 0, 
0 , 24 , 20 , 18 , 127 , 16 , 0 , 0,  0 , 47 , 73 , 73 , 73 , 49 , 0 , 0, 
0 , 60 , 74 , 73 , 73 , 48 , 0 , 0,  0 , 1 , 113 , 9 , 5 , 3 , 0 , 0, 
0 , 54 , 73 , 73 , 73 , 54 , 0 , 0,  0 , 6 , 73 , 73 , 41 , 30 , 0 , 0, 
0 , 0 , 108 , 108 , 0 , 0 , 0 , 0, 0 , 0 , 236 , 108 , 0 , 0 , 0 , 0, 
0 , 8 , 20 , 4 , 65 , 0 , 0 , 0,  0 , 36 , 36 , 36 , 36 , 36 , 0 , 0, 
0 , 0 , 65 , 34 , 20 , 8 , 0 , 0, 0 , 2 , 1 , 89 , 9 , 6 , 0 , 0, 
0 , 62 , 65 , 93 , 85 , 30 , 0 , 0, 0 , 126 , 17 , 17 , 17 , 126 , 0 , 0, 
0 , 127 , 73 , 73 , 73 , 54 , 0 , 0, 0 , 62 , 65 , 65 , 65 , 34 , 0 , 0, 
0 , 127 , 65 , 65 , 65 , 62 , 0 , 0, 0 , 127 , 73 , 73 , 73 , 65 , 0 , 0, 
0 , 127 , 9 , 9 , 9 , 1 , 0 , 0, 0 , 62 , 65 , 73 , 73 , 122 , 0 , 0, 
0 , 127 , 8 , 8 , 8 , 127 , 0 , 0, 0 , 0 , 65 , 127 , 65 , 0 , 0 , 0, 
0 , 48 , 64 , 64 , 64 , 63 , 0 , 0,  0 , 127 , 8 , 20 , 34 , 65 , 0 , 0, 
0 , 127 , 64 , 64 , 64 , 64 , 0 , 0, 0 , 127 , 2 , 4 , 2 , 127 , 0 , 0, 
0 , 127 , 2 , 4 , 8 , 127 , 0 , 0, 0 , 62 , 65 , 65 , 65 , 62 , 0 , 0, 
0 , 127 , 9 , 9 , 9 , 6 , 0 , 0, 0 , 62 , 65 , 81 , 33 , 94 , 0 , 0, 
0 , 127 , 9 , 9 , 25 , 102 , 0 , 0, 0 , 38 , 73 , 73 , 73 , 50 , 0 , 0, 
0 , 1 , 1 , 127 , 1 , 1 , 0 , 0, 0 , 63 , 64 , 64 , 64 , 63 , 0 , 0, 
0 , 31 , 32 , 64 , 32 , 31 , 0 , 0, 0 , 63 , 64 , 60 , 64 , 63 , 0 , 0, 
0 , 99 , 20 , 8 , 20 , 99 , 0 , 0, 0 , 7 , 8 , 112 , 8 , 7 , 0 , 0, 
0 , 113 , 73 , 69 , 67 , 0 , 0 , 0, 0 , 0 , 127 , 65 , 65 , 0 , 0 , 0, 
0 , 2 , 4 , 8 , 16 , 32 , 0 , 0, 0 , 0 , 65 , 65 , 127 , 0 , 0 , 0, 
0 , 4 , 2 , 1 , 2 , 4 , 0 , 0, 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128, 
0 , 0 , 3 , 7 , 0 , 0 , 0 , 0,  0 , 32 , 84 , 84 , 84 , 120 , 0 , 0, 
0 , 127 , 68 , 68 , 68 , 56 , 0 , 0, 0 , 56 , 68 , 68 , 68 , 40 , 0 , 0, 
0 , 56 , 68 , 68 , 68 , 127 , 0 , 0, 0 , 56 , 84 , 84 , 84 , 8 , 0 , 0, 
0 , 8 , 126 , 9 , 9 , 0 , 0 , 0, 0 , 24 , 164 , 164 , 164 , 124 , 0 , 0, 
0 , 127 , 4 , 4 , 120 , 0 , 0 , 0, 0 , 0 , 0 , 125 , 64 , 0 , 0 , 0, 
0 , 64 , 128 , 132 , 125 , 0 , 0 , 0, 0 , 127 , 16 , 40 , 68 , 0 , 0 , 0, 
0 , 0 , 0 , 127 , 64 , 0 , 0 , 0, 0 , 124 , 4 , 24 , 4 , 120 , 0 , 0, 
0 , 124 , 4 , 4 , 120 , 0 , 0 , 0, 0 , 56 , 68 , 68 , 68 , 56 , 0 , 0, 
0 , 252 , 68 , 68 , 68 , 56 , 0 , 0, 0 , 56 , 68 , 68 , 68 , 252 , 0 , 0, 
0 , 68 , 120 , 68 , 4 , 8 , 0 , 0, 0 , 8 , 84 , 84 , 84 , 32 , 0 , 0, 
0 , 4 , 62 , 68 , 36 , 0 , 0 , 0, 0 , 60 , 64 , 32 , 124 , 0 , 0 , 0, 
0 , 28 , 32 , 64 , 32 , 28 , 0 , 0, 0 , 60 , 96 , 48 , 96 , 60 , 0 , 0, 
0 , 108 , 16 , 16 , 108 , 0 , 0 , 0, 0 , 156 , 160 , 96 , 60 , 0 , 0 , 0, 
0 , 100 , 84 , 84 , 76 , 0 , 0 , 0, 0 , 8 , 62 , 65 , 65 , 0 , 0 , 0, 
0 , 0 , 0 , 119, 0, 0, 0, 0, 0 , 0 , 65 , 65 , 62 , 8 , 0 , 0, 
0 , 2 , 1 , 2 , 1 , 0 , 0 , 0, 0 , 60 , 38 , 35 , 38 , 60 , 0 , 0 };
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Oled- Transfer string to OLED">
// From   -   https://developer.mbed.org/forum/helloworld/topic/3846/?page=1#comment-19179

void Oled (const char *Text, int Col, int Page)
{
    char Buchstabe [17];
    int  Q; 
    int  H; 
    int  Temp; 
    int  Senden; 

    Col = Col + 16 ;
    Page = Page + 175 ; 
    
    ssd1306_command(0x78);
    ssd1306_command(0x80);
    ssd1306_command(Page);

    ssd1306_command(0x78);
    ssd1306_command(0x80);
    ssd1306_command(0x00);

    ssd1306_command(0x78);
    ssd1306_command(0x80);
    ssd1306_command(Col);

    ssd1306_command(0x78);
    ssd1306_command(0x80);

    ssd1306_command(0x78);
    ssd1306_command(0x40);
    
    for (Q=0; Q<16; Q++)
    {
        Temp = 0;
        mid(Text , Q , 1, Buchstabe,sizeof(Buchstabe));
//        printf ("Plucked char Buchstabe is %s   ", Buchstabe);
        Temp = Buchstabe[0];
//        printf ("Temp is %d\n", Temp);
        Temp = Temp - 32;
        Temp = Temp * 8;
        for (H=1; H<=8; H++)
        {
            Senden = Asciitab[Temp];
            ssd1306_data(Senden);
            Temp ++;
        }
    }
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Transfer display buffer to OLED display">
void transfer_buffer_2_LCD(void)
{
Oled( LCD_text_buffer.line1 , 0 , 9) ;
Oled( LCD_text_buffer.line2 , 0 , 2) ;
Oled( LCD_text_buffer.line3 , 0 , 3) ;
Oled( LCD_text_buffer.line4 , 0 , 4) ;
Oled( LCD_text_buffer.line5 , 0 , 5) ;
Oled( LCD_text_buffer.line6 , 0 , 6) ;
Oled( LCD_text_buffer.line7 , 0 , 7) ;
Oled( LCD_text_buffer.line8 , 0 , 8) ;
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Font Data">
const uint8_t text [50][5] = {

    {0x00, 0x00, 0x00, 0x00, 0x00}, // SPACE 
    {0x00, 0x00, 0x5F, 0x00, 0x00}, // ! 
    {0x00, 0x03, 0x00, 0x03, 0x00}, // " 
    {0x14, 0x3E, 0x14, 0x3E, 0x14}, // # 
    {0x24, 0x2A, 0x7F, 0x2A, 0x12}, // $ 
    {0x43, 0x33, 0x08, 0x66, 0x61}, // % 
    {0x36, 0x49, 0x55, 0x22, 0x50}, // &
    {0x00, 0x05, 0x03, 0x00, 0x00}, // ' 
    {0x00, 0x1C, 0x22, 0x41, 0x00}, // ( 
    {0x00, 0x1C, 0x22, 0x41, 0x00}, // )  10
    {0x14, 0x08, 0x3E, 0x08, 0x14}, // * 
    {0x08, 0x08, 0x3E, 0x08, 0x08}, // + 
    {0x00, 0x50, 0x30, 0x00, 0x00}, // , 
    {0x08, 0x08, 0x08, 0x08, 0x08}, // - 
    {0x00, 0x60, 0x60, 0x00, 0x00}, // . 
    {0x20, 0x10, 0x08, 0x04, 0x02}, // / 
    {0x3E, 0x51, 0x49, 0x45, 0x3E}, // 0 
    {0x04, 0x02, 0x7F, 0x00, 0x00}, // 1 
    {0x42, 0x61, 0x51, 0x49, 0x46}, // 2 
    {0x22, 0x41, 0x49, 0x49, 0x36}, // 3   20 
    {0x18, 0x14, 0x12, 0x7F, 0x10}, // 4 
    {0x27, 0x45, 0x45, 0x45, 0x39}, // 5 
    {0x3E, 0x49, 0x49, 0x49, 0x32}, // 6 
    {0x01, 0x01, 0x71, 0x09, 0x07}, // 7 
    {0x36, 0x49, 0x49, 0x49, 0x36}, // 8 
    {0x26, 0x49, 0x49, 0x49, 0x3E}, // 9 
    {0x00, 0x36, 0x36, 0x00, 0x00}, // : 
    {0x00, 0x56, 0x36, 0x00, 0x00}, // ; 
    {0x08, 0x14, 0x22, 0x41, 0x00}, // < 
    {0x14, 0x14, 0x14, 0x14, 0x14}, // =   30
    {0x00, 0x41, 0x22, 0x14, 0x08}, // > 
    {0x02, 0x01, 0x51, 0x09, 0x06}, // ? 
    {0x3E, 0x41, 0x59, 0x55, 0x5E}, // @ 
    {0x7E, 0x09, 0x09, 0x09, 0x7E}, // A 
    {0x7F, 0x49, 0x49, 0x49, 0x36}, // B 
    {0x3E, 0x41, 0x41, 0x41, 0x22}, // C 
    {0x7F, 0x41, 0x41, 0x41, 0x3E}, // D 
    {0x7F, 0x49, 0x49, 0x49, 0x41}, // E 
    {0x7F, 0x09, 0x09, 0x09, 0x01}, // F 
    {0x3E, 0x41, 0x41, 0x49, 0x3A}, // G    40
    {0x7F, 0x08, 0x08, 0x08, 0x7F}, // H 
    {0x00, 0x41, 0x7F, 0x41, 0x00}, // I 
    {0x30, 0x40, 0x40, 0x40, 0x3F}, // J 
    {0x7F, 0x08, 0x14, 0x22, 0x41}, // K 
    {0x7F, 0x40, 0x40, 0x40, 0x40}, // L 
    {0x7F, 0x02, 0x0C, 0x02, 0x7F}, // M 
    {0x7F, 0x02, 0x04, 0x08, 0x7F}, // N 
//    {0x3E, 0x51, 0x49, 0x45, 0x3E}, // 0 
    {0x3E, 0x41, 0x41, 0x41, 0x3E}, // P 
    {0x1E, 0x21, 0x21, 0x21, 0x5E}, // Q 
    {0x7F, 0x09, 0x09, 0x09, 0x76}  // R   50
};

const uint8_t text2[44][5] =  { 

    {0x26, 0x49, 0x49, 0x49, 0x32}, // S  
    {0x01, 0x01, 0x7F, 0x01, 0x01}, // T 
    {0x3F, 0x40, 0x40, 0x40, 0x3F}, // U 
    {0x1F, 0x20, 0x40, 0x20, 0x1F}, // V 
    {0x7F, 0x20, 0x10, 0x20, 0x7F}, // W 
    {0x41, 0x22, 0x1C, 0x22, 0x41}, // X 
    {0x07, 0x08, 0x70, 0x08, 0x07}, // Y 
    {0x61, 0x51, 0x49, 0x45, 0x43}, // Z 
    {0x00, 0x7F, 0x41, 0x00, 0x00}, // [ 
    {0x02, 0x04, 0x08, 0x10, 0x20}, // \  10
    {0x00, 0x00, 0x41, 0x7F, 0x00}, // ] 
    {0x04, 0x02, 0x01, 0x02, 0x04}, // ^ 
    {0x40, 0x40, 0x40, 0x40, 0x40}, // _ 
    {0x00, 0x01, 0x02, 0x04, 0x00}, // ` 
    {0x20, 0x54, 0x54, 0x54, 0x78}, // a 
    {0x7F, 0x44, 0x44, 0x44, 0x38}, // b 
    {0x38, 0x44, 0x44, 0x44, 0x44}, // c 
    {0x38, 0x44, 0x44, 0x44, 0x7F}, // d 
    {0x38, 0x54, 0x54, 0x54, 0x18}, // e 
    {0x04, 0x04, 0x7E, 0x05, 0x05}, // f   20
    {0x08, 0x54, 0x54, 0x54, 0x3C}, // g 
    {0x7F, 0x08, 0x04, 0x04, 0x78}, // h 
    {0x00, 0x44, 0x7D, 0x40, 0x00}, // i 
    {0x20, 0x40, 0x44, 0x3D, 0x00}, // j 
    {0x7F, 0x10, 0x28, 0x44, 0x00}, // k 
    {0x00, 0x41, 0x7F, 0x40, 0x00}, // l 
    {0x7C, 0x04, 0x78, 0x04, 0x78}, // m 
    {0x7C, 0x08, 0x04, 0x04, 0x78}, // n 
    {0x38, 0x44, 0x44, 0x44, 0x38}, // o 
    {0x7C, 0x14, 0x14, 0x14, 0x08}, // p   30
    {0x08, 0x14, 0x14, 0x14, 0x7C}, // q 
    {0x00, 0x7C, 0x08, 0x04, 0x04}, // r 
    {0x48, 0x54, 0x54, 0x54, 0x20}, // s 
    {0x04, 0x04, 0x3F, 0x44, 0x44}, // t 
    {0x3C, 0x40, 0x40, 0x20, 0x7C}, // u 
    {0x1C, 0x20, 0x40, 0x20, 0x1C}, // v 
    {0x3C, 0x40, 0x30, 0x40, 0x3C}, // w 
    {0x44, 0x28, 0x10, 0x28, 0x44}, // x 
    {0x0C, 0x50, 0x50, 0x50, 0x3C}, // y 
    {0x44, 0x64, 0x54, 0x4C, 0x44}, // z    40
    {0x00, 0x08, 0x36, 0x41, 0x41}, // { 
    {0x00, 0x00, 0x7F, 0x00, 0x00}, // | 
    {0x41, 0x41, 0x36, 0x08, 0x00}, // }
    {0x02, 0x01, 0x02, 0x04, 0x02}  // ~ 
 }; 
// </editor-fold>

uint8_t display_buffer_in_ram [1024];

// <editor-fold defaultstate="collapsed" desc="Zero out the display RAM">
   void OLED_clear() 
    { 
       uint16_t x; 
       for (x = 0; x < 1024; x++) 
      { 
          display_buffer_in_ram[x] = 0x00; 
       } 
    } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Transfer Const BITMAP data to display ram">
void txfr_bitmap_2_disp_RAM(const uint8_t *pointr) 
    { 
       uint16_t x; 
       uint8_t c; 
       
       for (x = 0; x < 1024; x++) 
       { 
          c = pointr [x]; 
          display_buffer_in_ram[x] = c; 
       } 
    } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Write the Buffer data to OLED display">
void OLED_write(void) 
 { 
    uint16_t i; 
    
    ssd1306_command (0x21) ; 
    ssd1306_command (0x00); 
    ssd1306_command (127); 
    ssd1306_command (0x22) ; 
    ssd1306_command (0x00); 
    ssd1306_command (7); 

    for (i = 0; i < 1024; i++) 
    { 
       ssd1306_data (display_buffer_in_ram[i]) ; 
    } 
 } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Sets a display pixcel Apparently">
void OLED_pixel(uint16_t x,uint16_t y) 
 { 
    uint16_t nt; 
    uint16_t pagina; 
    uint16_t bit; 
    
    pagina = y /8; 
    bit= y-(pagina*8); 
    nt = display_buffer_in_ram[pagina*128+x]; 
    nt |= 1 << bit; 
    display_buffer_in_ram[pagina*128+x] = nt; 
 } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Draw a line from x,y  to  x,y">
void OLED_line (int x1, int y1, int x2, int y2) 
 { 
       signed int x, y, addx, addy, dx, dy; 
       signed long P; 
       int i; 
       dx = abs ( (signed int) (x2 - x1)); 
       dy = abs ( (signed int) (y2 - y1)); 
       x = x1; 
       y = y1; 

       if (x1 > x2) 
          addx = -1; 

       else 
       addx = 1; 

       if (y1 > y2) 
          addy = -1; 

       else 
       addy = 1; 

       if (dx >= dy) 
       { 
          P = 2 * dy - dx; 
          for (i = 0; i <= dx;  ++i) 
          { 
             OLED_pixel (x, y); 

             if (P < 0) 
             { 
                P += 2*dy; 
                x += addx; 
             } 

             else 
             { 
                P += 2*dy - 2 * dx; 
                x += addx; 
                y += addy; 
             } 
          } 
       } 

       else 
       { 
          P = 2 * dx - dy; 
          for (i = 0; i<= dy;  ++i) 
          { 
             OLED_pixel (x, y); 

             if (P < 0) 
             { 
                P += 2*dx; 
                y += addy; 
             } 

             else 
             { 
                P += 2*dx - 2 * dy; 
                x += addx; 
                y += addy; 
             } 
          } 
       } 
 } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Utility function to test a bit (n) in a BYTE (word)">
bool  bit_test (uint8_t  word, int  n)  
{  
    if ( n < 0  || n > 7 )  
       return  false;  

//    if ( (word >> (7 - n)) & 0x1 )  
    if ( (word >> n) & 0x1 )  
       return true;  
    else  
       return false;  
} 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Displays text at X,Y, from (textptr) size (size)">
   void OLED_text(int x, int y, char* textptr, int size) 
    { 
       int i, j, k, l, m;     // Loop counters 
       uint8_t pixelData[5];     // Stores character data 
       for (i = 0; textptr[i] != '\0'; ++i, ++x) // Loop through the passed string 
       { 
          if (textptr[i] < 'S') // Checks if the letter is in the first text array 
             memcpy (pixelData, text[textptr[i] - ' '], 5) ; 

          else if (textptr[i] <= '~') // Check if the letter is in the second array 
             memcpy (pixelData, text2[textptr[i] - 'S'], 5) ; 

          else 
          memcpy (pixelData, text[0], 5); // DEFAULT to space 
          if (x + 5 * size >= 128)  // Performs character wrapping 
          { 
             x = 0;       // Set x at far left position 
             y += 7*size + 1;    // Set y at next position down 
          } 

          for (j = 0; j<5; ++j, x += size)  // Loop through character byte data 
          { 
             for (k = 0; k<7 * size; ++k)  // Loop through the vertical pixels 
             { 
                if (bit_test (pixelData[j], k)) // Check if the pixel should be set 
                { 
                   for (l = 0; l<size; ++l) // The next two loops change the 
                   { 
                      // character's size 
                      for (m = 0; m<size; ++m) 
                      { 
                         OLED_pixel (x + m, y+k * size + l); // Draws the pixel 
                      } 
                   } 
                } 
             } 
          } 
       } 
    } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Draws a circle at X,Y with radius (radius) filled or not (riemp)">
   void OLED_circle(int x, int y, int radius, int riemp) 
    { 
       signed int a, b, P; 
       a = 0; 
       b = radius; 
       P = 1 - radius; 

       do 
       { 
          if (riemp) 
          { 
             OLED_line (x - a, y+b, x + a, y + b); 
             OLED_line (x - a, y-b, x + a, y - b); 
             OLED_line (x - b, y+a, x + b, y + a); 
             OLED_line (x - b, y-a, x + b, y - a); 
          } 

          else 
          { 
             OLED_pixel (a + x, b+y); 
             OLED_pixel (b + x, a+y); 
             OLED_pixel (x - a, b+y); 
             OLED_pixel (x - b, a+y); 
             OLED_pixel (b + x, y-a); 
             OLED_pixel (a + x, y-b); 
             OLED_pixel (x - a, y-b); 
             OLED_pixel (x - b, y-a); 
          } 

          if (P < 0) 
             P += 3 + 2 * a++; 

          else 
          P += 5 + 2 * (a++ - b--); 
       } while (a <= b); 
    } 
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Draws a rectangle from X,Y to x,y filled or not (riemp) ">
void OLED_rect(int x1, int y1, int x2, int y2, int riemp) 
    { 
       if (riemp) 
       { 
          int y, ymax;      // Find the y min and max 
          if (y1 < y2) 
          { 
             y = y1; 
             ymax = y2; 
          } 

          else 
          { 
             y = y2; 
             ymax = y1; 
          } 

          for (; y <= ymax; ++y)     // Draw lines to fill the rectangle 
             OLED_line (x1, y, x2, y); 
       } 

       else 
       { 
          OLED_line (x1, y1, x2, y1); // Draw the 4 sides 
          OLED_line (x1, y2, x2, y2); 
          OLED_line (x1, y1, x1, y2); 
          OLED_line (x2, y1, x2, y2); 
       } 
    } 
// </editor-fold>
