/**
  PIN MANAGER Generated Driver File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.c

  @Summary:
    This is the generated manager file for the PIC24 / dsPIC33 / PIC32MM MCUs device.  This manager
    configures the pins direction, initial state, analog setting.
    The peripheral pin select, PPS, configuration is also handled by this manager.

  @Description:
    This source file provides implementations for PIN MANAGER.
    Generation Information :
        Product Revision  :  PIC24 / dsPIC33 / PIC32MM MCUs - 1.145.0
        Device            :  PIC24FJ256GA704
    The generated drivers are tested against the following:
        Compiler          :  XC16 v1.36b
        MPLAB 	          :  MPLAB X v5.25
*/

/*
    (c) 2019 Microchip Technology Inc. and its subsidiaries. You may use this
    software and any derivatives exclusively with Microchip products.

    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED
    WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A
    PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION
    WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION.

    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE,
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS
    BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO THE
    FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS IN
    ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF ANY,
    THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.

    MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE
    TERMS.
*/


/**
    Section: Includes
*/

#include <xc.h>
#include <stdio.h>
#include "pin_manager.h"

/**
 Section: File specific functions
*/
void (*BTN2_InterruptHandler)(void) = NULL;
void (*BTN1_InterruptHandler)(void) = NULL;
void (*BTN3_InterruptHandler)(void) = NULL;
void (*BTN4_InterruptHandler)(void) = NULL;

/**
 Section: Driver Interface Function Definitions
*/
void PIN_MANAGER_Initialize (void)
{
    /****************************************************************************
     * Setting the Output Latch SFR(s)
     ***************************************************************************/
    LATA = 0x0000;
    LATB = 0x0804;
    LATC = 0x0200;

    /****************************************************************************
     * Setting the GPIO Direction SFR(s)
     ***************************************************************************/
    TRISA = 0x0187;
    TRISB = 0x57DB;
    TRISC = 0x020D;

    /****************************************************************************
     * Setting the Weak Pull Up and Weak Pull Down SFR(s)
     ***************************************************************************/
    IOCPDA = 0x0000;
    IOCPDB = 0x0000;
    IOCPDC = 0x0000;
    IOCPUA = 0x0000;
    IOCPUB = 0x0800;
    IOCPUC = 0x0000;

    /****************************************************************************
     * Setting the Open Drain SFR(s)
     ***************************************************************************/
    ODCA = 0x0000;
    ODCB = 0x0000;
    ODCC = 0x0000;

    /****************************************************************************
     * Setting the Analog/Digital Configuration SFR(s)
     ***************************************************************************/
    ANSA = 0x0000;
    ANSB = 0x5000;
    ANSC = 0x0005;


    /****************************************************************************
     * Set the PPS
     ***************************************************************************/
    __builtin_write_OSCCONL(OSCCON & 0xbf); // unlock PPS

    RPOR11bits.RP22R = 0x000D;    //RC6->OC1:OC1
    RPINR18bits.U1RXR = 0x0003;    //RB3->UART1:U1RX
    RPOR10bits.RP20R = 0x000D;    //RC4->OC1:OC1
    RPOR8bits.RP17R = 0x0007;    //RC1->SPI1:SDO1
    RPOR1bits.RP2R = 0x0003;    //RB2->UART1:U1TX
    RPOR6bits.RP13R = 0x0008;    //RB13->SPI1:SCK1OUT
    RPOR10bits.RP21R = 0x000D;    //RC5->OC1:OC1

    __builtin_write_OSCCONL(OSCCON | 0x40); // lock PPS

    /****************************************************************************
     * Interrupt On Change: negative
     ***************************************************************************/
    IOCNAbits.IOCNA0 = 1;    //Pin : RA0
    IOCNAbits.IOCNA1 = 1;    //Pin : RA1
    IOCNAbits.IOCNA7 = 1;    //Pin : RA7
    IOCNAbits.IOCNA8 = 1;    //Pin : RA8
    /****************************************************************************
     * Interrupt On Change: flag
     ***************************************************************************/
    IOCFAbits.IOCFA0 = 0;    //Pin : RA0
    IOCFAbits.IOCFA1 = 0;    //Pin : RA1
    IOCFAbits.IOCFA7 = 0;    //Pin : RA7
    IOCFAbits.IOCFA8 = 0;    //Pin : RA8
    /****************************************************************************
     * Interrupt On Change: config
     ***************************************************************************/
    PADCONbits.IOCON = 1;    //Config for PORTA

    /****************************************************************************
     * Interrupt On Change: Interrupt Enable
     ***************************************************************************/
    IFS1bits.IOCIF = 0; //Clear IOCI interrupt flag
    IEC1bits.IOCIE = 1; //Enable IOCI interrupt
}

void BTN2_SetInterruptHandler(void (* InterruptHandler)(void))
{ 
    IEC1bits.IOCIE = 0; //Disable IOCI interrupt
    BTN2_InterruptHandler = InterruptHandler; 
    IEC1bits.IOCIE = 1; //Enable IOCI interrupt
}

void BTN1_SetInterruptHandler(void (* InterruptHandler)(void))
{ 
    IEC1bits.IOCIE = 0; //Disable IOCI interrupt
    BTN1_InterruptHandler = InterruptHandler; 
    IEC1bits.IOCIE = 1; //Enable IOCI interrupt
}

void BTN3_SetInterruptHandler(void (* InterruptHandler)(void))
{ 
    IEC1bits.IOCIE = 0; //Disable IOCI interrupt
    BTN3_InterruptHandler = InterruptHandler; 
    IEC1bits.IOCIE = 1; //Enable IOCI interrupt
}

void BTN4_SetInterruptHandler(void (* InterruptHandler)(void))
{ 
    IEC1bits.IOCIE = 0; //Disable IOCI interrupt
    BTN4_InterruptHandler = InterruptHandler; 
    IEC1bits.IOCIE = 1; //Enable IOCI interrupt
}


/* Interrupt service routine for the IOCI interrupt. */
void __attribute__ (( interrupt, no_auto_psv )) _IOCInterrupt ( void )
{
    if(IFS1bits.IOCIF == 1)
    {
        // Clear the flag
        IFS1bits.IOCIF = 0;
        if(IOCFAbits.IOCFA1 == 1)
        {
            IOCFAbits.IOCFA1 = 0;  //Clear flag for Pin - RA1
            if(BTN2_InterruptHandler) 
            { 
                BTN2_InterruptHandler(); 
            }
        }
        if(IOCFAbits.IOCFA0 == 1)
        {
            IOCFAbits.IOCFA0 = 0;  //Clear flag for Pin - RA0
            if(BTN1_InterruptHandler) 
            { 
                BTN1_InterruptHandler(); 
            }
        }
        if(IOCFAbits.IOCFA7 == 1)
        {
            IOCFAbits.IOCFA7 = 0;  //Clear flag for Pin - RA7
            if(BTN3_InterruptHandler) 
            { 
                BTN3_InterruptHandler(); 
            }
        }
        if(IOCFAbits.IOCFA8 == 1)
        {
            IOCFAbits.IOCFA8 = 0;  //Clear flag for Pin - RA8
            if(BTN4_InterruptHandler) 
            { 
                BTN4_InterruptHandler(); 
            }
        }
    }
}
