// <editor-fold defaultstate="collapsed" desc="Interface requirements">

//	SCKxOUT		Output	Standard SPI Clock
//	SDIx		Input	Standard SPI data in  (NOT REQUIRED)
//	SDOx		Output	Standard SPI data out
//	CS1_latch	Output	Active Hi. MIC5841 Cathode pull down latch load
//	CS2_latch	Output	Active Hi. MIC5891 Anode pull up latch load
//	MUX_OE      Output	Active Lo. Enable Start High. Used to disable while loading so don't see garbage and jitter

// Comment out / change the following to reflect the timer being used.

// These next two are defined in the .h file as these need to be referenced externally
// #define mux_stop()    TMR2_Stop()
// #define mux_start()   TMR2_Start()

// The defines below are only referenced locally in the .c file.

//	#define SPI_Exchange8bit(s)           SPI1_Exchange8bit(s)    // This is defined in SPIx.c
//	#define SPI_Exchange8bit(s)           SPI2_Exchange8bit(s)    // Change for the SPI that's being used

//	#define mux_timer_IF          IFS0bits.T2IF     // This only appears at the end of the MUX routine
//	#define mux_timer_IF          IFS1bits.T5IF

// Make sure to put this in the timer interrupt callback routine
// extern  bool    mux_time_up;
// mux_time_up =   true;

// To call driver and actually display something, the at a minimum need to have something like-
//    disp_ssid();  //Put something on the display buffer

//    while (1)     // Sit in a loop waiting for the interrupt to time out.
//    {
//        if (mux_time_up)    // Set by the tmr2 interrupt routine
//        {
//            mux_time_up =   false;  // reset it immediately
//            muxer();                // Do the work. NOTE, this is the key routine
//        }
//    }


// </editor-fold>

#define CPU_CLOCK          (32000000)       // 16MHz Primary 
#define TCY_CLOCK          (CPU_CLOCK/2)
#define FCY                (CPU_CLOCK/2)

// <editor-fold defaultstate="collapsed" desc="Includes">
#include "mcc_generated_files/pin_manager.h" 
#include <stdbool.h>
#include "mcc_generated_files/spi1.h"   // These are the SPI routines
#include <libpic30.h>       // for __delay_ms()   NOTE: you have to define FCY for this to work. 
#include <string.h>
#include <stdlib.h>
#include <xc.h>
#include <stdio.h>
#include <math.h>
#include <stdint.h>
#include "mcc_generated_files/spi2.h"
#include "LED_DISP_7SEGx6.h"
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Defines">

// Note: These-
// #define mux_stop()    TMR5_Stop()
// #define mux_start()   TMR5_Start()
// are defined in the .h file as these need to be referenced externally
// The defines below are only referenced locally

//#define SPI_Exchange8bit(s)           SPI1_Exchange8bit(s)    // This is referenced in SPIx.c
#define SPI_Exchange8bit(s)           SPI2_Exchange8bit(s)    // Change for the SPI that's being used
#define mux_timer_IF          IFS0bits.T2IF
//#define mux_timer_IF          IFS1bits.T5IF

// Bit set and clear functions are out of the MPLAB XC8 C Compiler Help for PIC MCU
// Usage bitset(foo, 6); sets bit 6 of foo.  Same as foo |= 0x40;
#define bitset(var, bitno)    ((var) |= 1UL << (bitno))
#define bitclr(var, bitno)    ((var) &= ~(1UL << (bitno)))
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Variables">
int led_disp_element_muxer = 0;     // 0-7 corresponding to the number of device selectors. 6 disp + 2 colon = 8

uint8_t led_char_disp_buffer [6];   // This will be the build buffer for whatever clock required. Just contains characters.
bool    dp0     = false;                // There are 6 displays. Each one could have dp set.
bool    dp1     = false;                // Interrupt checks these bits and sets (OR x80H) the dp bit to a ONE if this is non-zero
bool    dp2     = false;
bool    dp3     = false;
bool    dp4     = false;
bool    dp5     = false;
bool    colon1  = false;                // this is bits 6 and 7 of the led_disp_element_mux'er
bool    colon2  = false;                // Interrupt checks these bits and if set, outputs a 6 or a 7 to the mux port.
const   uint8_t    blue [4]    = {0b01111111,0b00111000,0b00111110,0b01111001};
const   uint8_t    tooth[5]    = {0b01111000,0b01011100,0b01011100,0b01111000,0b01110100};
const   uint8_t    ssid [4]    = {0b01101101,0b01101101,0b00000110,0b01011110};
const   uint8_t    pass [4]    = {0b01110011,0b01110111,0b01101101,0b01101101};
const   uint8_t    got  [3]    = {0b01111101,0b01011100,0b01111000,};
const   uint8_t    getit  [3]  = {0b01111101,0b01111001,0b01111000,};  // get is used elsewhere
const   uint8_t    net  [3]    = {0b00110111,0b01111001,0b01111000};
const   uint8_t    tine [4]    = {0b01111000,0b00110110,0b00110111,0b01111001};
const   uint8_t    setup [5]   = {0b01101101,0b01111001,0b01111000,0b00111110,0b01110011};
const   uint8_t    degree [1]  = {0b01100011};
const   uint8_t    pcent  [2]  = {0b01110011,0b01011000};

int dd;
int looper1;

const uint8_t LED_7_SEG_table[] = {
0b00111111, // 0    __FEDCBA
0b00000110, // 1    _____CB_
0b01011011, // 2    _G_ED_BA
0b01001111, // 3    _G__DCBA
0b01100110, // 4    _GF__CB_
0b01101101, // 5    _GF_DC_A
0b01111101, // 6    _GFEDC_A
0b00000111, // 7    _____CBA
0b01111111, // 8    _GFEDCBA
0b01101111, // 9    _GF_DCBA
0b01110111, // A    _GFE_CBA
0b01111100, // b    _GFEDC__
0b00111001, // C    __FED__A
0b01011000, // c    _G_ED___
0b01011110, // d    _G_EDCB_
0b01111001, // E    _GFED__A
0b01110001, // F    _GFE___A
0b01110110, // H    _GFE_CB_
0b01110100, // h    _GFE_C__
0b00011110, // J    ___EDCB_
0b00111000, // L    __FED___
0b00110111, // N    __FE_CBA
0b01010100, // n    _G_E_C__
0b01011100, // o    _G_EDC__
0b01110011, // P    _GFE__BA
0b00110011, // R    __FE__BA
0b01010000, // r    _G_E____
0b01111000, // t    _GFED___
0b00111110, // U    __FEDCB_
0b00011100, // u    ___EDC__
0b01101110, // Y    _GF_DCB_
0b00110110, // ||   __FE_CB_   Double bar for TIME
0b10000000  // DP   10000000
};
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Standard words">
void    disp_blank (void)
{
    for (dd=0; dd < 6;dd++)
    led_char_disp_buffer [dd] = 0;
}
void    disp_ssid (void)
{
    for (dd=0; dd < sizeof(ssid);dd++)
    led_char_disp_buffer [dd] =  ssid [dd];
    led_char_disp_buffer [4] =  0;
    led_char_disp_buffer [5] =  0;
}
void    disp_blue (void)
{
    for (dd=0; dd < sizeof(blue);dd++)
    led_char_disp_buffer [dd] =  blue [dd];
    led_char_disp_buffer [4] =  0;
    led_char_disp_buffer [5] =  0;
}
void    disp_tooth (void)
{
    for (dd=0; dd < sizeof(tooth);dd++)
    led_char_disp_buffer [dd] =  tooth [dd];
    led_char_disp_buffer [5] =  0;
}
void    disp_got (void)
{
    for (dd=0; dd < sizeof(got);dd++)
    led_char_disp_buffer [dd] =  got [dd];
    led_char_disp_buffer [3] =  0;
    led_char_disp_buffer [4] =  0;
    led_char_disp_buffer [5] =  0;
}
void    disp_get (void)
{
    for (dd=0; dd < sizeof(getit);dd++)
    led_char_disp_buffer [dd] =  getit [dd];
    led_char_disp_buffer [3] =  0;
    led_char_disp_buffer [4] =  0;
    led_char_disp_buffer [5] =  0;
}
void    disp_tine (void)
{
    for (dd=0; dd < sizeof(tine);dd++)
    led_char_disp_buffer [dd] =  tine [dd];
    led_char_disp_buffer [4] =  0;
    led_char_disp_buffer [5] =  0;
}
void    disp_net (void)
{
    for (dd=0; dd < sizeof(net);dd++)
    led_char_disp_buffer [dd] =  net [dd];
    led_char_disp_buffer [3] =  0;
    led_char_disp_buffer [4] =  0;
    led_char_disp_buffer [5] =  0;
}
void    disp_setup (void)
{
    for (dd=0; dd < sizeof(setup);dd++)
    led_char_disp_buffer [dd] =  setup [dd];
    led_char_disp_buffer [5] =  0;
}
void    disp_pcent (void)
{
    led_char_disp_buffer [3] =  pcent[0];
    led_char_disp_buffer [4] =  pcent[1];

}
void    disp_degree(void)
{
    led_char_disp_buffer [3] =  degree[0];

}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Testing routines">
void flash_1_seg_of_1_disp (uint8_t ch, uint8_t seg)
{
    bitset (led_char_disp_buffer [ch], seg);
    __delay_ms(60);    
    bitclr (led_char_disp_buffer [ch], seg);
}

void flash_1_seg_of_all_disp (uint8_t seg)
{
    for (looper1 = 0;looper1 <8; looper1 ++)
    {
        bitset (led_char_disp_buffer [looper1], seg);
    }
        __delay_ms(100);    
    for (looper1 = 0;looper1 <8; looper1 ++)
    {
        bitclr (led_char_disp_buffer [looper1], seg);
    }
}

void    led_disp_test(void)
{
    
for (looper1 =0; looper1<6; looper1 ++)
{
    for (dd =0; dd<8; dd ++)
    {
        flash_1_seg_of_1_disp(looper1,dd);
        __delay_ms(40);    
    }
}

    for (dd =0; dd<8; dd ++)
    {
        flash_1_seg_of_all_disp(dd);
        __delay_ms(80);    
    }

    dp0 = true;
    __delay_ms(200);    
    dp0 = false;
    dp1 = true;
    __delay_ms(200);    
    dp1 = false;
    colon1 = true;
    __delay_ms(200);   
    colon1 = false;
    dp2 = true;
    __delay_ms(200);     
    dp2 = false;
    dp3 = true;
    __delay_ms(200);   
    dp3 = false;
    colon2 = true;
    __delay_ms(200);   
    colon2 = false;
    dp4 = true;
    __delay_ms(200);   
    dp4 = false;
    dp5 = true;
    __delay_ms(200);   
    dp5 = false;
    __delay_ms(1000);  

    uint8_t abc;

    led_char_disp_buffer [1] =  degree[0];
    __delay_ms(1000);  

    led_char_disp_buffer [3] =  pcent[0];
    led_char_disp_buffer [4] =  pcent[1];
    __delay_ms(1000);  
    disp_blank();
    __delay_ms(500);  
    
    abc = '1';      
    abc -=48 ;
    led_char_disp_buffer [0] =  LED_7_SEG_table [abc];
    __delay_ms(80);  
    abc = '2';      
    abc -=48 ;
    led_char_disp_buffer [1] =  LED_7_SEG_table [abc];
    __delay_ms(80);  
    abc = '3';      
    abc -=48 ;
    led_char_disp_buffer [2] =  LED_7_SEG_table [abc];
    __delay_ms(80);  
    abc = '4';      
    abc -=48 ;
    led_char_disp_buffer [3] =  LED_7_SEG_table [abc];
    __delay_ms(80);  
    abc = '5';      
    abc -=48 ;
    led_char_disp_buffer [4] =  LED_7_SEG_table [abc];
    __delay_ms(80);  
    abc = '6';      
    abc -=48 ;
    led_char_disp_buffer [5] =  LED_7_SEG_table [abc];

    __delay_ms(1000);     
    
    disp_ssid ();
    __delay_ms(1000);    
    disp_blue ();
    __delay_ms(1000);     
    disp_tooth ();
    __delay_ms(1000);     
    colon1 = true;
    disp_got ();
    __delay_ms(1000);    // For MCP2200 USB convertor initialisation. On blue board it's connected to the MCLR line 
    disp_get ();
    __delay_ms(1000);    
    colon1 = false;
    dp1 = true;
    disp_tine ();
    __delay_ms(1000);    
    disp_net ();
    __delay_ms(1000);     
    dp1 = false;
    dp0 = true;
    disp_setup();
    __delay_ms(1000);     
    disp_ssid ();
    __delay_ms(1000);    
    dp0 = false;
    disp_blue ();
    __delay_ms(1000);     
}
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="The multiplexer">
// This has to be referenced by the timer interrupt callback.
// see tmrx.c

    void muxer(void)        // This is the interrupt routine. This needs to be referenced in the Timer Interrupt routine. Look in tmr5.c
    {
        if (led_disp_element_muxer>=8) led_disp_element_muxer = 0 ;
        MUX_OE_SetHigh();           // Disable the outputs temporarily while loading the shift register, otherwise you see the HF pulses on the O/P while the data is shifted through

        switch(led_disp_element_muxer)
        
        {

        case 0  :

    	CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	SPI_Exchange8bit(0b00000001);    // First digit active high
    	CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.

    	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        if (!dp0) SPI_Exchange8bit(led_char_disp_buffer[0]);    //clock out the data. No dp bit, so just apply the character to the port.
        else SPI_Exchange8bit (led_char_disp_buffer[0] | 0x80) ;     // If dp != 0, raise the dp pin of the display.
        led_disp_element_muxer++;       // next cycle, do the next one
    	CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        break;                  // repeat this for the 6 displays

        case 1  :
    	CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	SPI_Exchange8bit(0b00000010);    //second digit active high
    	CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.

    	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        if (!dp1) SPI_Exchange8bit (led_char_disp_buffer[1]);
        else SPI_Exchange8bit (led_char_disp_buffer[1] | 0x80) ;
        led_disp_element_muxer++;
    	CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        break; 

        case 2  :
    	CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	SPI_Exchange8bit(0b00000100);    //third digit active high
    	CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.

    	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        if (!dp2) SPI_Exchange8bit ( led_char_disp_buffer[2]);
        else SPI_Exchange8bit (led_char_disp_buffer[2] | 0x80) ;
        led_disp_element_muxer++;
    	CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        break;

        case 3  :
    	CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	SPI_Exchange8bit(0b00001000);    //clock out the data
    	CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.

    	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        if (!dp3) SPI_Exchange8bit (led_char_disp_buffer[3]);
        else SPI_Exchange8bit (led_char_disp_buffer[3] | 0x80) ;
        led_disp_element_muxer++;
    	CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
#ifdef  digit_count_4
        led_disp_element_muxer += 2;    // If there's only 4 displays, skip over display 4 (5) and 5 (6)
#endif
        break;

        case 4  :
    	CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	SPI_Exchange8bit(0b00010000);    //clock out the data
    	CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.

    	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        if (!dp4) SPI_Exchange8bit (led_char_disp_buffer[4]);
        else SPI_Exchange8bit (led_char_disp_buffer[4] | 0x80) ;
        led_disp_element_muxer++;
    	CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        break;
            
        case 5  :
    	CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	SPI_Exchange8bit(0b00100000);    //clock out the data
    	CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.

    	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        if (!dp5) SPI_Exchange8bit (led_char_disp_buffer[5]);
        else SPI_Exchange8bit (led_char_disp_buffer[5] | 0x80) ;
        led_disp_element_muxer++;
    	CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        break;

        case 6  : 
     	CS1_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
        SPI_Exchange8bit(0);    // This has to be zero here to turn off digit 4 or 6 so it doesn't stay on longer.
        CS1_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        if (colon1)
        {
            CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	    SPI_Exchange8bit(0b01000000);    // Raise the colon bit
    	    CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        }
        led_disp_element_muxer++;   // Next time, do the last one.
        break;
                            
        case 7  :
        if (colon2)
        {
            CS2_latch_SetHigh();     // Set the latch enable to high to enable loading of the data. This is like the CS
    	    SPI_Exchange8bit(0b10000000);    // clock out the data
    	    CS2_latch_SetLow();      // disable any more loading of data to shift register for this chip.
        }
        led_disp_element_muxer++;   // This would set to 9th character (8) but there isn't one. This will be fixed next time round.
        break;

        }

        MUX_OE_SetLow();            // Enable the outputs now that the data values have been applied.
        mux_timer_IF = 0;      // Always reset the flag as is continuous now.
    }
// </editor-fold>
    