
/* 
 * File:   
 * Author: 
 * Comments:
 * Revision history: 
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef XC_HEADER_TEMPLATE_H
#define	XC_HEADER_TEMPLATE_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include <stdbool.h>

void Oled (const char*, int, int);

void iWrite_SSD1306  (uint8_t);
void ssd1306_command(uint8_t);
void ssd1306_data(uint8_t);
void InitializeDisplay(void);
void transfer_buffer_2_LCD(void);

// Zeros our the display ram
void OLED_clear(void);

// Transfer Const BITMAP data to display ram
void txfr_bitmap_2_disp_RAM(const uint8_t *pointr) ;

// Write the Buffer data to OLED display
void OLED_write(void);

// Sets a display pixcel Apparently
void OLED_pixel(uint16_t x,uint16_t y);

// Draw a line from x,y  to  x,y
void OLED_line (int x1, int y1, int x2, int y2);

// Utility function to test a bit (n) in a BYTE (word)
bool  bit_test (uint8_t  word, int  n);

// Displays text at X,Y, from (textptr) size (size)
void OLED_text(int x, int y, char* textptr, int size); 

// Draws a circle at X,Y with radius (radius) filled or not (riemp)
void OLED_circle(int x, int y, int radius, int riemp);

// Draws a rectangle from X,Y to x,y filled or not (riemp)
void OLED_rect(int x1, int y1, int x2, int y2, int riemp);

#ifdef	__cplusplus
extern "C" {
#endif /* __cplusplus */

    // TODO If C++ is being used, regular C code needs function names to have C 
    // linkage so the functions can be used by the c code. 

#ifdef	__cplusplus
}
#endif /* __cplusplus */

#endif	/* XC_HEADER_TEMPLATE_H */


    //________________________________________________
typedef struct LCD_text_structure   // Structure to mirror the ASCII contents of the LCD
    {                           // http://www.cplusplus.com/doc/tutorial/structures/
        char    line1[16];      // 
        char    line2[16];      //
        char    line3[16];      //
        char    line4[16];      //
        char    line5[16];      //
        char    line6[16];      //
        char    line7[16];      //
        char    line8[16];      //
    }LCD_text_structure ;          // 
//________________________________________________


#define SSD1306_LCDWIDTH      128
#define SSD1306_LCDHEIGHT      64
#define SSD1306_SETCONTRAST   0x81
#define SSD1306_DISPLAYALLON_RESUME 0xA4
#define SSD1306_DISPLAYALLON 0xA5
#define SSD1306_NORMALDISPLAY 0xA6
#define SSD1306_INVERTDISPLAY 0xA7
#define SSD1306_DISPLAYOFF 0xAE
#define SSD1306_DISPLAYON 0xAF
#define SSD1306_SETDISPLAYOFFSET 0xD3
#define SSD1306_SETCOMPINS 0xDA
#define SSD1306_SETVCOMDETECT 0xDB
#define SSD1306_SETDISPLAYCLOCKDIV 0xD5
#define SSD1306_SETPRECHARGE 0xD9
#define SSD1306_SETMULTIPLEX 0xA8
#define SSD1306_SETLOWCOLUMN 0x00
#define SSD1306_SETHIGHCOLUMN 0x10
#define SSD1306_SETSTARTLINE 0x40
#define SSD1306_MEMORYMODE 0x20
#define SSD1306_COLUMNADDR 0x21
#define SSD1306_PAGEADDR   0x22
#define SSD1306_COMSCANINC 0xC0
#define SSD1306_COMSCANDEC 0xC8
#define SSD1306_SEGREMAP 0xA0
#define SSD1306_CHARGEPUMP 0x8D
#define SSD1306_EXTERNALVCC 0x1
#define SSD1306_SWITCHCAPVCC 0x2


