// <editor-fold defaultstate="collapsed" desc="Preamble">
/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */
// </editor-fold>

/* 
 * File:   
 * Author: 
 * Comments:
 * Revision history: 
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef XC_HEADER_TEMPLATE_H
#define	XC_HEADER_TEMPLATE_H
#endif

#include <xc.h> // include processor files - each processor file is guarded.  


#define LF      0x0a                    // ^j
#define CR      0x0d                    // ^m
#define BEL     0x7                     // ^g
#define STX     0x02                    // Start of text
#define ETX     0x03                    // End of text

#define clrscr          "\x1b[H\x1b[J\x1b[3J\x1b[2J"
// #define clrscr       "\x1b[2J"
#define cursor_up       "\x1b[A"
// #define cursor_off   "\x1b[?12l"         // Doesn't work
#define  cursor_off     "\x1b[?25l"      // Does work. From the Visual Studio VT100 testing 

#define home                "\x1b[H"
#define pcr                 '\r')

#define clr_line_to_right   "\x1b[K"    // clear the line to the right
#define clr_line_to_left    "\x1b[1K"   // clear the line to the left
#define clr_line            "\x1b[2K"   // clear line completely
    
#define CH_attrib_off       "\x1b[0m"
#define CH_BOLD             "\x1b[1m"
#define CH_dim              "\x1b[2m"
#define CH_cursive          "\x1b[3m"
#define CH_back_BOLD_off    "\x1b[21m"
#define CH_underline        "\x1b[4m"
#define CH_back_blink       "\x1b[5m"
#define CH_back_REV         "\x1b[7m"
#define CH_fore_black       "\x1b[30m"
#define CH_fore_red         "\x1b[31m"
#define CH_fore_green       "\x1b[32m"
#define CH_fore_yellow      "\x1b[33m"
#define CH_fore_blue        "\x1b[34m"
#define CH_fore_magenta     "\x1b[35m"
#define CH_fore_cyan        "\x1b[36m"
#define CH_fore_white       "\x1b[37m"
#define CH_fore_default     "\x1b[39m"
#define CH_back_black       "\x1b[40m"
#define CH_back_red         "\x1b[41m"
#define CH_back_green       "\x1b[42m"
#define CH_back_yellow      "\x1b[43m"
#define CH_back_blue        "\x1b[44m"
#define CH_back_magenta     "\x1b[45m"
#define CH_back_cyan        "\x1b[46m"
#define CH_back_white       "\x1b[47m"
#define CH_back_default     "\x1b[49m"

#define SGCS                "\x1b(0"               // Special Graphics Character Set
#define SCS                 "\x1b(A"      // Standard  Character set
#define set80collumn        "\x1b[?3l"         //80 collumns  Lower case L  NOTE: Doing this clears the screen

#define put_ch_to_console(s)            put_CH_to_U1_port(s)
#define put_str_to_console(s)           put_string_to_U1_port(s)

// send a char to the UART1 serial port
int put_CH_to_U1_port(int c);
// send a null terminated string to the UART1 serial port
void put_string_to_U1_port( char *s);
// send a char to the UART2 serial port
int put_CH_to_U2_port(int c);
// send a null terminated string to the UART2 serial port
void put_string_to_U2_port( char *s);


        void VT100_set_std_char_set();
        void VT100_set_special_graphics();
        void VT100_clear();
        void VT100_home();
        void VT100_cursor_off();
        void VT100_attrib_off();
        void VT100_back_bold();
        void VT100_back_default();
        void VT100_fore_default();
        void VT100_underline();         // CH_underline
        void VT100_back_blink ();         // blinking
        void VT100_clr_line_to_right();   // clear the line to the right
        void VT100_clr_line_to_left();   // clear the line to the left
        void VT100_clr_line();   // clear line completely
        void VT100_set_80_collumn();
        void VT100_cursor_up(int count);
        void VT100_cursor_down(int count);
        void VT100_cursor_right(int count);   // move cursor n steps to the right 
        void VT100_cursor_left(int count);   // move cursor n steps to the left 
        void VT100_goto_xy(int line, int col);
        void VT100_text_at_xy(int line, int col, char* the_text);
        void VT100_show_float();
