// <editor-fold defaultstate="collapsed" desc="Defines">
#if defined(__XC16__)
    #include <xc.h>
#elif defined(__C30__)
    #if defined(__PIC24E__)
    	#include <p24Exxxx.h>
    #elif defined (__PIC24F__)||defined (__PIC24FK__)
	#include <p24Fxxxx.h>
    #elif defined(__PIC24H__)
	#include <p24Hxxxx.h>
    #endif
#endif

// #define AM2302_testing
// #define debug_on_RS232

#define AM2302_SDA_pin_TRIS	(TRISCbits.TRISC8)         // The temperature / humidity sensor
#define AM2302_SDA_pin		(PORTCbits.RC8)            // Note READ the port and write the latch. 
#define AM2302_SDA_latch	(LATCbits.LATC8)            // Note READ the port and write the latch. 

#define FCY 	(16000000)
#define input   1
#define output  0

// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="Includes">
//#include "HW_Profile.h"   // If your using __delay_ms, this must be placed before it to define fcy
#include <stdint.h>          /* For uint32_t definition */
#include <stdbool.h>         /* For true/false definition */
#include <libpic30.h>       // for __delay_ms()   NOTE: you have to define FCY for this to work. 
#include <stdint.h>          /* For uint32_t definition */
#include <stdbool.h>         /* For true/false definition */
#include <stdlib.h>
#include <libpic30.h> 
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <time.h>            /* for asctime, tm */
#include "mcc_generated_files/tmr1.h"   // This is for sec_incrementer and sec_snapshot for the timeout variables
// </editor-fold>

// <editor-fold defaultstate="collapsed" desc="display_AM2302_buffer_as_binary">
// it's populated here for testing purposes.
        
        void  display_AM2302_buffer_as_binary(int *buf)             // Sends the content of the buffer out the serial port.
                                                    // Should contain 1 or 0.
    {
        int i2 = 0;
        printf("This is the 40 Bit AM2302 buffer data ");

        for (i2 = 0; i2 < 40; i2++)
		{
//			if   (AM2302_buffer[i2]== 1) put_ch_to_console('1');
//                        else if (AM2302_buffer[i2]== 0) put_ch_to_console('0');
//                        else put_ch_to_console('e');     // e for error.
			if   (buf[i2]== 1) printf("1");
                        else if (buf[i2]== 0) printf("0");
                        else printf("e");     // e for error.
		}
        printf("\r\n");
        }

        // </editor-fold>

// <editor-fold defaultstate="collapsed" desc="read_the_AM2302">
int    read_the_AM2302 (void)
{
	unsigned int humid_hi = 0;
	unsigned int humid_lo = 0;
    double   humidityAM2302    =   0;    // don't need a double, a float would do, but sprintf wants double.
	unsigned int temp_hi = 0;
	unsigned int temp_lo = 0;
    double   temperatureAM2302    =   0;
	unsigned int parity_byte = 0;
	unsigned int parity_compare = 0;
    int i3 = 0;
    int j;

    extern char am2302temp[6];      // Declared in main. Used for the output of the data from "read_the_AM2302" below 
    extern char am2302humid[6];
    int AM2302_buffer[] = { 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0 };
    
 // #define AM2302_testing

#ifdef debug_on_RS232
        printf ("\r\nEntering read_the_AM2302();\r\n");
#endif

#ifdef AM2302_testing
    display_AM2302_buffer_as_binary(AM2302_buffer);    // Initially, the buffer contains values as taken from the Manual.
    printf("During the time the pulse is high, a counter is incremented.\n");
    printf("If this is greater than the discriminator value below, it's interpreted as a 1.\n");
    printf("If this is less than the value above, it's classed as a 0.\n");
    printf("The FCY is factored in as the crystal changes. With 8MHz, the count values are about 23 and 66\n");
    printf("The FCY is factored in as the crystal changes. With 16MHz, the count values are about 46 and 132\n");
    printf("Therefore the discrimination value should be approximately 1/2 way between those values, no matter what the FCY is.\n");
    printf("\nThe value of FCY is %ld.\n", FCY);
    printf("\nAnd the arbitrary count discrimination value is %ld.\n", FCY/350000);
    printf("\nThe actual results of the timed incremented counts are shown below.\n");
    printf("You should see how the numbers > the discriminator value correspond to a 1\n");
    printf("and the numbers < the discrimator value correspond to a 0.\n");

#endif
        
// This just shows what they are. Send it out the serial port.
//LED1_IO = 1;                // For testing, pulse a pin so that can check the timing of "Start of pulses"
//LED1_IO = 0;                // Flip Flop

        AM2302_SDA_pin_TRIS = output;   // Get ready to drive the pin low
       
        AM2302_SDA_latch = 0;           // lower the pin to give signal
        for (j=0;j<FCY/9900; j++);      // Have to wait at least 800uS according to the manual. This value found by looking with Oscilloscope.

        sec_snapshot = sec_incrementer; // Snapshot of current. Make sure interrupts on for this to work

        AM2302_SDA_latch = 1;           // can do this but is unnecessary. (?) Releasing the pin from output will cause it to go to "pull-up" state.
        AM2302_SDA_pin_TRIS = input;    // Now have to listen. Change to input mode.

        while ((AM2302_SDA_pin) && ((sec_incrementer-2) < sec_snapshot)) ;  // Either the pin is driven DOWN by the AM2302, or the timer timed out.
        // Make sure interrupts are on or sec_incrementer doesn't get incremented
        
    if ((sec_incrementer-2) >= sec_snapshot) // something has happened. Is it a timeout? If yes, bomb-out.
    {
#ifdef  debug_on_RS232
	printf("There's no response from the AM2302. Maybe this is the first run after a power on? Try a reset.\n\n");
#endif
        return (-1);
    }

        while (!AM2302_SDA_pin);        // AM2302 asserts low as response. No nothing.
        while (AM2302_SDA_pin);         // AM2302 releases to HIGH as response. No nothing.
                                        // Now is when the 40 pulses start. Have to capture and time them.
//        LED0_IO ^= 0x01;                // For testing, pulse a pin so that can check the timing of "Start of pulses"
//        LED0_IO ^= 0x01;                // Flip Flop

        for (j=0;j<40; j++)             // There are 5*8=40 pulses. Do this 40 times.
            {
                while (!AM2302_SDA_pin);    // The first part of the pulse is LOW. Do nothing
                while (AM2302_SDA_pin)      // The width of the HIGH part determines weather it's a 1 or 0
                    {                       // So start counting while the pin is High. The count is just incrementing one of 40 AM2302_buffer elements.
                        AM2302_buffer[j]++;     //FCY = 16MHz /  for a zero, this adds to about 23
                    }
            }

#ifdef AM2302_testing

        printf("\n");
        for (j=0;j<40; j++)             // There are 5*8=40 pulses. Do this 40 times.
        {
            printf("%d ", AM2302_buffer[j]);    
        }
        printf("\n");
#endif
        
        for (j=0;j<40; j++)             // Now convert the timing values to corresponding ONE's or ZERO's
            {
                if (AM2302_buffer[j] < (FCY/350000)) AM2302_buffer[j] = 0;      // If it's < about 30 (for 8MHz), it's a zero
                else AM2302_buffer[j] = 1;                             // Only other option is of course a one.
            }
        
#ifdef AM2302_testing
        display_AM2302_buffer_as_binary(AM2302_buffer);    // Initially, the buffer contains values as taken from the Manual.
#endif

        // This section steps through the 40 bit buffer 8 bits at a time and builds the 5 BYTE values of Humidity, Temperature and Parity
        // It does it by setting the relevant bit in the byte value according to whether the BUFFER is a 1 or 0.
        // It does it in reverse order because the bits are issued from the AM2302 in reverse order. Hence the (7-i3)
        // See the Visual Studio C++ program titled BitwiseTesting.cpp for the testing of this sequence.

       	for (i3=0;i3<8;i3++)		// for as many 'n' bits as there are in the variable. (8) these are Bits 0 - 7
	{
		if (AM2302_buffer[i3] == 1)		// if the sample is a 1,
		humid_hi |= 1 << (7 -i3);       //  set the 'n' bit.  (Note the 7 is the 8th bit) This is reversing the sequence of the bits
		else
		humid_hi &= ~(1 << (7 - i3));	// the sample MUST be a 0, so RESET the 'n' bit
	}
 

	for (i3 = 8; i3 < 16; i3++)		// for as many 'n' bits as there are in the variable. (8) these are Bits 8 - 15
	{
		if (AM2302_buffer[i3] == 1)			// if the sample is a 1,
			humid_lo |= 1 << (7 - (i3 - 8));			//  set the 'n' bit.
		else
			humid_lo &= ~(1 << (7 - (i3 - 8)));		// the sample MUST be a 0, so RESET the 'n' bit
	}

	for (i3 = 16; i3 < 24; i3++)		// for as many 'n' bits as there are in the variable. (8) these are Bits 16 - 23
	{
		if (AM2302_buffer[i3] == 1)			// if the sample is a 1,
			temp_hi |= 1 << (7 - (i3 - 16));			//  set the 'n' bit.
		else
			temp_hi &= ~(1 << (7 - (i3 - 16)));		// the sample MUST be a 0, so RESET the 'n' bit
	}

	for (i3 = 24; i3 < 32; i3++)		// for as many 'n' bits as there are in the variable. (8) these are Bits 24 - 31
	{
		if (AM2302_buffer[i3] == 1)			// if the sample is a 1,
			temp_lo |= 1 << (7 - (i3 - 24));			//  set the 'n' bit.
		else
			temp_lo &= ~(1 << (7 - (i3 - 24)));		// the sample MUST be a 0, so RESET the 'n' bit
	}

	for (i3 = 32; i3 < 40; i3++)		// for as many 'n' bits as there are in the variable. (8) these are Bits 32 - 39
	{
		if (AM2302_buffer[i3] == 1)			// if the sample is a 1,
			parity_byte |= 1 << (7 - (i3 - 32));			//  set the 'n' bit.
		else
			parity_byte &= ~(1 << (7 - (i3 - 32)));		// the sample MUST be a 0, so RESET the 'n' bit
	}

                parity_compare = (humid_hi + humid_lo + temp_hi + temp_lo);     // Calculate the parity byte from read values.
                parity_compare &= 0xff;                     // the parity builder is 8 bits. Need to truncate off any higher bits.

//                parity_compare = 0xff;                     // for testing. Force an error to see the 99.9.

                if (parity_byte == parity_compare)          // if tests equal, data okay. Do the calculations.
                {
// This has to be done in a two step process because the humid values are integer.
// If don't put the division on a separate line transaction, the decimal will be truncated
// because the calculation will be forced to use integer logic.
                    humidityAM2302 = ((256 * humid_hi) + humid_lo);
                    humidityAM2302 = humidityAM2302 / 10;
                    temperatureAM2302 = ((256 * temp_hi) + temp_lo);
                    temperatureAM2302 = temperatureAM2302 / 10;

                }
                else        // Doesn't match. Error.

                {
                    temperatureAM2302 = 99.9;
                    humidityAM2302 = 99.9;
                }
//                display_a_double_on_LCD_here (humidityAM2302,L1C10);
//                write_character_LCD(EADMSYM_PERC);  // can also do this-  write_character_LCD('%%');
//                display_a_double_on_LCD_here (temperatureAM2302,L2C10);
//                write_character_LCD(EADMSYM_DEG);
                snprintf (am2302humid,16,"%.1f", humidityAM2302);       // Convert the double into a string
                snprintf (am2302temp,16,"%.1f", temperatureAM2302);     // Convert the double into a string

#ifdef debug_on_RS232
                printf("Humidity = %s\tTemperature = %s\n",am2302humid,am2302temp);
                printf ("Exiting  read_the_AM2302();\n");
#endif
                
        return 0;

}
// </editor-fold>
