
#include <Adafruit_GFX.h>
#include <Fonts/FreeMonoBoldOblique12pt7b.h>
#include <Fonts/FreeSerif9pt7b.h>
#include <Fonts/FreeMono9pt7b.h>

#include <Fonts/Dialog_plain_5.h>
#include <Adafruit_NeoMatrix.h>
#include <Adafruit_NeoPixel.h>
#ifndef PSTR
 #define PSTR // Make Arduino Due happy
#endif

#define PIN 2

//straight top
Adafruit_NeoMatrix matrix1 = Adafruit_NeoMatrix(16,16,2,2, PIN,
  NEO_TILE_TOP   + NEO_TILE_LEFT   + NEO_TILE_ROWS   + NEO_TILE_PROGRESSIVE +
  NEO_MATRIX_BOTTOM + NEO_MATRIX_LEFT + NEO_MATRIX_ROWS + NEO_MATRIX_ZIGZAG,
  NEO_GRB + NEO_KHZ800);

//reverse bottom
Adafruit_NeoMatrix matrix2 = Adafruit_NeoMatrix(16,16,2,2, PIN,
  NEO_TILE_BOTTOM   + NEO_TILE_LEFT   + NEO_TILE_ROWS   + NEO_TILE_PROGRESSIVE +
  NEO_MATRIX_TOP + NEO_MATRIX_LEFT + NEO_MATRIX_ROWS + NEO_MATRIX_ZIGZAG,
  NEO_GRB + NEO_KHZ800);


const uint16_t colors[] = {
  matrix1.Color(10,25,95), 
  matrix1.Color(20,55,70), 
  matrix1.Color(30,165,135),
  matrix1.Color(40,170,155), 
   
  matrix1.Color(50, 155,170), 
  matrix1.Color(60,65,135),
  matrix1.Color(70,70,155), 

   
  matrix1.Color(80, 155,170), 
  matrix1.Color(90,115,35),
  matrix1.Color(120,150,55), 
  
  matrix1.Color(0,0,0)
  };


static const unsigned char PROGMEM logo16_glcd_bmp[] =
{ B00000000, B11000000,
  B00000001, B11000000,
  B00000001, B11000000,
  B00000011, B11100000,
  B11110011, B11100000,
  B11111110, B11111000,
  B01111110, B11111111,
  B00110011, B10011111,
  B00011111, B11111100,
  B00001101, B01110000,
  B00011011, B10100000,
  B00111111, B11100000,
  B00111111, B11110000,
  B01111100, B11110000,
  B01110000, B01110000,
  B00000000, B00110000 };



void setup() {
// matrix1.setFont(&FreeMono9pt7b);
 matrix1.begin();
 matrix1.setTextWrap(false);
 matrix1.setBrightness(40);
 matrix1.setTextColor(colors[0]);
 Serial.begin(115200);

matrix1.fillScreen(0);
matrix1.drawRoundRect(0,0,32,32,0,matrix1.Color(random(255),random(255),random(220) ));
//matrix1.drawCircle(16,16,15,matrix1.Color(random(200,255),random(10,200),random(255,30)) );


matrix1.show();
 
}

int y    = matrix1.width();
int pass = 0;
 
void loop() {
 
  
  matrix1.fillScreen(0);


  matrix1.setCursor(y,1);
  matrix1.setTextColor(colors[pass]);
//  matrix1.print(F("NTPC - VSTPS"));
if(--y < -150) {
    y = matrix1.width();
    if(++pass >= 9) pass = 0;
    matrix1.setTextColor(colors[pass]);
  }



matrix1.drawRoundRect(0,0,32,32,0,matrix1.Color(random(255),random(255),random(220) ));
//matrix1.drawCircle(16,16,15,matrix1.Color(random(200,255),random(10,200),random(255,30)) );



//matrix1.fillCircle(random(4,28),random(4,28),1,matrix1.Color(random(200,255),random(10,200),random(255,30)) );
//matrix1.drawTriangle(random(1,31),random(1,28),random(1,31),random(31,25),random(5,31),random(1,20),matrix1.Color(random(20,255),random(10,90),random(205,130))  );

matrix1.drawBitmap(random(1,15),random(1,15), logo16_glcd_bmp, 16,16,matrix1.Color(random(20,255),random(10,200),random(255,30)),matrix1.Color(0,0,0));
matrix1.drawChar(1,1,'p', matrix1.Color(0,0,255) , matrix1.Color(0,0,0), 2);
matrix1.show();
delay(400);

 
}
