#include <Adafruit_GFX.h>
#include <Fonts/FreeMono9pt7b.h>
#include <Adafruit_NeoMatrix.h>
#include <Adafruit_NeoPixel.h>
//#include <Fonts/Dialog_plain_5.h>
#include <Adafruit_GPS.h>
#include <SoftwareSerial.h>

#include <Wire.h>  
#include <ACROBOTIC_SSD1306.h>


#include "colors.h"

uint16_t ccenterx,ccentery;//center x,y of the clock
const uint16_t cradius = 16;//radius of the clock
const float scosConst = 0.0174533;  //2925;
float sx = 0, sy = 1, mx = 1, my = 0, hx = -1, hy = 0;
float sdeg=0, mdeg=0, hdeg=0;
uint16_t osx,osy,omx,omy,ohx,ohy;
uint16_t x0 = 0, x1 = 0, yy0 = 0, yy1 = 0;
uint32_t targetTime = 0;// for next 1 second timeout
uint8_t hh,mm,ss,ms;  //containers for current time
int dd,mn,yy;
int i=0;

int y=32 ;
int pass = 0;
String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0
uint32_t timer = millis();

void setup(){
Serial.begin(115200);

gps.begin(9600);  //16,17);
 // uncomment this line to turn on RMC (recommended minimum) and GGA (fix data) including altitude
 gps.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA);
  // uncomment this line to turn on only the "minimum recommended" data
 gps.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCONLY);
  // For parsing data, we don't suggest using anything but either RMC only or RMC+GGA since
  // the parser doesn't care about other sentences at this time
  // Set the update rate
  gps.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);   // 1 Hz update rate
  // For the parsing code to work nicely and have time to sort thru the data, and
  // print it out we don't suggest using anything higher than 1 Hz
  // Request updates on antenna status, comment out to keep quiet
  gps.sendCommand(PGCMD_ANTENNA);
  delay(1000);
  // Ask for firmware version
  serial1.println(PMTK_Q_RELEASE);

  Wire.begin();
  oled.init();                      // Initialze SSD1306 OLED display
//  oled.sendCommand(0xC4);
//  oled.sendCommand(0xC8); 
  oled.clearDisplay();              // Clear screen
//  oled.setTextXY(0,0);              // Set cursor position, start of line 0
//  oled.putString("ACROBOTIC");
//  oled.setTextXY(1,0);              // Set cursor position, start of line 1
//  oled.putString("industries");



 // matrix1.setFont(&Dialog_plain_5);
 matrix1.begin();
 matrix1.setTextWrap(false);
 matrix1.setBrightness(40);
 matrix1.setTextColor(colors[0]);

matrix1.fillScreen(0);
matrix1.show();
matrix1.fillScreen(0);
  ccenterx = matrix1.width()/2;
  ccentery = matrix1.height()/2;
  osx = ccenterx;
  osy = ccentery;
  omx = ccenterx;
  omy = ccentery;
  ohx = ccenterx;
  ohy = ccentery;
drawClockFace();// Draw clock face
matrix1.drawRoundRect(0,0,32,32,0,matrix1.Color(0,0,220) );
matrix1.show();




}

void loop(){
      char c = gps.read();
  if ((c) && (GPSECHO))
//    Serial.write(c);
// if a sentence is received, we can check the checksum, parse it...
  if (gps.newNMEAreceived()) {
    // a tricky thing here is if we print the NMEA sentence, or data
    // we end up not listening and catching other sentences!
    // so be very wary if using OUTPUT_ALLDATA and trytng to print out data
    //Serial.println(gps.lastNMEA());   // this also sets the newNMEAreceived() flag to false
    if (!gps.parse(gps.lastNMEA()))   // this also sets the newNMEAreceived() flag to false
      return;  // we can fail to parse a sentence in which case we should just wait for another
  }

   if (timer > millis())  timer = millis();
   if (millis() - timer > 500) {
    timer = millis(); // reset the timer
hh=mm=ss=dd=mn=yy=0;
hh=gps.hour;
mm=gps.minute;
ss=gps.seconds;
ms=gps.milliseconds;
dd=gps.day;
mn=gps.month;
yy=gps.year;

//timezone adjustment starts here
  mm = mm + timezonemm;
    if (mm > 59) {
      mm = mm - 60;
      hh = hh + 1;
    }
    else {
      if (mm < 0) {
        mm = mm + 60;
        hh = hh - 1;
      }
    }
    hh = hh + timezonehh;
    if (hh > 23) {
      hh = hh - 24;
      dd =dd+1;
    }
    else {
      if (hh < 0) {
        hh = hh + 24;
      }
    }
// timezone adjustment ends here

char sz[30];
sprintf(sz, "%02d/%02d/%02d %02d:%02d:%02d::%04d ", dd,mn, yy, hh, mm, ss,ms);
Serial.println(sz);

sprintf(sz, "Dt:%02d/%02d/%02d", dd,mn,yy);
oled.setTextXY(0,0);              // Set cursor position, start of line 0
oled.putString(sz);
sprintf(sz, "Tm:%02d:%02d:%02d.%03d ",hh, mm, ss,ms);
oled.setTextXY(1,0);              // Set cursor position, start of line 0
oled.putString(sz);

drawClockHands(hh,mm,ss); 
matrix1.fillCircle(3,3,1,  colors[61-mm]);
matrix1.fillCircle(28,3,1, colors[mm+5]);
matrix1.fillCircle(3,28,1, colors[mm+6]);
matrix1.fillCircle(28,28,1,colors[mm+3]);

matrix1.drawRoundRect(1,1,2,2,0,colors[pass+8] );
matrix1.writePixel(3,1,colors[pass+5] );
matrix1.writePixel(1,3,colors[pass+4] );

matrix1.drawRoundRect(29,1,2,2,0,colors[pass+8] );
matrix1.writePixel(28,1,colors[pass+5] );
matrix1.writePixel(30,3,colors[pass+4] );

matrix1.drawRoundRect(29,29,2,2,0,colors[pass+8] );
matrix1.writePixel(30,28,colors[pass+5] );
matrix1.writePixel(28,30,colors[pass+4] );

matrix1.drawRoundRect(1,29,2,2,0,colors[pass+8] );
matrix1.writePixel(1,28,colors[pass+5] );
matrix1.writePixel(3,30,colors[pass+4] );


char z[6];
int p=hh;
int q;
int length_string=55;  // 6*9 [character]

if(p>12) p=p-12;
if(p==0) p=12;
String d1=dow[calcDayOfWeek(dd,mn,yy)];
d1 = d1+" "+dd+moy[mn-1];
sprintf(z, " %2d:%02d",p,mm);
Serial.println(d1);

drawClockFace();
matrix1.drawRoundRect(0,0,32,32,0,colors[pass+9] );

if(y>-52){
if(p>=3 and p<=8){
 matrix1.setCursor(y,19);
 matrix1.setTextColor(colors[0],colors[0]);
 matrix1.print(d1);
// matrix1.drawRoundRect(0,0,32,32,0,colors[pass+9] );

 q=9;
  }
else { 
 matrix1.setCursor(y,9);
 matrix1.setTextColor(colors[0],colors[0]);
 matrix1.print(d1);
q=19;
  }
}


 matrix1.setCursor(y,q); 
 matrix1.setTextColor(colors[pass+7],colors[0]);
 matrix1.print(d1);  //+z);
if(--y <-length_string) {
    y = matrix1.width();
    if(++pass > 70) pass = 0;
    drawClockFace();
  }
matrix1.drawRoundRect(0,0,32,32,0,colors[pass+9] );
   }


}




void drawClockFace(){
//  cradius = cradius - 20;
  // Draw 12 lines
  for(int i = 3; i<363; i+= 30) {   //3 degree offset for my fixtures
    sx = cos((i-90)*scosConst);
    sy = sin((i-90)*scosConst);
    x0 = sx*(cradius-1)+ccenterx;
    yy0 = sy*(cradius-1)+ccentery;
    x1 = sx*(cradius-3)+ccenterx;
    yy1 = sy*(cradius-3)+ccentery;
    matrix1.drawLine(x0, yy0, x1, yy1, matrix1.Color(0,110,110) );  //blue
  }
matrix1.show();  
}


void drawClockHands(uint8_t h,uint8_t m,uint8_t s){
  // Pre-compute hand degrees, x & y coords for a fast screen update
  sdeg = s * 6;                  // 0-59 -> 0-354
  mdeg = m * 6 + sdeg * 0.01666667;  // 0-59 -> 0-360 - includes seconds
  hdeg = h * 30 + mdeg * 0.0833333;  // 0-11 -> 0-360 - includes minutes and seconds
  hx = cos((hdeg-90)*scosConst);    
  hy = sin((hdeg-90)*scosConst);
  mx = cos((mdeg-90)*scosConst);    
  my = sin((mdeg-90)*scosConst);
  sx = cos((sdeg-90)*scosConst);    
  sy = sin((sdeg-90)*scosConst);
int k=4;
int l=6;
int n=9;
  // Erase just old hand positions
matrix1.drawLine(ohx, ohy, ccenterx+0, ccentery+0, matrix1.Color(0,0,0) );  
matrix1.drawLine(omx, omy, ccenterx+0, ccentery+0, matrix1.Color(0,0,0) );  
matrix1.drawLine(osx, osy, ccenterx+0, ccentery+0, matrix1.Color(0,0,0) );
  // Draw new hand positions  
matrix1.drawLine(hx*(cradius-n)+ccenterx+1, hy*(cradius-n)+ccentery+1, ccenterx+0, ccentery+0, matrix1.Color(255,255,255) );  //white
matrix1.drawLine(mx*(cradius-l)+ccenterx+1, my*(cradius-l)+ccentery+1, ccenterx+0, ccentery+0, matrix1.Color(0,255,0) );
matrix1.drawLine(sx*(cradius-k)+ccenterx+1, sy*(cradius-k)+ccentery+1, ccenterx+0, ccentery+0, matrix1.Color(255,0,0) );

  // Update old x&y coords
  osx = sx*(cradius-k)+ccenterx+1;
  osy = sy*(cradius-k)+ccentery+1;
  omx = mx*(cradius-l)+ccenterx+1;
  omy = my*(cradius-l)+ccentery+1;
  ohx = hx*(cradius-n)+ccenterx+1;
  ohy = hy*(cradius-n)+ccentery+1;
matrix1.show();
}

byte   calcDayOfWeek(int d, int m, int y)  {                                                                        // https://en.wikipedia.org/wiki/Determination_of_the_day_of_the_week
        if(y<2000) y=y+2000;
        static int t[] = {0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4};
        y -= m < 3;
        return (y + y/4 - y/100 + y/400 + t[m-1] + d) % 7;                   // Sun=0, Mon=1, Tue=2, Wed=3, Thu=4, Fri=5, Sat=6
    }
