; OneLED.ASM: green LED -> PIC10F222 -> Disp. green LED 
;

		List P = 10F222
#include <P10F222.inc>

	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_ON & _MCPU_OFF & _IOFSCS_4MHZ

;----------------------------- define hardware -------------------------------

#define	 BTN1	GPIO, 3	 ; I/O line input (pushbutton)
#define	 LED	GPIO, 0	 ; I/O line to meas. LED, then light it (tens & units)
#define	 BIAS	GPIO, 1	 ; I/O line output to bias LED during measure 

;----------------------------- define variables ------------------------------

	CBLOCK	0x09		; Beginning of RAM (PIC10F222), 23 bytes

;digbyte
	units			; units digit from 8 bits ADC measure
	tens			; tens  digit from 8 bits ADC measure
	hunds			; hund. digit from 8 bits ADC measure
	tmp1, tmp2		; temporary variables, used in SP_DIGBYTE
;delay
	cnt1,cnt2		; counters
	cnt3			; number of measures for oversampling
	cntSleep
;btn
	btnCalib
	bnFlags
	var10s
;others
	meas				; 8-bit value of ADC measure
	meas10bL, meas10bH	; 10-bit oversampling
	calibL, calibH		; 10-bit calibration value
	resL, resH			; 10-bit result of temperature (in degree C)

	ENDC
;19 bytes used

;////////////////////////////////////////////////////////////////////////
;								MACROS
;////////////////////////////////////////////////////////////////////////

;------------------------------------------------------------------------
; if (file == 0) goto jmpOk ;
;------------------------------------------------------------------------
SIregNUL  macro file, jmpOk
	MOVF	file, w
	BTFSC	STATUS, Z	; file <> 0 ?
	GOTO    jmpOk		; no, i.e. file = 0
	endm
;------------------------------------------------------------------------
; if (file <> 0) goto jmpOk ;
;------------------------------------------------------------------------
SIregNOTNUL  macro file, jmpOk
	MOVF	file, w
	BTFSS	STATUS, Z	; file == 0 ?
	GOTO    jmpOk		; no, i.e. file <> 0
	endm
;------------------------------------------------------------------------
; if (file == val) goto jmpOk ;
;------------------------------------------------------------------------
SIregEQval8b	macro	file, cst, jmpOk
	MOVLW	cst
	XORWF	file, w		; file = cst
	BTFSC	STATUS, Z
	GOTO	jmpOk		; yes
	endm

;/////////////////////////////////////////////////////////////////////////////
;	MAIN PROGRAM
;/////////////////////////////////////////////////////////////////////////////
	ORG   0
	GOTO  Setup
;/////////////////////////////////////////////////////////////////////////////

#include "16b3dgt.inc"		; macros (IF statement)

;/////////////////////////////////////////////////////////////////////////////
LEDuON
	CLRW				; W = 0
	TRIS	GPIO		; reconfig. GP0 as output
	BSF		LED			; LED on
	CALL	Delay25ms	; blinks 25 ms for units count
	RETLW	0
;-----------------------------------------------------------------------------
LEDtON
	CLRW				; W = 0
	TRIS	GPIO		; reconfig. GP0 as output
	BSF		LED			; LED on
	CALL	Delay256ms	; blinks 256 ms for tens count
	RETLW	0
;-----------------------------------------------------------------------------
LEDoff
	CLRW				; W = 0
	TRIS	GPIO		; reconfig. GP0 as output
	CLRF	GPIO		; LED off
	CALL	Delay256ms
	RETLW	0
;-----------------------------------------------------------------------------
Delay1ms
	CLRWDT
	MOVLW	.1
	MOVWF	cnt2
	GOTO	DelayXms
;-----------------------------------------------------------------------------
Delay25ms
	CLRWDT
	MOVLW	.25
	MOVWF	cnt2
	GOTO	DelayXms
;-----------------------------------------------------------------------------
Delay256ms
	CLRWDT
	CLRF	cnt2
DelayXms
	CLRF	cnt1
	NOP					; 1us
	DECFSZ	cnt1, F		; 1us 
	GOTO	$-2		; 2us => 4*256 = 1024 us, approx. 1 ms internal delay loop
	CLRWDT
	DECFSZ	cnt2, F
	GOTO	$-5
	RETLW	0
;-----------------------------------------------------------------------------
ledmeas
	CLRWDT
	MOVLW	b'01000001'	; AN0 only, channel 0 only, ADC on
	MOVWF	ADCON0

	MOVLW	b'00001001'
	TRIS	GPIO		; Config. GP0 as input, GP1 as output
	BSF		BIAS		; put GP1 into high level to bias the LED

	CALL	Delay25ms	; delay to charge internal LED capacitance

	MOVLW	.8			; 32 us internal delay (quartz 4 MHz)
	MOVWF	cnt1
	NOP	
	DECFSZ	cnt1, F		; 1us
	GOTO	$-2			; internal loop = 4 * 8 = 32 us

	CLRWDT
	bsf	ADCON0, GO		; initiate one A/D conversion
	btfsc	ADCON0, GO	; A/D conversion complete ?
	goto	$-1			; no

	movf	ADRES, W	; yes, then retreive measure
	movwf	meas		; store it in meas

	CLRF	ADCON0		; AN0, AN1 as digital I/O, ADC off
	RETLW	0

;/////////////////////////////////////////////////////////////////////////////
Setup:
	BTFSC	STATUS, NOT_TO	; <4> cleared upon a WDT reset
	GOTO	fromReset
; after WDT reset, register OPTION = b'1111 1111', so reconfig.
	MOVLW  b'00001111'	; Enable wake-up and pull-up, <5>=0:use GP2, not TOCKI 
	OPTION				; and WDT prescaler 1:128 => time out # 2.3 s
	DECFSZ	cntSleep, F ; extra dead time, then Reset
	sleep
	GOTO	redoit

fromReset ; LED on during 10s (do temperature calibration)
	CLRF	ADCON0		; AN0, AN1 as digital I/O, ADC off
;-----PHASE 1-----(CALIBRATION mode)------------------------------------------
	CLRF	bnFlags
	CLRF	btnCalib
	MOVLW  b'10000111'	;no wake-up, enable pull-up, <5>=0:use GP2, not TOCKI
						;TMR0 prescaler=256 => TMR0 overflow = 65.536 ms 
	OPTION
retard
	CLRWDT
	SIregNOTNUL	TMR0, retard ; if (TMR0 <> 0) goto retard
	BSF	bnFlags, 1		; here, TMR0 = 0
	CLRF	var10s

testbtn
	CALL	LEDuON
testbtnBIS
	CLRWDT
	BTFSS	BTN1		; sense btn1
	GOTO	btn1pushed

	SIregNUL	TMR0, majVar10s ; if (TMR0 == 0) goto majVar10s
	BCF	bnFlags, 1
	GOTO	testbtnBIS

majVar10s
	BTFSC	bnFlags, 1
	GOTO	testbtnBIS	; no (i.e. bnFlags<1> = 1)
;ovflow
	INCF	var10s, F
	BSF	bnFlags, 1
	SIregEQval8b	var10s, .152, testVARS ; 152 * 65,536ms = 9961ms, #10s 
	GOTO	testbtnBIS
	
btn1pushed
	BSF	bnFlags, 0
	CLRF	var10s
	CALL	LEDoff
	CLRWDT
	BTFSS	BTN1		; BTN1 released ?
	GOTO	$-2			; no

	INCF	btnCalib, F
	GOTO	testbtn

;-----PHASE 2-----(RUN mode)--------------------------------------------------
testVARS
	CLRF	bnFlags

redoit
	MOVLW	.2
	MOVWF	cntSleep
; trim the internal oscillator accuracy to 1% at 4 MHz
	MOVLW	.48			; particular calibration value for my PIC10F222 sample
	MOVWF	OSCCAL

;config. OPTION
	MOVLW  b'00001000'	; Enable wake-up and pull-up, <5>=0:use GP2, not TOCKI 
	OPTION				; and WDT prescaler 1:1 => time out # 18 ms (min.=7ms)

	CLRF	meas10bH
	CLRF	meas10bL
	MOVLW	.16
	MOVWF	cnt3
pick1meas
	CALL	ledmeas
	MOVF	meas, W
	ADDWF	meas10bL, F	; meas10bL += meas
	BTFSC	STATUS, C	; result <= 255 ?
	INCF	meas10bH, F	; no. then add CARRY to meas10bH
	DECFSZ	cnt3, F
	GOTO	pick1meas

;decimation
	BCF		STATUS, C
	RRF		meas10bH, F
	RRF		meas10bL, F
	BCF		STATUS, C
	RRF		meas10bH, F
	RRF		meas10bL, F

;firstime calibration (bnFlags=0)
	SIregNOTNUL	bnFlags, calibration ; if (bnFlags <> 0) goto calibration
	MOVF	meas10bH, W
	MOVWF	calibH
	MOVF	btnCalib, W
	ADDWF	meas10bL, W		; W = meas10bL + btnCalib
	MOVWF	calibL			; calibL = W
	BTFSC	STATUS, C		; result <= 255 ?
	INCF	calibH, F		; no. then add CARRY to calibH
	MOVLW	.1
	MOVWF	bnFlags

calibration ; degree C = (calibH,calibL) - (10bit measure)

;Sub16
	CLRF	resH		; resH = 0
	MOVF	meas10bL, w	; w = meas10bL
	SUBWF	calibL, w	; w = calibL - (w=meas10bL)
	MOVWF	resL		; resL = w
	BTFSS	STATUS, C	; result >= 0 ?
	INCF	meas10bH, F	; no. then add CARRY to meas10bH

	MOVF	meas10bH, w	; w = meas10bH
	SUBWF	calibH, w	; w = calibH - (w=meas10bH)
	MOVWF	resH		; resH = w

;conv.8bit to decimal
	MOVF	resL, W
	MOVWF	tmp1
	CLRF	tmp2
	CALL	SP_DIGBYTE

displayU ; display now units: 25ms blink "units" times
	MOVF	units, w
	BTFSC	STATUS, Z
	GOTO	displayT
	CALL	LEDuON
	CALL	LEDoff
	DECFSZ	units, F
	GOTO	displayU

displayT ; display now tens: 256ms blink "tens" times
	CALL	Delay256ms

	MOVF	tens, w
	BTFSC	STATUS, Z
	GOTO	deadtime
	CALL	LEDtON
	CALL	LEDoff
	DECFSZ	tens, F
	GOTO	displayT

deadtime
;after CLRWDT, prescaler is cleared ; so reconfig. OPTION for WDT 1:128
	MOVLW  b'00001111'	; Enable wake-up and pull-up, <5>=0:use GP2, not TOCKI 
	OPTION				; and WDT prescaler 1:128 => time out # 2.3 s
	CALL	LEDoff
;veilleuse
	Sleep				; sleep clears WDT

	END
