//Misc utilities functions used in main
#include "util.h"
#include "bitmaps.h"

void putDigits(char n, char p, char r, char g, char b){ //put number n at position p
    putDigit(digits[n>>4],p,r,g,b);
    putDigit(digits[n&0xF],p+32,r,g,b);
}

void putDigit(unsigned int d, char p, char r, char g, char b){  //put bitmap d at p
    char i;
    for(i=0;i<15;i++){
        if(d&1){
            RGBdata[p+bitOffsets[i]][0]=r;
            RGBdata[p+bitOffsets[i]][1]=g;
            RGBdata[p+bitOffsets[i]][2]=b;        
        }
        d=d>>1;     //next bit
    }
}

void dumpLEDtoUSB(void){        //print the LED pattern to serial
    signed char m,n;
    for(n=7;n>=0;n--){
        for(m=0;m<64;m=m+8){
            if((RGBdata[m+n][0])||(RGBdata[m+n][1])||(RGBdata[m+n][2])){
                tx(letterMap[m+n]);
            }else{
                tx('-');
            }
        }
        tx('\r');
        tx('\n');
    }
    tx('0'+(toBCD(hours)>>4));
    tx('0'+(toBCD(hours)&0xF));
    tx(':');
    tx('0'+(toBCD(minutes)>>4));
    tx('0'+(toBCD(minutes)&0xF));
    tx(':');
    tx('0'+(toBCD(seconds)>>4));
    tx('0'+(toBCD(seconds)&0xF));
    tx('\r');
    tx('\n');
    tx('\r');
    tx('\n');
}

void tx(char s){                            //add to output buffer
    txbuf[txptr++]=s;                       //add data to outgoing
    if(txptr>BUFSIZE-2){txptr=BUFSIZE-2;}   //clip buffer                  
}

void txA(char* a){                          //add array
    while(*a){tx(*a++);}
}
/*
//about 12 words shorter, but not tested
 * char fromHex(char h){   //value of hex digit
    char i=0;
    while((toHex[i]!=h)&&(i<16)){
        i++;
    }
    return i;
}
*/

char fromHex(char h){   //value of hex digit
    if((h>='0')&&(h<='9')){return h-'0';}
    if((h>='a')&&(h<='f')){return h+10-'a';}
    if((h>='A')&&(h<='F')){return h+10-'A';}
    return 0;    //backup
}

void showMenu(){
    txA("\r\nSilicon Chip Ol' Timer II\r\n1:Time\r\n2:Minutes Colour\r\n3:Hours Colour\r\n4:AM/PM Colour\r\n5:SAVE\r\n+/- and </> for brightness\r\n");
    //txA("\r\nM\r\n");     //short message if we need to crib space for testing
}

void setTime(){
    //hours=fromHex(sBuf[0])*10+fromHex(sBuf[1]); 
    //minutes=fromHex(sBuf[2])*10+fromHex(sBuf[3]); 
    //seconds=fromHex(sBuf[4])*10+fromHex(sBuf[5]); 
    //optimised, untested, saves 19 words
    hours=sBuf[0]*10+sBuf[1]+240;       //magic number 240 ~ -528 mod 256, ie 10*'0'+'0'
    minutes=sBuf[2]*10+sBuf[3]+240;       //magic number 240 ~ -528 mod 256, ie 10*'0'+'0'
    seconds=sBuf[4]*10+sBuf[5]+240;       //magic number 240 ~ -528 mod 256, ie 10*'0'+'0'
    /*
    if(seconds>59){seconds=59;}
    if(minutes>59){minutes=59;}
    if(hours>23){hours=23;}
    */
    validateTimes();
}

void validateTimes(void){               //for display/writing to RTC, shared function saves 9 words
    if(seconds>59){
        seconds=seconds-60;
        minutes++;
        if(minutes>59){
            minutes=minutes-60;
            hours++;
            if(hours>23){hours=hours-24;}
        }
    }    
}

// this saves 78 words over specific cases below
void setColour(char* index, char* source){  //extract data from entered string
    //    general case of:
    //    mColour[1]=fromHex(sBuf[0])*16+fromHex(sBuf[1]);     //red
    index[0]=fromHex(source[0])*16+fromHex(source[1]);
}

void setMC(){
    setColour(&mColour[1],&sBuf[0]);
    setColour(&mColour[0],&sBuf[2]);
    setColour(&mColour[2],&sBuf[4]);
    //mColour[1]=fromHex(sBuf[0])*16+fromHex(sBuf[1]);     //red
    //mColour[0]=fromHex(sBuf[2])*16+fromHex(sBuf[3]);     //green
    //mColour[2]=fromHex(sBuf[4])*16+fromHex(sBuf[5]);     //blue
}

void setHC(){
    setColour(&hColour[1],&sBuf[0]);
    setColour(&hColour[0],&sBuf[2]);
    setColour(&hColour[2],&sBuf[4]);
    //hColour[1]=fromHex(sBuf[0])*16+fromHex(sBuf[1]);     //red
    //hColour[0]=fromHex(sBuf[2])*16+fromHex(sBuf[3]);     //green
    //hColour[2]=fromHex(sBuf[4])*16+fromHex(sBuf[5]);     //blue    
}

void setOC(){
    setColour(&oColour[1],&sBuf[0]);
    setColour(&oColour[0],&sBuf[2]);
    setColour(&oColour[2],&sBuf[4]);
    //oColour[1]=fromHex(sBuf[0])*16+fromHex(sBuf[1]);     //red
    //oColour[0]=fromHex(sBuf[2])*16+fromHex(sBuf[3]);     //green
    //oColour[2]=fromHex(sBuf[4])*16+fromHex(sBuf[5]);     //blue    
}

void setMap(char index, unsigned char r, unsigned char g, unsigned char b){    //apply rgb to bitmap at index (assumes blank)
    char i;
    for(i=0;i<64;i++){
        //index is 3 LSB, bit is next 3 bits
        if(bitmaps[index][7-(i&7)]&bits[(i&56)>>3]){                //if bit set, change colour
            RGBdata[i][0]=((unsigned int)r*brightness)/256;
            RGBdata[i][1]=((unsigned int)g*brightness)/256;
            RGBdata[i][2]=((unsigned int)b*brightness)/256;
        }
    }
}

void loadSettings(void){
    char i;
    readflash(255);     //load from flash
    if(flashshadow[0]==0xAA){    //settings are valid
//        for(i=0;i<3;i++){
//            hColour[i]=flashshadow[1+i];
//            mColour[i]=flashshadow[4+i];
//            oColour[i]=flashshadow[7+i];            
//        }
        hColour[0]=flashshadow[1];
        hColour[1]=flashshadow[2];
        hColour[2]=flashshadow[3];
        mColour[0]=flashshadow[4];
        mColour[1]=flashshadow[5];
        mColour[2]=flashshadow[6];
        oColour[0]=flashshadow[7];
        oColour[1]=flashshadow[8];
        oColour[2]=flashshadow[9];
        brightnessL=flashshadow[10];
        brightnessH=flashshadow[11];
    }    
}

void saveSettings(void){
    //setMap(18,SETTINGS_GREEN,0,0);    //green save icon
    flashshadow[0]=0xAA;    //settings are valid
    flashshadow[1]=hColour[0];
    flashshadow[2]=hColour[1];
    flashshadow[3]=hColour[2];
    flashshadow[4]=mColour[0];
    flashshadow[5]=mColour[1];
    flashshadow[6]=mColour[2];
    flashshadow[7]=oColour[0];
    flashshadow[8]=oColour[1];
    flashshadow[9]=oColour[2];
    flashshadow[10]=brightnessL;
    flashshadow[11]=brightnessH;
    eraseflash(255);
    writeflash(255);        
}
