#ifndef UTIL_H
#define	UTIL_H
//Misc utilities functions used in main

#include <xc.h> // include processor files - each processor file is guarded.  
//BCD functions
#include "rtc.h"
#include "flash.h"

//see also main.c
#define BUFSIZE 160

extern char txbuf[BUFSIZE];
extern char rxbuf[BUFSIZE];
extern int txptr;
extern int rxptr;
//extern char txptr;
//extern char rxptr;
extern char sBuf[7];                        //current settings command string
extern char sPtr;
extern volatile char sCtr;                  //seconds counter for backup timing

extern volatile unsigned char RGBdata[64][3];       //laid out for easy linear access as needed, colour order is GRB
extern unsigned char hColour[3];
extern unsigned char mColour[3];
extern unsigned char oColour[3];

extern char hours;
extern char minutes;
extern char seconds;
extern unsigned char brightness;        //reference interpolated value here
extern unsigned char brightnessL;       //for saving to flash
extern unsigned char brightnessH;

//buffer for writing/reading flash
extern unsigned char flashshadow[FLASHPAGESIZE];
//use the following
//flashshadow[0]    check value =0xAA means valid data
//flashshadow[1-3]    hColour
//flashshadow[4-6]    mColour
//flashshadow[7-9]    mColour
//flashshadow[10,11]      brightnessL,H

//used by bitmap routine
const char bits[8]={1,2,4,8,16,32,64,128};
const char toHex[]="0123456789ABCDEF";
const unsigned int digits[]={
    32319,//0
    1000,//1
    9907,//2
    10933,//3
    32334,//4
    24253,//5
    24255,//6
    29296,//7
    32447,//8    
    31421,//9
    15951,//A
    10943,//B
    17966,//C
    14911,//D
    22207,//E
    21151//F
    ,31903,//H (16)
    18417,//I (17)
    1087//L (18)
};

const char bitOffsets[]={0,1,2,3,4,8,9,10,11,12,16,17,18,19,20};

void putDigits(char n, char p, char r, char g, char b);             //put number n at position p with rgb
void putDigit(unsigned int d, char p, char r, char g, char b);      //put bitmap d at p with (rgb))
void dumpLEDtoUSB(void);                    //print the LED pattern to serial
void tx(char s);                            //add to output buffer
void txA(char* a);                          //add array
char fromHex(char h);                       //value of hex digit
void showMenu(void);
void setTime();
void validateTimes(void);                  //for display/writing to RTC
void setColour(char* index, char* source);  //extract data from entered string
void setMC();
void setHC();
void setOC();
void setMap(char index, unsigned char r, unsigned char g, unsigned char b);    //apply rgb to bitmap at index (assumes blank)
void loadSettings(void);
void saveSettings(void);

#endif	/* UTIL_H */

