//TIM BLYTHMAN 7/2/20
//Routines for WS2812
//written to use port RC5

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "util.h"

#define ADC1 (3)
#define ADC2 (4)
#define ADC3 (5)
#define ADC4 (7)
#define ADC5 (6)
#define ADCRA4 (3)

extern volatile unsigned char RGBdata[64][3];       //laid out for easy linear access as needed
//__near volatile unsigned char RGBptr;               //used by assembler to count bits output
volatile unsigned char RGBptr @ 0x7D;                   //this syntax for XC v1.45

void ioinit(void);
int getADC(char channel);
void sendLEDdata(void);

//I2C pins:
#define BREADBOARD 1
#define PCB_REVA 2
#define PCB_REVB 3

#define PCBREVISION PCB_REVB

#if PCBREVISION == 1
//Breadboard Prototype, SDA on C2, SCL on C3
#define SDAHI {TRISCbits.TRISC2=1;}
#define SDALO {TRISCbits.TRISC2=0;LATCbits.LATC2=0;}
#define SCLHI {TRISCbits.TRISC3=1;NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();}
#define SCLLO {TRISCbits.TRISC3=0;LATCbits.LATC3=0;NOP();NOP();NOP();NOP();NOP();}
#define I2C_READ_PORT PORTCbits.RC2
#elif PCBREVISION == 2
//REVA PCB, SDA on C1, SCL on C0 (ICSP pins)
#define SDAHI {TRISCbits.TRISC1=1;}
#define SDALO {TRISCbits.TRISC1=0;LATCbits.LATC1=0;}
#define SCLHI {TRISCbits.TRISC0=1;NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();}
#define SCLLO {TRISCbits.TRISC0=0;LATCbits.LATC0=0;NOP();NOP();NOP();NOP();NOP();}
#define I2C_READ_PORT PORTCbits.RC1
#elif PCBREVISION == 3
//REVB PCB, SDA on C3, SCL on C4
#define SDAHI {TRISCbits.TRISC3=1;NOP();NOP();NOP();NOP();}
#define SDALO {TRISCbits.TRISC3=0;LATCbits.LATC3=0;NOP();NOP();NOP();NOP();}
#define SCLHI {TRISCbits.TRISC4=1;NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();NOP();}
#define SCLLO {TRISCbits.TRISC4=0;LATCbits.LATC4=0;NOP();NOP();NOP();NOP();NOP();}
#define I2C_READ_PORT PORTCbits.RC3
#else
#endif

unsigned char I2Cbit(unsigned char n);  //send one bit, return bit
int I2Cbyte(int n);                     //send byte,return read byte + ACK, needs to return int (9bits)
void I2Cstart();                        //send start condition
void I2Cstop();                         //send stop condition
int getTouch(char c);                   //get touch on ANc, forward logic, pin set to 5V, ref is +

#endif	/* IO_H */

