//TIM BLYTHMAN 7/2/20
//Routines for WS2812
//written to use port RC5

#include "io.h"

void ioinit(void){
    //analog pins are these only: RA4=AN3
    ANSELA=0;
    ANSELC=0;
    ANSA4=1;
    //LDR is top half of divider, ie high ADC=> bright conditions
    //ADCON1=0b11010000;      //11010000 =  Right justified, FOSC/16, VREF is VDD
    ADCON1=0b11110000;      //11010000 =  Right justified, FRC, VREF is VDD
    ADCON0=0b00000001;      //ADC on, no conversion yet
    //pin for LED control
    RC5=0;
    TRISC5=0;
    //pins for I2C are floating idle, setup not needed
}

int getADC(char channel){           //get ADC result from channel
    ADCON0=(channel<<2)|1;          //set channel, ADC on
    ADCON0bits.ADGO=1;              //start
    while(ADCON0bits.ADGO){}        //wait till done
    return ((ADRESH&3)<<8)|(ADRESL);//10 bit result
}

void sendLEDdata(void){             //send WS2812 data, 64 LEDs=1536 bits
    //mix of C and assembly
    //use FSR1 to step through array
    //RGBptr counts when we've sent all bytes
    //each ASM loop sends one byte (~120 words of program memory)
    //if space is available, could expand to do an entire 24-bit RGB word
    //output is fixed to RC5
    //timing is 5 cycles high, 10 cycles low for 0, 10 cycles high, 5 cycles low for 1, 12MHz instruction clock => 15 instruction = 1.25us
    //reset pulse is not enforced, software must provide delay
    unsigned int fsr;       //to store FSR that compiler may be using
    di();                   //disable interrupts
    fsr = FSR1;             //save
    FSR1=(unsigned int)&RGBdata[0][0];      //set to start of array
    RGBptr=192;             //RGBptr is set as __near to allow it to be used without worrying about banks
asm("INNERLOOP:");
//bit 7
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x7");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 6
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x6");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 5
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x5");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 4
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x4");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 3
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x3");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 2
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x2");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 1
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x1");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("NOP");
asm("NOP");
asm("NOP");
//bit 0 and increment counter/pointer
asm("BSF PORTC, 0x5");      //output high
asm("NOP");
asm("NOP");
asm("NOP");
asm("BTFSS INDF1, 0x0");    //skip next if 1
asm("BCF PORTC, 0x5");      //output low if 0
asm("MOVLW 0x1");           //increment pointer (use ADDFSR for single opcode instead?)
asm("ADDWF FSR1L, F");      //low byte
asm("MOVLW 0x0");
asm("ADDWFC FSR1H, F");     //high byte with carry
asm("BCF PORTC, 0x5");      //output low if 1
asm("NOP");
asm("DECFSZ _RGBptr");      //count bits and test
asm("GOTO INNERLOOP;");     //loop
    FSR1=fsr;               //restore
    ei();                   //enable interrupts
}

unsigned char I2Cbit(unsigned char n){  //send one bit, return bit
    char b=0;
    if(n!=0){               //set SDA
        SDAHI
    }else{
        SDALO
    }
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    NOP();
    SCLHI                   //toggle clock
    NOP();
    NOP();
    b=I2C_READ_PORT;        //read bit
    SCLLO                   //end of bit
    return b;
}

int I2Cbyte(int n){     //send byte,return read byte + ACK, needs to return int (9bits)
    int b=0;
    //19 words of program space smaller
    if(I2Cbit(n&128)){b=128;}
    if(I2Cbit(n&64)){b=b|64;}
    if(I2Cbit(n&32)){b=b|32;}
    if(I2Cbit(n&16)){b=b|16;}
    if(I2Cbit(n&8)){b=b|8;}
    if(I2Cbit(n&4)){b=b|4;}
    if(I2Cbit(n&2)){b=b|2;}
    if(I2Cbit(n&1)){b=b|1;}
    if(n&0x100){        //set bit 8 to enable master ack
        if(I2Cbit(0)){b=b|0x100;}       //set bit 8 depending on ACK, should be low here!       
    }else{
        if(I2Cbit(1)){b=b|0x100;}       //set bit 8 depending on ACK
    }
    /*
    tx('B');
    tx(toHex[((b>>8)&0xF)]);    
    tx(toHex[((b>>4)&0xF)]);    
    tx(toHex[((b>>0)&0xF)]);    
    tx('\r');
    tx('\n');
    */
    return b;
}

void I2Cstart(){                 //send start condition
    SDAHI          //allow repeated start
    NOP();
    SDALO
    NOP();
    NOP();
    NOP();
    NOP();
    SCLLO
}

void I2Cstop(){                  //send stop condition
    SDALO
    NOP();
    SCLHI
    NOP();
    NOP();
    NOP();
    NOP();
    SDAHI
}

int getTouch(char c){   //get touch on ANc, forward logic, pin set to 5V, ref is +
//      RA4	AN3
//      RC0	AN4
//      RC1	AN5
//      RC2	AN6
//      RC3	AN7
    //comment out unused channels to save program space
    int temp;
    switch(c){
        case 3: ANSA4=0; RA4=1; TRISA4=0;TRISA4=1;break;       //brief pulse in lieu of weak pullup
        case 4: ANSC0=0; RC0=1; TRISC0=0;TRISC0=1;break;       //brief pulse in lieu of weak pullup
        case 5: ANSC1=0; RC1=1; TRISC1=0;TRISC1=1;break;       //brief pulse in lieu of weak pullup
        case 6: ANSC2=0; RC2=1; TRISC2=0;TRISC2=1;break;       //brief pulse in lieu of weak pullup
        case 7: ANSC3=0; RC3=1; TRISC3=0;TRISC3=1;break;       //brief pulse in lieu of weak pullup
    }
    getADC(0x1E);
    switch(c){
        case 3: ANSA4=1;break;                         //connect to ADC
        case 4: ANSC0=1;break;                         //connect to ADC
        case 5: ANSC1=1;break;                         //connect to ADC
        case 6: ANSC2=1;break;                         //connect to ADC
        case 7: ANSC3=1;break;                         //connect to ADC
    }
    temp=getADC(c);
    return temp;
    
}
