
#ifndef BITMAPS_H
#define	BITMAPS_H

#include <xc.h> // include processor files - each processor file is guarded.  
/*
 //mapping: each digit is a row, LSB at left, MSB at right. Scan order is all LSBs... all MSBs
HALFPAST
QUARTERO
TIMEIGHT
HSIXFOUR
RTENINEO
ELSEVENL
ETWOELVE
OCLOCKap
*/

const unsigned char letterMap[]="OEERHTQHCTLTSIUALWSEIMALOOENXERFCEVIFITPKLENOGEAAVNEUHRSPELORTOT"; //in LED order
//const unsigned char letterMap[]="O";    //short version for testing

//modify format (can get down to 2 bytes per display, some displays need 2 entries)
const unsigned char bitmaps[][8]={
{0,0,0,32,32,32,0,0},  //ONE        //index 0
{0,0,0,0,0,0,14,0},  //TWO
{0,0,1,1,1,1,1,0},  //THREE
{0,0,0,240,0,0,0,0},  //FOUR
{0,0,0,16,16,16,16,0},  //FIVE
{0,0,0,14,0,0,0,0},  //SIX
{0,0,0,0,0,124,0,0},  //SEVEN
{0,0,248,0,0,0,0,0},  //EIGHT
{0,0,0,0,120,0,0,0},  //NINE
{0,0,0,0,14,0,0,0},  //TEN
{0,0,0,0,0,123,0,0},  //ELEVEN
{0,0,0,0,0,0,246,0},  //TWELVE      //index 11

{0,0,0,0,0,0,0,64},  //AM           //index 12
{0,0,0,0,0,0,0,128},  //PM          //index 13

{255,0,0,0,0,0,0,0},  //HALFPAST        //index 14
{240,127,0,0,0,0,0,0},  //PASTQUARTER
{128,255,0,0,0,0,0,0},  //QUARTERTO
{0,0,0,0,0,0,0,63}  //OCLOCK           //index 17
,{127,129,189,141,177,189,129,255}  //(save icon, index 18) 
}; 
 
#endif	/* BITMAPS_H */

