//RTC routines to access DS3231

#include "rtc.h"
#include "util.h"

char getRTC(void){     //get time from RTC, returns true on success, false on fail
    char sByte,mByte,hByte;     //DS3231 uses BCD format
    int temp;
    char nack=0;                 //count nacks on bits
    I2Cstart();
    temp=I2Cbyte(DS3231_ADDRESS << 1);
    /*
    tx('A');
    tx(toHex[(temp>>4)&0xF]);
    tx(toHex[(temp>>0)&0xF]);
    tx('\r');
    tx('\n');
    tx('\r');
    tx('\n');
    */
    if((temp&0xFF)!=(DS3231_ADDRESS << 1)){nack=nack|64;}   //address mismatch => something else is on the bus (programmer?)
    if(temp&0x100){nack=nack|1;}    //write
    if(I2Cbyte(0)&0x100){nack=nack|2;}                      //register 0
    I2Cstop();                                         //does not like repeated start     
    I2Cstart();                                       //re start
    if(I2Cbyte((DS3231_ADDRESS << 1)|1)&0x100){nack=nack|4;}//read
    temp=I2Cbyte(0x1FF);                               //read from slave
    if(temp&0x80){nack=nack|8;}                            //no ack on this bit, but data should not have MSB set
    sByte=temp;                                       //store
    temp=I2Cbyte(0x1FF);                               //read from slave
    if(temp&0x80){nack=nack|32;}                            //no ack on this bit, but data should not have MSB set
    mByte=temp;                                       //store
    temp=I2Cbyte(0xFF);                               //read from slave
    if(temp&0x80){nack=nack|128;}                            //no ack on this bit, but data should not have MSB set
    hByte=temp;                                       //store
    I2Cstop();
    /*
    tx('R');
    tx(toHex[nack>>4]);
    tx(toHex[nack&0xF]);    
    tx('\r');
    tx('\n');
    tx('\r');
    tx('\n');
    */
    if(debug){if(nack){txA("RTC fail\r\n");}else{txA("RTC OK\r\n");}}
    if(nack){return 0;}                               //failed, abort, don't change time variables
    seconds=fromBCD(sByte);                           //convert from BCD
    minutes=fromBCD(mByte);                           //convert from BCD
    if(hByte&0x40){     //12 hour mode
        hours=fromBCD(hByte&0x1F);
        if(hByte&0x20){hours=hours+12;}     //PM bit set
    }else{              //24 hour mode
        hours=fromBCD(hByte&0x3F);
    }
    return 1;
}

char setRTC(void){     //set time on RTC, returns true on success, false on fail
    char sByte,mByte,hByte;     //DS3231 uses BCD format
    char nack=0;                 //count nacks on bits
    sByte=toBCD(seconds);
    mByte=toBCD(minutes);
    hByte=toBCD(hours)&0x3F;    //use 24 hour mode to set
    I2Cstart();
    if(I2Cbyte(DS3231_ADDRESS << 1)&0x100){nack=nack|1;}    //write
    if(I2Cbyte(0)&0x100){nack=nack|2;}                      //write to register 0
    if(I2Cbyte(sByte)&0x100){nack=nack|4;}                  //register 0
    if(I2Cbyte(mByte)&0x100){nack=nack|8;}                  //register 1
    if(I2Cbyte(hByte)&0x100){nack=nack|16;}                  //register 2
    I2Cstop();
    /*
    tx('W');
    tx(toHex[nack>>4]);
    tx(toHex[nack&0xF]);    
    tx('\r');
    tx('\n');
    */
    if(nack){return 0;}else{return 1;}
}

char toBCD(char n){
    char b=0;
    while(n>9){
        n=n-10;
        b=b+16;
    }
    return b+n;    
}

char fromBCD(char n){
    char b=0;
    while(n>15){
        n=n-16;
        b=b+10;
    }
    return b+n;    
}
