#define CHARGE_PIN (A0)
#define ADC_REF (5.0)
#define CHARGE_LIMIT (1.6)

void setup() {
  Serial.begin(115200);
  pinMode(LED_BUILTIN, OUTPUT); //use inbuilt LED
  digitalWrite(LED_BUILTIN, LOW);
}

void loop() {
  float v;
  v=analogRead(CHARGE_PIN)*ADC_REF/1024;    //assuming 10bit ADC
  Serial.print(v);
  Serial.println(" V");
  if(v>CHARGE_LIMIT){
    digitalWrite(LED_BUILTIN, LOW);   //charge done
    delay(100);
  }else{
    digitalWrite(LED_BUILTIN, HIGH);   //charging needed
    digitalWrite(CHARGE_PIN,HIGH);
    pinMode(CHARGE_PIN,OUTPUT);
    delay(100);
    pinMode(CHARGE_PIN,INPUT);
    delay(10);                          //let battery settle before reading again
  }
}
