//general utilities and settings framework

#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "font.h"
#include "entropy.h"
#include "graphics.h"
#include "uart.h"
//strlen
//#include <string.h>

#define ALLOW_OLED_X_SETTING

#define EE_PAIRS 10
#define UP_BUTTON 3
#define DOWN_BUTTON 6
#define LEFT_BUTTON 4
#define RIGHT_BUTTON 5
#define BACK_BUTTON 1
#define OK_BUTTON 2
#define SHAKE_BUTTON 7
#define TEXT_OFFSET 9
#define T0_FREQ 4

#define TIMEOUT_MIN 5
#define TIMEOUT_MAX 240
#define TIMEOUT_STEP 5

#define BRIGHTNESS_MIN 30
#define BRIGHTNESS_MAX 200
#define BRIGHTNESS_STEP 10
#define OLED_DIM_TIME 2
#define OLED_DIM_LEVEL BRIGHTNESS_MIN

#define REPEAT_DELAY 200
#define REPEAT_INTERVAL 75

#define L_NUM_X (2)
#define L_PIPS_X (4)
#define L_CARD_X (2)
#define L_COIN_X (4)
#define R_NUM_X (L_NUM_X+64)
#define R_PIPS_X (L_PIPS_X+64)
#define R_CARD_X (L_CARD_X+64)
#define R_COIN_X (L_COIN_X+64)
#define C_NUM_X (L_NUM_X+32)
#define C_PIPS_X (L_PIPS_X+32)
#define C_CARD_X (L_CARD_X+32)
#define C_COIN_X (L_COIN_X+32)

//1:256 doze with ROI
#define CPU_DOZE_ROI (0x67)
//normal
#define CPU_DOZE_OFF (0x00)

#define VCC_MIN (2600)

//OSCCON presets
#define CLOCK_LFINTOSC 0x50
#define CLOCK_HFINTOSC 0x60
//OSCFRQ presets
#define HFOSC_FRQ_32 5
#define HFOSC_FRQ_16 4

typedef struct {        //this is 8 bytes in EEPROM
    rollDisplay_t lhs;
    rollDisplay_t rhs;
} displayPair_t;

typedef enum {
    SETTINGS_START=-1,
    SETTINGS_OFF=0,
    SETTINGS_TIMEOUT=1,
    SETTINGS_BRIGHTNESS,
#ifdef ALLOW_OLED_X_SETTING
    SETTINGS_OLEDX,
#endif //ALLOW_OLED_X_SETTING
    SETTINGS_SHAKE_WAKE,
    SETTINGS_MEMTEST,
    SETTINGS_USEMEM,
    SETTINGS_DUMMY,  //end of main settings
    SETTINGS_LAST=SETTINGS_DUMMY+EE_PAIRS //end of other settings
} settings_t;

extern unsigned int vcc;
extern unsigned char n;
extern unsigned int tmOut;
extern const char* s;
extern char newIndex;    //flag that dice have changed
extern char udFlag;      //display update needed
extern displayPair_t current;
extern settings_t settingsMode;
extern char lhsResult,rhsResult,rollFromSleep,OLEDisDim;

extern __eeprom displayPair_t eePairs[EE_PAIRS];
extern __eeprom unsigned char timeOut;
extern __eeprom unsigned char oledBrightness;
extern __eeprom unsigned char useMEM;    //use MEM hardware
extern __eeprom char currentIndex; //rollTemplates up to TEMPLATE_COUNT then eePairs up to EE_PAIRS
extern __eeprom char shakeToWake; //allow vibration switch to wake up from sleep
extern __eeprom unsigned long lfsrEEPROM;

void drawBorderCurrent(void);
char buttonHoldRepeat(void);    //monitor button for hold and report repeats as needed
char checkButton(char n);
char buttonState(char n);
void timerReset(void);
void settingsTitle(void);
void runMEMtest(void);  //runs test and displays results
void showDtest(void);
void setRoll(char n);     //configure roll eePairs[n]
void checkMinMax(char n);       //validate min/max roll
char getSelectedRoll(char n);   //use getRoll/getRollLFSR depending on useMEM
char getSelectedBit(void); //use entropy/LFSR depending on useMEM
void startUp(void);  //used at boot and also restart from sleep
void lowPowerWait(void);    //doze while waiting for things to happen
void shutDown(void);    //before sleep
void loadRoll(void);    //load current from EEPROM/templates
void sleepAndWakeup(void);  //set up wake source, sleep, recover

#endif	/* UTIL_H */

