#ifndef UART_H
#define	UART_H

#include <xc.h> 
#include "portbits.h"

//configurable as needed
//#define UART_RX_ENABLE
#define UART_TX_ENABLE

#define UART_TX_PIN a1
#define UART_RX_PIN a0

//assume main oscillator at _XTAL_FREQ

#define BRG_9600 (_XTAL_FREQ/4/9600)
#define BRG_38400 (_XTAL_FREQ/4/38400)
#define BRG_115200 (_XTAL_FREQ/4/115200)

#define BUFSIZE 256

#ifdef UART_RX_ENABLE
char rxbuf[BUFSIZE]="";
volatile unsigned char rx_head,rx_tail;
unsigned char uartAvailable(void);   //bytes to receive in rxbuf
char uartReceive(void);     //take from rxbuf
#endif //UART_RX_ENABLE

#ifdef UART_TX_ENABLE
char txbuf[BUFSIZE]="";
volatile unsigned char tx_head,tx_tail;
void uartSend(char c);      //add to txbuf
void uartSends(char* c);    //char array
#endif //UART_TX_ENABLE

void uartDeInit(void);          //off
void uartInit(unsigned int b);  //b=baud rate constant
void uartISR(void);            //call from main ISR

#endif	/* UART_H */

