#ifndef PORTBITS_H
#define	PORTBITS_H
/*
 * Generic unified port access structs for PIC16F1xxxx
 * #define checks ensure only actual port members are defined
 * can use port (a0..e3) defines for access to all port control structs
 * portbits.
 * trisbits.
 * latbits.
 * anselbits.
 * wpubits.
 * odconbits.
 * slrconbits.
 * inlvlbits.
 * pps. 
 * iocxp/iocxn/iocxf.
 * 
 * 
 * ALSO:
 * analogChans_t enum; eg ADPCH=a0;
 * 
 * 
 *  * Compiles to same BCF/BSF opcode as standard port names
 */

#include <xc.h> // include processor files - each processor file is guarded.  
//should work for most 16F1xxxx parts
//tested on PIC16F18146, PIC16F18045

typedef struct {
        unsigned int 
#ifdef _PORTA_RA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _PORTA_RA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _PORTA_RA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _PORTA_RA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _PORTA_RA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _PORTA_RA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _PORTA_RA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _PORTA_RA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _PORTB_RB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _PORTB_RB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _PORTB_RB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _PORTB_RB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _PORTB_RB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _PORTB_RB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _PORTB_RB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _PORTB_RB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _PORTC_RC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _PORTC_RC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _PORTC_RC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _PORTC_RC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _PORTC_RC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _PORTC_RC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _PORTC_RC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _PORTC_RC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _PORTD_RD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _PORTD_RD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _PORTD_RD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _PORTD_RD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _PORTD_RD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _PORTD_RD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _PORTD_RD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _PORTD_RD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _PORTE_RE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _PORTE_RE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _PORTE_RE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _PORTE_RE3_SIZE
    e3
#endif
    :1;
} portbits_t;

extern volatile portbits_t portbits __at(0x00C);

typedef struct {
        unsigned int 
#ifdef _TRISA_TRISA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _TRISA_TRISA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _TRISB_TRISB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _TRISC_TRISC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _TRISD_TRISD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _TRISE_TRISE3_SIZE
    e3
#endif
    :1;
} trisbits_t;

extern volatile trisbits_t trisbits __at(0x012);

typedef struct {
        unsigned int 
#ifdef _LATA_LATA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _LATA_LATA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _LATA_LATA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _LATA_LATA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _LATA_LATA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _LATA_LATA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _LATA_LATA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _LATA_LATA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _LATB_LATB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _LATB_LATB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _LATB_LATB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _LATB_LATB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _LATB_LATB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _LATB_LATB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _LATB_LATB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _LATB_LATB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _LATC_LATC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _LATC_LATC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _LATC_LATC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _LATC_LATC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _LATC_LATC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _LATC_LATC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _LATC_LATC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _LATC_LATC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _LATD_LATD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _LATD_LATD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _LATD_LATD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _LATD_LATD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _LATD_LATD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _LATD_LATD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _LATD_LATD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _LATD_LATD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _LATE_LATE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _LATE_LATE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _LATE_LATE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _LATE_LATE3_SIZE
    e3
#endif
    :1;
} latbits_t;

extern volatile latbits_t latbits __at(0x018);

typedef struct {
    unsigned int
#ifdef _ANSELA_ANSELA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _ANSELA_ANSELA7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ANSELB_ANSELB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _ANSELB_ANSELB7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ANSELC_ANSELC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _ANSELC_ANSELC7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ANSELD_ANSELD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _ANSELD_ANSELD7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ANSELE_ANSELE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _ANSELE_ANSELE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _ANSELE_ANSELE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _ANSELE_ANSELE3_SIZE
    e3
#endif
    :1;
} anselbits_t;

extern volatile anselbits_t anselbits __at(0x1E8C);

typedef struct {
    unsigned int
#ifdef _WPUA_WPUA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _WPUA_WPUA7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _WPUB_WPUB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _WPUB_WPUB7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _WPUC_WPUC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _WPUC_WPUC7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _WPUD_WPUD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _WPUD_WPUD7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _WPUE_WPUE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _WPUE_WPUE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _WPUE_WPUE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _WPUE_WPUE3_SIZE
    e3
#endif
    :1;
} wpubits_t;

extern volatile wpubits_t wpubits __at(0x1E8D);

typedef struct {
    unsigned int
#ifdef _ODCONA_ODCA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _ODCONA_ODCA7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ODCONB_ODCB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _ODCONB_ODCB7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ODCONC_ODCC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _ODCONC_ODCC7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ODCOND_ODCD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _ODCOND_ODCD7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _ODCONE_ODCE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _ODCONE_ODCE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _ODCONE_ODCE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _ODCONE_ODCE3_SIZE
    e3
#endif
    :1;
} odconbits_t;

extern volatile odconbits_t odconbits __at(0x1E8E);

typedef struct {
    unsigned int
#ifdef _SLRCONA_SLRA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _SLRCONA_SLRA7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _SLRCONB_SLRB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _SLRCONB_SLRB7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _SLRCONC_SLRC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _SLRCONC_SLRC7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _SLRCOND_SLRD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _SLRCOND_SLRD7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _SLRCONE_SLRE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _SLRCONE_SLRE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _SLRCONE_SLRE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _SLRCONE_SLRE3_SIZE
    e3
#endif
    :1;
} slrconbits_t;

extern volatile slrconbits_t slrconbits __at(0x1E8F);

typedef struct {
    unsigned int
#ifdef _INLVLA_INLVLA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _INLVLA_INLVLA7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _INLVLB_INLVLB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _INLVLB_INLVLB7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _INLVLC_INLVLC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _INLVLC_INLVLC7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _INLVLD_INLVLD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _INLVLD_INLVLD7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _INLVLE_INLVLE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _INLVLE_INLVLE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _INLVLE_INLVLE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _INLVLE_INLVLE3_SIZE
    e3
#endif
    :1;
} inlvlbits_t;

extern volatile inlvlbits_t inlvlbits __at(0x1E90);

//IOCxP
typedef struct {
    unsigned int
#ifdef _IOCAP_IOCAP0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _IOCAP_IOCAP7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCBP_IOCBP0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _IOCBP_IOCBP7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCCP_IOCCP0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _IOCCP_IOCCP7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCDP_IOCDP0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _IOCDP_IOCDP7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCEP_IOCEP0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _IOCEP_IOCEP1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _IOCEP_IOCEP2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _IOCEP_IOCEP3_SIZE
    e3
#endif
    :1;
} iocxpbits_t;

extern volatile iocxpbits_t iocxpbits __at(0x1E91);

//IOCxN

typedef struct {
    unsigned int
#ifdef _IOCAN_IOCAN0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _IOCAN_IOCAN7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCBN_IOCBN0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _IOCBN_IOCBN7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCCN_IOCCN0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _IOCCN_IOCCN7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCDN_IOCDN0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _IOCDN_IOCDN7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCEN_IOCEN0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _IOCEN_IOCEN1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _IOCEN_IOCEN2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _IOCEN_IOCEN3_SIZE
    e3
#endif
    :1;
} iocxnbits_t;

extern volatile iocxnbits_t iocxnbits     __at(0x1E92);

//IOCxF
typedef struct {
    unsigned int
#ifdef _IOCAF_IOCAF0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _IOCAF_IOCAF7_SIZE
    a7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCBF_IOCBF0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _IOCBF_IOCBF7_SIZE
    b7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCCF_IOCCF0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _IOCCF_IOCCF7_SIZE
    c7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCDF_IOCDF0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _IOCDF_IOCDF7_SIZE
    d7
#endif
    :1; unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int
#ifdef _IOCEF_IOCEF0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _IOCEF_IOCEF1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _IOCEF_IOCEF2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _IOCEF_IOCEF3_SIZE
    e3
#endif
    :1;
} iocxfbits_t;

extern volatile iocxfbits_t iocxfbits __at(0x1E93);

//analog channels:
typedef enum {
#ifdef _ANSELA_ANSELA0_SIZE
    a0=0,
#endif
#ifdef _ANSELA_ANSELA1_SIZE
    a1=1,
#endif
#ifdef _ANSELA_ANSELA2_SIZE
    a2=2,
#endif
#ifdef _ANSELA_ANSELA3_SIZE
    a3=3,
#endif
#ifdef _ANSELA_ANSELA4_SIZE
    a4=4,
#endif
#ifdef _ANSELA_ANSELA5_SIZE
    a5=5,
#endif
#ifdef _ANSELA_ANSELA6_SIZE
    a6=6,
#endif
#ifdef _ANSELA_ANSELA7_SIZE
    a7=7,
#endif
#ifdef _ANSELB_ANSELB0_SIZE
    b0=8,
#endif
#ifdef _ANSELB_ANSELB1_SIZE
    b1=9,
#endif
#ifdef _ANSELB_ANSELB2_SIZE
    b2=10,
#endif
#ifdef _ANSELB_ANSELB3_SIZE
    b3=11,
#endif
#ifdef _ANSELB_ANSELB4_SIZE
    b4=12,
#endif
#ifdef _ANSELB_ANSELB5_SIZE
    b5=13,
#endif
#ifdef _ANSELB_ANSELB6_SIZE
    b6=14,
#endif
#ifdef _ANSELB_ANSELB7_SIZE
    b7=15,
#endif
#ifdef _ANSELC_ANSELC0_SIZE
    c0=16,
#endif
#ifdef _ANSELC_ANSELC1_SIZE
    c1=17,
#endif
#ifdef _ANSELC_ANSELC2_SIZE
    c2=18,
#endif
#ifdef _ANSELC_ANSELC3_SIZE
    c3=19,
#endif
#ifdef _ANSELC_ANSELC4_SIZE
    c4=20,
#endif
#ifdef _ANSELC_ANSELC5_SIZE
    c5=21,
#endif
#ifdef _ANSELC_ANSELC6_SIZE
    c6=22,
#endif
#ifdef _ANSELC_ANSELC7_SIZE
    c7=23,
#endif
#ifdef _ANSELD_ANSELD0_SIZE
    d0=24,
#endif
#ifdef _ANSELD_ANSELD1_SIZE
    d1=25,
#endif
#ifdef _ANSELD_ANSELD2_SIZE
    d2=26,
#endif
#ifdef _ANSELD_ANSELD3_SIZE
    d3=27,
#endif
#ifdef _ANSELD_ANSELD4_SIZE
    d4=28,
#endif
#ifdef _ANSELD_ANSELD5_SIZE
    d5=29,
#endif
#ifdef _ANSELD_ANSELD6_SIZE
    d6=30,
#endif
#ifdef _ANSELD_ANSELD7_SIZE
    d7=31,
#endif
#ifdef _ANSELE_ANSELE0_SIZE
    e0=32,
#endif
#ifdef _ANSELE_ANSELE1_SIZE
    e1=33,
#endif
#ifdef _ANSELE_ANSELE2_SIZE
    e2=34,
#endif
#ifdef _ANSELE_ANSELE3_SIZE
    e3=35,
#endif


} analogChans_t ; 



typedef struct {
    unsigned char
#ifdef RA0PPS
    a0
#endif
    :8; unsigned char
#ifdef RA1PPS
    a1
#endif
    :8; unsigned char
#ifdef RA2PPS
    a2
#endif
    :8; unsigned char
#ifdef RA3PPS
    a3
#endif
    :8; unsigned char
#ifdef RA4PPS
    a4
#endif
    :8; unsigned char
#ifdef RA5PPS
    a5
#endif
    :8; unsigned char
#ifdef RA6PPS
    a6
#endif
    :8; unsigned char
#ifdef RA7PPS
    a7
#endif
    :8; unsigned char
#ifdef RB0PPS
    b0
#endif
    :8; unsigned char
#ifdef RB1PPS
    b1
#endif
    :8; unsigned char
#ifdef RB2PPS
    b2
#endif
    :8; unsigned char
#ifdef RB3PPS
    b3
#endif
    :8; unsigned char
#ifdef RB4PPS
    b4
#endif
    :8; unsigned char
#ifdef RB5PPS
    b5
#endif
    :8; unsigned char
#ifdef RB6PPS
    b6
#endif
    :8; unsigned char
#ifdef RB7PPS
    b7
#endif
    :8; unsigned char
#ifdef RC0PPS
    c0
#endif
    :8; unsigned char
#ifdef RC1PPS
    c1
#endif
    :8; unsigned char
#ifdef RC2PPS
    c2
#endif
    :8; unsigned char
#ifdef RC3PPS
    c3
#endif
    :8; unsigned char
#ifdef RC4PPS
    c4
#endif
    :8; unsigned char
#ifdef RC5PPS
    c5
#endif
    :8; unsigned char
#ifdef RC6PPS
    c6
#endif
    :8; unsigned char
#ifdef RC7PPS
    c7
#endif
    :8; unsigned char
#ifdef RD0PPS
    d0
#endif
    :8; unsigned char
#ifdef RD1PPS
    d1
#endif
    :8; unsigned char
#ifdef RD2PPS
    d2
#endif
    :8; unsigned char
#ifdef RD3PPS
    d3
#endif
    :8; unsigned char
#ifdef RD4PPS
    d4
#endif
    :8; unsigned char
#ifdef RD5PPS
    d5
#endif
    :8; unsigned char
#ifdef RD6PPS
    d6
#endif
    :8; unsigned char
#ifdef RD7PPS
    d7
#endif
    :8; unsigned char
#ifdef RE0PPS
    e0
#endif
    :8; unsigned char
#ifdef RE1PPS
    e1
#endif
    :8; unsigned char
#ifdef RE2PPS
    e2
#endif
    :8; unsigned char
#ifdef RE3PPS
    e3
#endif
    :8;
} pps_t;

extern volatile pps_t pps __at(0x1D8C);

#endif	/* PORTBITS_H */

