#ifndef IO_H
#define	IO_H

/*pinouts:
 * s1=c7
 * s2=b7
 * s3=c2
 * s4=b4
 * s5=b5
 * s6=b6
 * s7=c1 (vibration sensor)
 * OLEDPWR=a4
 * SCL=a5
 * SDA=c0
 * RNDPWR=c5
 * PHI1=c4
 * PHI2=c3
 * RNDOUT=c6
 * C6_TEST=a2
 * not used:
 * PGC/a0
 * PGD/a1
*/

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"

#define FVRBUF1 0b111110 
#define PRESSED(x) (portbits.x==0)
extern unsigned int adcref,dacref;

#define S1 c7
#define S2 b7
#define S3 c2
#define S4 b4
#define S5 b5
#define S6 b6
#define S7 c1

//apply pullup to ensure not floating
#define UNUSED_A0 a0
#define UNUSED_A1 a1

//simple bitbanged UART
//this is S7 contacts
#define BB_UART_PIN c1
//PGD
//#define BB_UART_PIN a0
//PGC
//#define BB_UART_PIN a1
#define BB_BAUD 9600

void ioInit(void);
void sendBBstring(char* c);
void sendBBbyte(char d);
void t0init(void);
void initADC(void);
void deInitADC(void);
unsigned int getADC(char c);
unsigned int getVCC(void);  //in mV
unsigned int readNVM(unsigned int add);
unsigned int adjust(unsigned int v,unsigned int m);

#endif	/* IO_H */

