//interface and utils for modular entropy multiplier hardware

#ifndef ENTROPY_H
#define	ENTROPY_H

/*
 * RNDPWR=c5
 * PHI1=c4
 * PHI2=c3
 * RNDOUT=c6
 * C6_TEST=a2
 */

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "io.h"

#define RND_PWR c5
#define RND_PHI1 c4
#define RND_PHI2 c3
#define RND_OUT c6
#define RND_TEST a2
#define RND_ADC_PIN a0
#define RND_BOOT_CNT 8
#define ENT_LOWER 14
#define ENT_UPPER 18
#define LFSR_INIT (0x12345678UL)
#define RND_D_TEST 2
#define RND_TEST_CNT 100
//ROLL_RUNON repeats of ROLL_RUNDOWN ms
#define ROLL_RUNON 5
#define ROLL_RUNDOWN 40


extern char rnd_state;           //health of data
extern int twoD[RND_D_TEST][RND_D_TEST];
extern int oneD[RND_D_TEST];
extern unsigned int fairnessHealth;
extern unsigned int correlationHealth;
extern unsigned long lfsr_data32;   //extern to allow loading from EEPROM

void setRND(char s);    //turn on/off
unsigned long get24bits(void);
char getRNDbit(void);   //toggle state and get one bit
char getLFSRbit(void);
char getWhiteBit(void); //get whitened bit from 2 or more getRNDbit()s
void checkState(void);  //updates rnd_state
void getEntropy(void);  //run a few times to get to a usefully random state
char countSetBits(unsigned long n);     //for testing DC balance, implementing LFSR
unsigned long get24bitsLFSR(void);  //note that this only uses top 31 bits
void runDtest(void);
char getRoll(char n);   //return 1..n
char getRollLFSR(char n);   //return 1..n
unsigned int sqrt(unsigned long n); //integer

#endif	/* ENTROPY_H */

