//custom graphics/routines for FlexiDice

#ifndef GRAPHICS_H
#define	GRAPHICS_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "oled.h"
#include "font.h"
//for getRandPip
#include "entropy.h"

//all graphics are 56 pixels/7 pages high
#define NUMBER_WIDTH 56
#define NUMBER_BORDER 2
#define NUMBER_TOTAL (NUMBER_WIDTH+NUMBER_BORDER+NUMBER_BORDER)
#define PIPS_WIDTH 40
#define PIPS_BORDER 8
#define PIPS_TOTAL (PIPS_WIDTH+PIPS_BORDER+PIPS_BORDER)
//no border, full sized bitmap
#define COIN_WIDTH 56
#define WHITE 1
#define BLACK 0
#define TEMPLATE_COUNT 11

typedef enum {
    DISP_NUMBER=0,
    DISP_PIPS=1,    //ie dice
    DISP_CARD=2,    //playing card
    DISP_COIN=3,     //heads or tails
    DISP_NULL=4  //blank, not used
} graphicsDisplay_t;

typedef struct {        //this is 4 bytes in EEPROM
    graphicsDisplay_t disp;   
    unsigned char colour; //0 for black
    unsigned char roll;  //eg 2 for coin, 6 for d6
    unsigned char x;    //position on screen
} rollDisplay_t;

extern const char dispNames[][8];
extern const unsigned long pipPattern1[];
extern const unsigned long pipPattern2[];
extern const char normalDiceStyle[];  //white on black
extern const char revDiceStyle[];  //black on white
extern const char normalCardStyle[];  //white on black
extern const char revCardStyle[];  //black on white
extern const char coinFont[];
extern const rollDisplay_t emptyTemplate;
extern const rollDisplay_t rollTemplates[];
//extern const char templateNames[][8]; //generated by rollName() instead
extern const char rollMax[5],rollMin[5]; //align to graphicsDisplay_t enum

void drawPips(unsigned long b,unsigned char m);  //5x5 grid of 8x8, b contains bitmap, lsb at top left, m is xor mask
void drawBorder(char x, char y, char w, char h, const char* s);    //border measures s[0]x8, w,h refer to inside space in cols, pages, s is style
const unsigned long* getRandPip(void);      //choose pip style at random
void drawBorderGraphics(rollDisplay_t* r);
void drawGraphics(rollDisplay_t* r, unsigned char v); //v is roll/toss value
const char* rollName(rollDisplay_t r);   //return a char array with text describing r

#endif	/* GRAPHICS_H */

