#include <Wire.h>
#include <I2CLCD.h>

I2CLCD lcd;  //no address here, set in begin()

int show;

void setup()
{
  int LCDaddress;

  Serial.begin(115200);
  Serial.println("LCD...");

  while (! Serial);

  Serial.println("Check for LCD");
  LCDaddress=lcd.findAddress(0x20);   //start at 0x20, PCF8574* should be 0x20-0x3F
  Serial.print("lcd.findAddress() returns: ");
  Serial.println(LCDaddress);  
  Serial.print("HEX: 0x");
  Serial.println(LCDaddress,HEX);  

  if (LCDaddress!= 0) {
    Serial.println("LCD found.");
  } else {
    Serial.println("LCD not found.");
  } // if

  lcd.begin(LCDaddress,16, 2); // initialize the lcd at the found address
  show = 0;
} // setup()

void loop()
{
  if (show == 0) {
    lcd.setBacklight(255);
    lcd.home(); lcd.clear();
    lcd.print("Hello LCD");
    delay(1000);

    lcd.setBacklight(0);
    delay(400);
    lcd.setBacklight(255);

  } else if (show == 1) {
    lcd.clear();
    lcd.print("Cursor On");
    lcd.cursor();

  } else if (show == 2) {
    lcd.clear();
    lcd.print("Cursor Blink");
    lcd.blink();

  } else if (show == 3) {
    lcd.clear();
    lcd.print("Cursor OFF");
    lcd.noBlink();
    lcd.noCursor();

  } else if (show == 4) {
    lcd.clear();
    lcd.print("Display Off");
    lcd.noDisplay();

  } else if (show == 5) {
    lcd.clear();
    lcd.print("Display On");
    lcd.display();

  } else if (show == 7) {
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print("*** first line.");
    lcd.setCursor(0, 1);
    lcd.print("*** second line.");

  } else if (show == 8) {
    lcd.scrollDisplayLeft();
  } else if (show == 9) {
    lcd.scrollDisplayLeft();
  } else if (show == 10) {
    lcd.scrollDisplayLeft();
  } else if (show == 11) {
    lcd.scrollDisplayRight();
  } // if

  delay(2000);
  show = (show + 1) % 12;
} // loop()
