/* USER CODE BEGIN Header */
/* *****************************************************************************
 * File:      main.h
 * Date:      19 Apr 2024
 * Author:    Andrew Levido
 *
 * Main header file - mostly produced by Cube MX based on code.ioc. Includes
 * user-defined flash error codes
 *
 ******************************************************************************/
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32g0xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */
/* Error flash codes*/
#define ERR_CODE_HAL      1   // HAL error: Error_Handler()
#define ERR_CODE_NMI      2   // NMI exception
#define ERR_CODE_HARD     3   // Hard Fault exception
#define ERR_CODE_SVC      4   // SVC exception
#define ERR_CODE_PENDSV   5   // PendSV exception
#define ERR_CODE_IO_DRV   7   // IO driver fault

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

void HAL_TIM_MspPostInit(TIM_HandleTypeDef *htim);

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */
void error_flash(uint8_t code);
/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define IMSC_PWM_DEADTIME 2
#define IMSC_IO_SCAN_PRESCALE 64
#define IMSC_PWM_RELOAD 2047
#define IMSC_IO_SCAN_PERIOD 20000
#define IMSC_IO_SCAN_IRQn TIM17_IRQn
#define IMSC_PWM_FILT 7
#define RUN_Pin GPIO_PIN_9
#define RUN_GPIO_Port GPIOB
#define nESTOP_Pin GPIO_PIN_14
#define nESTOP_GPIO_Port GPIOC
#define REV_Pin GPIO_PIN_15
#define REV_GPIO_Port GPIOC
#define INT_SPD_Pin GPIO_PIN_0
#define INT_SPD_GPIO_Port GPIOA
#define RAMP_Pin GPIO_PIN_1
#define RAMP_GPIO_Port GPIOA
#define HS_TEMP_Pin GPIO_PIN_2
#define HS_TEMP_GPIO_Port GPIOA
#define EXT_SPD_Pin GPIO_PIN_3
#define EXT_SPD_GPIO_Port GPIOA
#define OUT_RLY_Pin GPIO_PIN_4
#define OUT_RLY_GPIO_Port GPIOA
#define SPD_SW_Pin GPIO_PIN_5
#define SPD_SW_GPIO_Port GPIOA
#define HOT_FLT_Pin GPIO_PIN_6
#define HOT_FLT_GPIO_Port GPIOA
#define PWM_UL_Pin GPIO_PIN_7
#define PWM_UL_GPIO_Port GPIOA
#define PWM_VL_Pin GPIO_PIN_0
#define PWM_VL_GPIO_Port GPIOB
#define PWM_WL_Pin GPIO_PIN_1
#define PWM_WL_GPIO_Port GPIOB
#define PWM_EN_Pin GPIO_PIN_2
#define PWM_EN_GPIO_Port GPIOB
#define PWM_UH_Pin GPIO_PIN_8
#define PWM_UH_GPIO_Port GPIOA
#define PWM_VH_Pin GPIO_PIN_9
#define PWM_VH_GPIO_Port GPIOA
#define SS_BYP_Pin GPIO_PIN_6
#define SS_BYP_GPIO_Port GPIOC
#define PWM_WH_Pin GPIO_PIN_10
#define PWM_WH_GPIO_Port GPIOA
#define FLT_SW_Pin GPIO_PIN_11
#define FLT_SW_GPIO_Port GPIOA
#define BST_SW_Pin GPIO_PIN_12
#define BST_SW_GPIO_Port GPIOA
#define SWDIO_Pin GPIO_PIN_13
#define SWDIO_GPIO_Port GPIOA
#define SWCLK_Pin GPIO_PIN_14
#define SWCLK_GPIO_Port GPIOA
#define FAN_Pin GPIO_PIN_15
#define FAN_GPIO_Port GPIOA
#define _3PH_SW_Pin GPIO_PIN_3
#define _3PH_SW_GPIO_Port GPIOB
#define PPM_SW_Pin GPIO_PIN_4
#define PPM_SW_GPIO_Port GPIOB
#define PPT_SW_Pin GPIO_PIN_5
#define PPT_SW_GPIO_Port GPIOB
#define LED_GRN_Pin GPIO_PIN_6
#define LED_GRN_GPIO_Port GPIOB
#define LED_YEL_Pin GPIO_PIN_7
#define LED_YEL_GPIO_Port GPIOB
#define LED_RED_Pin GPIO_PIN_8
#define LED_RED_GPIO_Port GPIOB

/* USER CODE BEGIN Private defines */

/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
