/* ****************************************************************************
 * File:      debug.h
 * Date:      23 May 2024
 * Author:    Andrew Levido
 *
 * Copyright 2024 Imbrius Pty Ltd - All Rights Reserved
 *
 *****************************************************************************/
#ifndef _debug_H
#define _debug_H

#ifdef __cplusplus
extern "C" {
#endif

/* Description -----------------------------------------------------------------
 * Wrapper for Segger RTT functions to send debug messages over SWD 
 */

/* Includes ------------------------------------------------------------------*/

/* Defines -------------------------------------------------------------------*/
//#define DEBUG_ENABLE                    // Comment out to disable debug output

/* Typedefs & Enumerations ---------------------------------------------------*/

/* Public Functions Declarations ---------------------------------------------*/

/* Task Function -------------------------------------------------------------*/
/** Initialise debug message system. 
 * 
 * Must be called before using dbg_msg() or dbg_printf() functions
 */
void dgb_init(void);

/** Write string to debug console
 * 
 * @param string      pointer to string to write
 */
void dbg_msg(char * string);

/** Write formatted string to debug console
 *
 * printf-style output. Supports c, d, s, u, x, & p conversion specifiers
 * 
 * @param fmt         printf-style formatting string
 * @param ...         variable length argument
 */
void dbg_printf(char * fmt, ...);

/* Interrupt Service Routine Declarations ------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif

/* End debug */