/* *****************************************************************************
 * File:      debug.c
 * Date:      23 May 2024
 * Author:    Andrew Levido
 *
 * Copyright 2024 Imbrius Pty Ltd - All Rights Reserved
 *
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "debug.h"
#include "SEGGER_RTT.h"
#include "stdarg.h"
/* Defines -------------------------------------------------------------------*/


/* Typedefs & Enumerations ---------------------------------------------------*/

/* Global Variables ----------------------------------------------------------*/

/* Private Functions ---------------------------------------------------------*/

/* Public Functions ----------------------------------------------------------*/

void dgb_init(void)
{
  #ifdef DEBUG_ENABLE
  SEGGER_RTT_Init();
  #endif
}

void dbg_msg(char * string)
{
  #ifdef DEBUG_ENABLE
  SEGGER_RTT_WriteString(0, (const char*)string);
  #endif
}

void dbg_printf(char * fmt, ...)
{
  #ifdef DEBUG_ENABLE
  va_list ap;
  va_start(ap, fmt);
  SEGGER_RTT_vprintf(0, (const char*)fmt, &ap);
  va_end(ap);
  #endif
}
/* Interrupt Service Routines ------------------------------------------------*/

/* End debug */