'Turntable Controller Application


'INITIALISE THINGS
option autorun on    'Start running on power up
option explicit      'variables explicitly dimensioned
option console auto  'console polarity adapts to TTL or RS232

'Configure the pins
setpin 43,dout       'power relay for platter
setpin 44,din,pullup 'Platter on switch
setpin 45,din,pullup 'platter off switch
setpin 46,din        'arm at centre groove (Hall Effect sensor = 1)
setpin 48,dout       'servo 1A stylus lift
setpin 49,ain        'servo 1A current monitor
setpin 50,ain        'servo 2A current monitor
setpin 53,dout       'servo 2A tone arm swing

dim liftpos          'pwm for current position
dim liftmin=1        'min lift position pwm
dim liftmax=1.77     'max lift position pwm
dim liftcentre=1.4   'centre servo to allow manual lift
dim liftoverload     'current limit for lift servo
dim armpos           'pwm for current arm position
dim armcentre=1      'pwm for innermost arm position
dim armrest=2        'pwm for outermost arm position
dim armoverload      'current limit for arm servo
dim count

'Startup routine
gosub home           'get tone arm to starting position
print "INIT"
do                   'Monitor the platter switch and centre groove detector
  if pin(44)=0 then
    pin(43)=1        'turn platter on if switch activated
    Print "Platter on"
  elseif pin(45)=0 then
    gosub home
    pin(43)=0        'Platter off
    print "Platter off"
  endif

                     'Look for inner groove
  if pin(46)=0 then  'Hall effect sensor activated
    gosub home       'return the arm to home position and stop platter
  endif
loop

                     'Subroutine to return arm and lift to home positions
home:                'Bring lift and arm to home position
servo 2,50,armcentre 'release the arm for manual use
servo 1,50,(liftmax-liftmin)/2 + liftmin  'release lift - manual
for liftpos=liftmin to liftmax step 0.02  'lift the stylus
  servo 1,50,liftpos
  pause 80
next
for armpos=armcentre to armrest step 0.02 'move arm to rest
  servo 2,50,armpos
  pause 60
next
servo 2,50,armcentre 'release the arm for manual use
for liftpos=liftmax to liftmin step -0.02 'lower the stylus
  servo 1,50,liftpos
  pause 80
next
servo 1,50,(liftmax-liftmin)/2 + liftmin  'release the lift
pin(43)=0
Return

end
