// Uses TimerOne to generate a 58us interrupt for track signal
// APIs for setting packets to speed, functions, function group 2, cv programming, consist programming, most not tested
// separate helper function for addresses to handle long and short (Digitrax mode 0-99=short, 100+=long)

#include "TimerOne.h"

#define DCC_EN_PIN 3
#define DCC_DIR_PIN 10
#define ANALOGOFFSET 84
#define ANALOGSLOPE 0.04666
#define CURRENTLIMIT 0.5

struct loco {unsigned int id=0;byte speed=0;bool dir=0;byte funcs=0;byte func2=0;};
loco dcc;

byte txpacket[10];                        //actual packet being sent
int txpacketlen=0;
volatile bool packetready=0;                       //set to 1 to start, interrupt sets to 0 on done 

void setup() {
  pinMode(DCC_EN_PIN,OUTPUT);
  pinMode(DCC_DIR_PIN,OUTPUT);  
  digitalWrite(DCC_EN_PIN,LOW);     //output off for now
  digitalWrite(DCC_DIR_PIN,LOW);
  Serial.begin(115200);
  dcc.id=3;                               //set loco manually
  dcc.speed=0;
  dcc.dir=0;
  dcc.funcs=0;                            //lights off
  Serial.println("P for power on, p for power off");
  Serial.println("A for lights on, a for lights off");
  Serial.println("Enter a number for speed and direction");
  delay(1000);
  Timer1.initialize(58);                //58us is minimum period
  Timer1.attachInterrupt(setDCCoutput); 
}

void loop() {
  float current;
  static unsigned long tmout=0;
  unsigned long t;
  static int n=0;
  static int s=0;  
  static bool sflag=0;   //direction, 0=forward,1=reverse
  int d;
  int i;
  if(!packetready){     //cycle through four packet types
    switch(n){
      case 0:
        speedpacket128(dcc);          
        //printpacket();
        packetready=1;
        break;
      case 1:
        idlepacket();      
        packetready=1;
        break;
      case 2:
        func1packet(dcc);
        //printpacket();
        packetready=1;
        break;      
      case 3:
        idlepacket();      
        packetready=1;
        break;      
    }
    n=(n+1)&3;
  }
  while(Serial.available()){
    d=Serial.read();
    if(d=='A'){dcc.funcs=dcc.funcs|1;}      //F0 on
    if(d=='a'){dcc.funcs=dcc.funcs&254;}    //F0 off
    if(d=='P'){
      digitalWrite(DCC_EN_PIN,HIGH);        //output on
      Serial.println("Power ON");
    }
    if(d=='p'){
      digitalWrite(DCC_EN_PIN,LOW);        //output off
      Serial.println("Power OFF");
    }
    if((d>='0')&&(d<='9')){s=s*10+d-'0';}   //update internal number
    if(d=='-'){sflag=1;}                    //input negative number for reverse    
    if(d==13){
      if(s>127){s=127;}
      if(s<0){s=0;}
      dcc.speed=s;
      s=0;
      dcc.dir=sflag;
      sflag=0;
      Serial.print("Set to");
      Serial.print(dcc.dir?" reverse ":" forward ");
      Serial.print(dcc.speed);
      Serial.println(dcc.funcs?" and lights on.":" and lights off.");
    }    
  }
  current=analogRead(A0)-ANALOGOFFSET;    //check current
  if(current<0){current=0;}
  current=current*ANALOGSLOPE;
  if(current>CURRENTLIMIT){
    digitalWrite(DCC_EN_PIN,LOW);        //output off
    Serial.println("FAULT: Power OFF");
  }
  t=millis()/200;                     //every 200ms display current
  if(t!=tmout){    
    Serial.print(current,2);
    Serial.println(" Amps");
    tmout=t;
  }
}

void setDCCoutput(){
  static const byte bitmasks[]={0,128,64,32,16,8,4,2,1};
  static char phase=0;                      //0-3, gets double stepped on 1's so 1's get 58us per phase, 0's get 116us per phase
  static bool bittosend=1;
  static char byteptr=-2;                   //which byte of packet are we sending? -2 and -1 are preamble, 0 is first byte
  static char bitptr=0;                     //9 bits per bytes due to '0' start bit
  //do bit twiddling first to minimise jitter
  if(phase==2){                             //first half of cycle
    digitalWrite(DCC_DIR_PIN,LOW);
  }else if(phase>3){                       //second half of cycle
    digitalWrite(DCC_DIR_PIN,HIGH);
    phase=0;                                //next bit
    bitptr++;
    if(bitptr>8){
      bitptr=0;                             //next byte
      byteptr++;
      if(byteptr>=txpacketlen){
        byteptr=-2;                         //ready for next packet
        packetready=0;                      //flag that we're waiting
      }
    }
  }
  if(!packetready){                         //keep sending 1's/preamble if no packet ready
    byteptr=-2;
    bitptr=0;  
  }
  if(phase==0){                             //only do calcs at start of bit
    if(byteptr<0){
      bittosend=1;                          //preamble bits are always one
    }else{
      bittosend=(txpacket[byteptr]&bitmasks[bitptr])?1:0;
    }
  }
  phase++;
  phase+=bittosend;                         //double step on 1's
}

void addchecksum(){                     //add checksum to otherwise formed packet
  byte cx=0;
  for(int i=0;i<txpacketlen;i++){       //calculcate checksum
    cx^=txpacket[i];
  }
  txpacket[txpacketlen]=cx;             //add to end of packet
  txpacketlen++;
}

void idlepacket(){                      //construct an idle packet
  txpacket[0]=255;
  txpacket[1]=0;
  txpacketlen=2;
  addchecksum();
}

void speedpacket128(loco n){            //construct a 128 step speed packet
  setPacketAddress(n);
  txpacket[txpacketlen]=0x3F;                     //128 speed packet
  txpacket[txpacketlen+1]=(n.dir<<7)|(n.speed&127);
  txpacketlen=txpacketlen+2;
  addchecksum();
}

void func1packet(loco n){               //construct a F0-F4 function packet from 0.0.0.F4.F3.F2.F1.F0
  setPacketAddress(n);
  txpacket[txpacketlen]=128|((n.funcs&1)<<4)|((n.funcs&30)>>1);   //shuffle bits around
  txpacketlen=txpacketlen+1;
  addchecksum();  
}

void consistpacket(loco n,int c){       //construct consist assignment packet- assign loco n to consist c, if c<0, loco is reversed
  setPacketAddress(n);
  txpacket[txpacketlen]=18;
  if(c<0){txpacket[txpacketlen]=19;}              //loco is reversed in consist
  txpacket[txpacketlen+1]=(abs(c))&127;             
  txpacketlen=txpacketlen+2;
  addchecksum();
}

void speedpacket28(loco n){             //construct 28 step speed packet
  setPacketAddress(n);
  txpacket[txpacketlen]=0x40|(n.dir<<5)|(n.speed&31);  //28 speed packet, user needs to set speed appropriately
  txpacketlen=txpacketlen+1;
  addchecksum();  
}

void func2apacket(loco n){              //output F5-F8 (F12.F11.F10.F9.F8.F7.F6.F5)
  setPacketAddress(n);
  txpacket[txpacketlen]=0xB0|(n.func2&0xF);       //4 LSB of func2
  txpacketlen=txpacketlen+1;
  addchecksum();  
}

void func2bpacket(loco n){              //output F9-F12 (F12.F11.F10.F9.F8.F7.F6.F5)
  setPacketAddress(n);
  txpacket[txpacketlen]=0xA0|((n.func2&0xF0)>>4); //4 MSB of func2
  txpacketlen=txpacketlen+1;
  addchecksum();  
}

void cvpacket(loco n,int cv, int val){  //program CV with value (NB needs to be sent twice to take effect)
  setPacketAddress(n);
  txpacket[1]=0xEC|((cv&0x300)>>8);     //write CV 2 MSB
  txpacket[2]=cv&0xFF;                  //8 LSB
  txpacket[3]=val&0xFF;                 //data
  txpacketlen=txpacketlen+3;
  addchecksum();    
}

void setPacketAddress(loco n){        //Digitrax mode 0-99=short, 100+=long. No validation performed
  if(n.id<100){
    txpacket[0]=n.id&127;
    txpacketlen=1;    
  }else{
    txpacket[0]=0xC0|((n.id>>8)&0x3F);
    txpacket[1]=n.id&0xFF;
    txpacketlen=2;        
  }
}

void printpacket(){
  Serial.print(txpacketlen);
  Serial.write(':');
  for(int i=0;i<txpacketlen;i++){
    Serial.print(txpacket[i]);
    Serial.write(',');
  }
  Serial.println();
}

