/* 
 * File:   my_i2c.h
 * 
 * Prepared by: S. Denholm
 * 
 */
#ifndef MY_I2C_H
#define	MY_I2C_H

#define I2C1_SCL    TRISBbits_t.TRISB4  // PIC16F1847 pin 10
#define I2C1_SDA	TRISBbits_t.TRISB1  // PIC16F1847 pin 7

//==============================================================================
// Function Prototype declarations
//
// return_type function_name(parameter list)
//==============================================================================
void I2C_Init(unsigned char clock_output);
void I2C_Start(void);
void I2C_RepeatedStart(void);
void I2C_Stop(void);
void I2C_Idle(void);
void I2C_Close(void);
unsigned char I2C_ReadByte(unsigned char acknowledge);
unsigned char I2C_WriteByte(unsigned char data_out);

#endif	/* MY_I2C_H */

