/*
 * File:   my_i2c.c
 *
 * Prepared by: S. Denholm
 */

#include <xc.h>
#include "my_i2c.h"

void I2C_Init(unsigned char clock_output){
SSP1STAT &= 0x3F;                // power on state
SSP1CON1  = 0x00;                // power on state
SSP1CON2  = 0x00;                // power on state
SSP1CON1 |= 0b00001000;          // select serial mode
SSP1STAT |= 0b10000000;          // slew rate on/off
SSP1CON1 |= 0b00100000;          // enable synchronous serial port

SSPADD = clock_output;           // clock = FOSC/(4 * (SSPADD + 1))
}
void I2C_Start(void){
I2C_Idle();
SSP1CON2bits.SEN = 1;
while(SSP1CON2bits.SEN);
}
void I2C_RepeatedStart(void){
I2C_Idle();
SSP1CON2bits.RSEN = 1;
while(SSP1CON2bits.RSEN);
}
void I2C_Stop(void){
I2C_Idle();
SSP1CON2bits.PEN = 1;
}

void I2C_Idle(void){
while((SSP1CON2 & 0x1F) | (SSP1STATbits.R_nW))
continue;
}
void I2C_Close(void){
SSP1CON1 &= 0xDF;
}
unsigned char I2C_ReadByte(unsigned char acknowledge){
unsigned char buffer_I2C = 0;
I2C_Idle();
if(((SSP1CON1&0x0F)==0x08) || ((SSP1CON1&0x0F)==0x0B))	//master mode only
   SSP1CON2bits.RCEN = 1;          // enable master for 1 byte reception
   while (!SSP1STATbits.BF);       // wait until byte received
   buffer_I2C = SSPBUF;            // read byte

I2C_Idle();
if(acknowledge == 1)
  {
   SSP1CON2bits.ACKDT = 0;
   SSP1CON2bits.ACKEN = 1;
   while(SSP1CON2bits.ACKEN);
  }
else
  {
   SSP1CON2bits.ACKDT = 1;
   SSP1CON2bits.ACKEN = 1;
   while(SSP1CON2bits.ACKEN);
  }
return (buffer_I2C);      // return with read byte
}
unsigned char I2C_WriteByte(unsigned char data_out){
I2C_Idle();
SSPBUF = data_out;        // write single byte to SSP1BUF
if(SSP1CON1bits.WCOL)     // test if write collision occurred
return(1);                // if WCOL bit is set return negative #
else
  {
   if(((SSP1CON1&0x0F)==0x08) || ((SSP1CON1&0x0F)==0x0B)) //master mode only
       {
        while(SSP1STATbits.BF);  //wait until write cycle is complete
	I2C_Idle();                  //ensure module is idle
	if(SSP1CON2bits.ACKSTAT)     //test for ACK condition received
	return(2);                   //Return NACK
        else return(0);          //Return ACK
       }
  }return(0);
}

