/* 
 * File:   oled_sh1106.h
 *
 * Graphical display OLED 128x64.
 * OLED Driver: SH1106 (may also work with SSD1306).
 * Interface:   I2C.
 * 
 * Prepared by: S. Denholm
 */

#ifndef OLED_SH1106_H
#define	OLED_SH1106_H

//==============================================================================
//#define OLED_12C_ADDRESS    0x7A // SA0 = 1, R/W = 0 (write mode)
#define OLED_12C_ADDRESS      0x78 // SA0 = 0, R/W = 0 (write mode)

//==============================================================================
// New name for data types (ie. this helps make the coding text more concise)
//==============================================================================
typedef char                     schar;
typedef unsigned char            uchar;
typedef const char               cschar;
typedef const unsigned char      cuchar;
typedef int                      sint;
typedef unsigned int             uint;

//==============================================================================
// Function Prototype declarations
//
// return_type function_name(parameter list)
//==============================================================================
void Oled_Init(void);
void Oled_Delay(void);
void Oled_Reset(void);
void Oled_Command(uchar cmd);
void Oled_WriteRam(uchar dat);
void Oled_SetPointer(uchar seg, uchar page);
void Oled_SetFont(cuchar *_font, uchar _width, uchar _height, uchar _min, uchar _max);
void Oled_WriteChar(uchar c, uchar seg, uchar page);
void Oled_ConstText(cschar *buffer, uchar seg, uchar page);
void Oled_Clear(uchar pattern);

#endif	/* OLED_SH1106_H */

