// lib to allow writing (and thus printing) to a char array
// includes read and write functions (inherits from Stream)
// this is the anonymous version of awriter that uses strlen instead of internal pointers

// includes:
// set(array) -uses existing array
// write(byte)
// clear() sets first to null
// read()- returns -1 on nothing to return
// peek()- returns -1 on nothing to return
// available()

#include "Arduino.h"
#include "cwrite.h"

cwrite::cwrite(){
  //no need to to anything
}

void cwrite::set(char* a){
  _a=a;  //array to work with
}

size_t cwrite::write(uint8_t d){
  int ln=strlen(_a);
  _a[ln]=d;
  _a[ln+1]=0; //ensure null term
  return 1;
}

void cwrite::clear(){
  _a[0]=0;
}

int cwrite::peek(){        //reads/peeks from start (ie FIFO)
  int ln=strlen(_a);
  if(ln>0){
    return _a[0];
  }else{
    return -1;
  }
}

int cwrite::available(){  
  return strlen(_a);
}

int cwrite::read(){        //reads/peeks from start (ie FIFO)
  int ln=strlen(_a);
  int b,i;
  if(ln>0){
    b=_a[0];
    for(i=0;i<ln+1;i++){_a[i]=_a[i+1];} //move everything up by one, including end null
    return b;
  }else{
    return -1;
  }
}

