' *********************************** CONVERTER ***************************************************
'
' Convert 10 MHz to 3.2 MHz
'
' Use AD9850 module and Arduino Nano. Oscillator on AD9850 125 MHz to be replaced by 10 MHz input.
'
' For 3.2MHz output HEX tuning word is 51EB851F
'
' Written by Charles Kosina


$regfile = "M328Pdef.dat"                                   ' Chip description
$hwstack = 160                                              ' make sure stacks big enough
$swstack = 160
$framesize = 160
$crystal = 16000000

Ddrb = &B00_1111                                            ' 0..3 high nybble of data to AD8950
Portb = &B00_0000

Ddrc = &B0000_0111                                          ' PC.0 reset to 8950
Portc = &B1100_0000                                         ' Port C pullups

Ddrd = &B1111_1000                                          ' 4..7 low nybble of data to AD9850
Portd = &B0000_0000                                         '

Waitms 50

' Serial port is for debugging. May be omitted

Config Com1 = 57600 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0


Dim W1 As Byte                                              ' AD9850 loads
Dim W2 As Byte
Dim W3 As Byte
Dim W4 As Byte



Cr Alias &H0D                                               ' carriage return
Lf Alias &H0A                                               ' line feed
Esc Alias &H06
Fq_ud Alias Portc.1
Reset_ad9850 Alias Portc.0
W_clock Alias Portc.2

Print "Frequency Converter"


   Reset_ad9850 = 1                                         ' reset chip
   Waitus 10
   Reset_ad9850 = 0


Ad9850_load:

   W1 = &H51                                                ' 3.2 MHz out for 10 MHz clock
   W2 = &HEB
   W3 = &H85
   W4 = &H1F

   Print Hex(w1);                                           ' Send out too serial port as Debug
   Print Hex(w2);
   Print Hex(w3);
   Print Hex(w4) ; Chr(cr);

   Portb = 0                                                ' W0 = 00000001
   Portd = &B0000_0000
   W_clock = 1                                              ' load first byte
   nop
   W_clock = 0

  ' Because of splitting up the bytes into two nybbles, the high byte is in bottom 4 bits
  ' of Port B and the low byte is in top 4 bits of Port D.

   Portb = &H05
   Portd = &H10
   W_clock = 1                                              ' load 51H
   nop
   W_clock = 0

   Portb = &H0E
   Portd = &HB0
   W_clock = 1                                              ' load EBH
   nop
   W_clock = 0

   Portb = &H08
   Portd = &H50
   W_clock = 1                                              ' load 85H
   nop
   W_clock = 0

   Portb = &H01
   Portd = &HF0
   W_clock = 1                                              ' load 22H
   nop
   W_clock = 0

   Waitus 10
   Fq_ud = 1                                                ' FU_UD pulse
   nop
   Fq_ud = 0
   Waitms 10
   Stop                                                     ' having loaded, just stop processor


