/* RGBLED_Matrix_sketch.ino -- a sketch to try out
 * one or two of the 8x8 RGB LED panels based on
 * the WS2812B 'intelligent' LEDs with controller,
 * using an Arduino Uno or compatible & using the
 * Adafruit_NeoPixel library.
 * 
 * Based on a sketch found on the www.dfrobot.com
 * website
 * Written by Jim Rowe for Silicon Chip, revised 25/9/2019
 */
 
 #include <Adafruit_NeoPixel.h>
 #define PIN 6
 
Adafruit_NeoPixel strip = Adafruit_NeoPixel(64, PIN, NEO_RGB + NEO_KHZ800);
// The first parameter above (64) is the number of pixels in the
// strip/array, while the next parameter (PIN 6) is the Arduino pin number
// used to provide serial data to the strip, & the third parameter
// specifies the pixel wiring format & the bitstream data rate.
// Note that you may have to try various options for the elements in
// the third parameter, to suit different LED array panels. For
// example some panels may need the first element to be NEO_GRB,
// while others may need it to be NEO_RGBW. Also slower panels may
// need the second element to be NEO_KHZ400 rather than NEO_KHZ800.

void setup()
{
    // start serial comms to PC at 115,200 baud, 8N1
  Serial.begin(115200);
  // then send back start message
  Serial.println("Silicon Chip Smart LED Matrix Checkout Sketch");
  Serial.println(" ");
  Serial.println("Send a digit (1-9) to change display mode:");  
  strip.begin();
  strip.show();   // initialise all pixels to 'off'
}

void loop()
{
  char inputChar = 0;
    
  if(Serial.available() >0)
  {
    inputChar = Serial.read();
    Serial.println(inputChar);  // send back the digit to confirm
    // then use it to select desired display mode1
    switch(inputChar)
    {
      case '1':
        rainbow(50);  // produces a changing rainbow effect
        break;
      case '2':
        rainbowCycle(20); // similar, but colours are closer together
        break;
      case '3':
        colorWipe(strip.Color(84,0,3), 50); // makes all LEDs mid green
        break;
      case '4':
        colorWipe(strip.Color(0,84,0), 50); // makes all LEDs mid red
        break;
      case '5':
        colorWipe(strip.Color(0,0,84), 50); // makes all LEDs mid blue
        break;
      case '6':
        theaterChase(strip.Color(127,127,127), 50); // white dots chasing
        break;
      case '7':
        theaterChase(strip.Color(127,0,0), 50); // red dots chasing
        break;
      case '8':
        theaterChase(strip.Color(0,0,127), 50); // blue dots chasing
        break;
      case '9':
        theaterChaseRainbow(50); // chasing rainbows effect
        break;
      }
  }
} // end of main loop
// ----------------------------------------------------------
// ----------------------------------------------------------
// function to 'fill the dots' in sequence, with a colour
void colorWipe(uint32_t c, uint8_t wait)
{
  for(uint16_t i=0; i<strip.numPixels(); i++)
  {
    strip.setPixelColor(i,c);
    strip.show();
    delay(wait);
  }
}

// ----------------------------------------------------------
// function to display a rainbow effect
void rainbow(uint8_t wait)
{
  uint16_t i, j;    // declare variables
  for(j=0; j<256; j++)
  {
    for(i=0; i<strip.numPixels(); i++)
    {
      strip.setPixelColor(i, Wheel((i+j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

// ---------------------------------------------------------
// function to make the rainbow equally distributed (?)
void rainbowCycle(uint8_t wait)
{
  uint16_t i, j;    // declare variables
  for(j=0; j<256*5; j++)
  { // 5 cycles for all colours on wheel
    for(i=0; i<strip.numPixels(); i++)
    {
      strip.setPixelColor(i, Wheel(((i*256/strip.numPixels()) + j) & 255));      
    }
    strip.show();
    delay(wait);
  }
}

// --------------------------------------------------------
// function to display theatre-style crawling lights
void theaterChase(uint32_t c, uint8_t wait)
{
  for(int j=0; j<10; j++)
  { // do 10 cycles of chasing
    for(int q=0; q<3; q++)
    {
      for(uint16_t i=0; i<strip.numPixels(); i=i+3)
      {
        strip.setPixelColor(i+q, c);  // turn every third pixel on
      }
      strip.show();
      delay(wait);
      for(uint16_t i=0; i<strip.numPixels(); i=i+3)
      {
        strip.setPixelColor(i+q, 0); // turn every third pixel off
      }
    }
  }
}

// ---------------------------------------------------------
// function to show crawling lights with rainbow effect
void theaterChaseRainbow(uint8_t wait)
{
  for(int j=0; j<256; j++)
  {   // cycle all 256 colour in the wheel
    for(int q=0; q<3; q++)
    {
      for(uint16_t i=0; i<strip.numPixels(); i=i+3)
      {
        // turn every third pixel on
        strip.setPixelColor(i+q, Wheel((i+j) % 255));
      }
      strip.show();
      delay(wait);
      for(uint16_t i=0; i<strip.numPixels(); i=i+3)
      {
        // turn every third pixel off
        strip.setPixelColor(i+q, 0);
      }
    }
  }
}

// -----------------------------------------------------------
// function to input a value from 0 to 255 to get a colour value
// (the colours transition R - G - B and then back to R)
uint32_t Wheel(byte WheelPos)
{
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85)
  {
    return strip.Color(255 - WheelPos * 3, 0, WheelPos *3);
  }
  if(WheelPos < 170)
  {
    WheelPos -= 85;
    return strip.Color(0, WheelPos *3, 255 - WheelPos *3);
  }
  WheelPos -= 170;
  return strip.Color(WheelPos *3, 255 - WheelPos *3, 0);
}
